/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterRuleBlockType.java,v 1.2 2005/03/24 21:12:26 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Rule Block Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 *     FilterRuleBlockType gives a
 *                 definition for a logical expression made up of a block
 *                 of                  filter rules or other filter rule
 *                 blocks and an associated                  logical operator.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getGroup <em>Group</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getAbstractFilterRule <em>Abstract Filter Rule</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getFilterRuleBlock <em>Filter Rule Block</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#isNegation <em>Negation</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getOperator <em>Operator</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType()
 * @model 
 * @generated
 */
public interface FilterRuleBlockType extends EObject {
	/**
	 * Returns the value of the '<em><b>Group</b></em>' attribute list.
	 * The list contents are of type {@link org.eclipse.emf.ecore.util.FeatureMap.Entry}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Group</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Group</em>' attribute list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType_Group()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.EFeatureMapEntry" many="true"
	 * @generated
	 */
	FeatureMap getGroup();

	/**
	 * Returns the value of the '<em><b>Abstract Filter Rule</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Abstract Filter Rule</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Abstract Filter Rule</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType_AbstractFilterRule()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType" containment="true" resolveProxies="false" transient="true" volatile="true" derived="true"
	 * @generated
	 */
	EList getAbstractFilterRule();

	/**
	 * Returns the value of the '<em><b>Filter Rule Block</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Filter Rule Block</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Filter Rule Block</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType_FilterRuleBlock()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType" containment="true" resolveProxies="false" transient="true" volatile="true" derived="true"
	 * @generated
	 */
	EList getFilterRuleBlock();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType_Name()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Negation</b></em>' attribute.
	 * The default value is <code>"false"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Negation</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Negation</em>' attribute.
	 * @see #isSetNegation()
	 * @see #unsetNegation()
	 * @see #setNegation(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType_Negation()
	 * @model default="false" unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 * @generated
	 */
	boolean isNegation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#isNegation <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Negation</em>' attribute.
	 * @see #isSetNegation()
	 * @see #unsetNegation()
	 * @see #isNegation()
	 * @generated
	 */
	void setNegation(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#isNegation <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetNegation()
	 * @see #isNegation()
	 * @see #setNegation(boolean)
	 * @generated
	 */
	void unsetNegation();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#isNegation <em>Negation</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Negation</em>' attribute is set.
	 * @see #unsetNegation()
	 * @see #isNegation()
	 * @see #setNegation(boolean)
	 * @generated
	 */
	boolean isSetNegation();

	/**
	 * Returns the value of the '<em><b>Operator</b></em>' attribute.
	 * The default value is <code>"AND"</code>.
	 * The literals are from the enumeration {@link org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operator</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operator</em>' attribute.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType
	 * @see #isSetOperator()
	 * @see #unsetOperator()
	 * @see #setOperator(LogicalOperatorType)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#getFilterRuleBlockType_Operator()
	 * @model default="AND" unique="false" unsettable="true" required="true"
	 * @generated
	 */
	LogicalOperatorType getOperator();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getOperator <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operator</em>' attribute.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType
	 * @see #isSetOperator()
	 * @see #unsetOperator()
	 * @see #getOperator()
	 * @generated
	 */
	void setOperator(LogicalOperatorType value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getOperator <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetOperator()
	 * @see #getOperator()
	 * @see #setOperator(LogicalOperatorType)
	 * @generated
	 */
	void unsetOperator();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType#getOperator <em>Operator</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Operator</em>' attribute is set.
	 * @see #unsetOperator()
	 * @see #getOperator()
	 * @see #setOperator(LogicalOperatorType)
	 * @generated
	 */
	boolean isSetOperator();

} // FilterRuleBlockType
