/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: AbstractFilterRuleTypeImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Abstract Filter Rule Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl#getAttributeName <em>Attribute Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl#getAttributeNamePath <em>Attribute Name Path</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl#getAttributeValue <em>Attribute Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl#getImplementationClass <em>Implementation Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.AbstractFilterRuleTypeImpl#isNegation <em>Negation</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class AbstractFilterRuleTypeImpl extends EObjectImpl implements AbstractFilterRuleType {
	/**
	 * The default value of the '{@link #getAttributeName() <em>Attribute Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeName()
	 * @generated
	 * @ordered
	 */
	protected static final String ATTRIBUTE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAttributeName() <em>Attribute Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeName()
	 * @generated
	 * @ordered
	 */
	protected String attributeName = ATTRIBUTE_NAME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAttributeNamePath() <em>Attribute Name Path</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeNamePath()
	 * @generated
	 * @ordered
	 */
	protected PathExpressionType attributeNamePath = null;

	/**
	 * The default value of the '{@link #getAttributeValue() <em>Attribute Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeValue()
	 * @generated
	 * @ordered
	 */
	protected static final String ATTRIBUTE_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAttributeValue() <em>Attribute Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAttributeValue()
	 * @generated
	 * @ordered
	 */
	protected String attributeValue = ATTRIBUTE_VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #getImplementationClass() <em>Implementation Class</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImplementationClass()
	 * @generated
	 * @ordered
	 */
	protected static final String IMPLEMENTATION_CLASS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getImplementationClass() <em>Implementation Class</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImplementationClass()
	 * @generated
	 * @ordered
	 */
	protected String implementationClass = IMPLEMENTATION_CLASS_EDEFAULT;

	/**
	 * The default value of the '{@link #isNegation() <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNegation()
	 * @generated
	 * @ordered
	 */
	protected static final boolean NEGATION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isNegation() <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNegation()
	 * @generated
	 * @ordered
	 */
	protected boolean negation = NEGATION_EDEFAULT;

	/**
	 * This is true if the Negation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean negationESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AbstractFilterRuleTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FilterPackage.eINSTANCE.getAbstractFilterRuleType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAttributeName() {
		return attributeName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttributeName(String newAttributeName) {
		String oldAttributeName = attributeName;
		attributeName = newAttributeName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME, oldAttributeName, attributeName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PathExpressionType getAttributeNamePath() {
		return attributeNamePath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAttributeNamePath(PathExpressionType newAttributeNamePath, NotificationChain msgs) {
		PathExpressionType oldAttributeNamePath = attributeNamePath;
		attributeNamePath = newAttributeNamePath;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH, oldAttributeNamePath, newAttributeNamePath);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttributeNamePath(PathExpressionType newAttributeNamePath) {
		if (newAttributeNamePath != attributeNamePath) {
			NotificationChain msgs = null;
			if (attributeNamePath != null)
				msgs = ((InternalEObject)attributeNamePath).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH, null, msgs);
			if (newAttributeNamePath != null)
				msgs = ((InternalEObject)newAttributeNamePath).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH, null, msgs);
			msgs = basicSetAttributeNamePath(newAttributeNamePath, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH, newAttributeNamePath, newAttributeNamePath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAttributeValue() {
		return attributeValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAttributeValue(String newAttributeValue) {
		String oldAttributeValue = attributeValue;
		attributeValue = newAttributeValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE, oldAttributeValue, attributeValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getImplementationClass() {
		return implementationClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setImplementationClass(String newImplementationClass) {
		String oldImplementationClass = implementationClass;
		implementationClass = newImplementationClass;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS, oldImplementationClass, implementationClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isNegation() {
		return negation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNegation(boolean newNegation) {
		boolean oldNegation = negation;
		negation = newNegation;
		boolean oldNegationESet = negationESet;
		negationESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__NEGATION, oldNegation, negation, !oldNegationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetNegation() {
		boolean oldNegation = negation;
		boolean oldNegationESet = negationESet;
		negation = NEGATION_EDEFAULT;
		negationESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, FilterPackage.ABSTRACT_FILTER_RULE_TYPE__NEGATION, oldNegation, NEGATION_EDEFAULT, oldNegationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetNegation() {
		return negationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
					return basicSetAttributeNamePath(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				return getAttributeName();
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				return getAttributeNamePath();
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				return getAttributeValue();
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				return getImplementationClass();
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__NEGATION:
				return isNegation() ? Boolean.TRUE : Boolean.FALSE;
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				setAttributeName((String)newValue);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				setAttributeNamePath((PathExpressionType)newValue);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				setAttributeValue((String)newValue);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				setImplementationClass((String)newValue);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__NEGATION:
				setNegation(((Boolean)newValue).booleanValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				setAttributeName(ATTRIBUTE_NAME_EDEFAULT);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				setAttributeNamePath((PathExpressionType)null);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				setAttributeValue(ATTRIBUTE_VALUE_EDEFAULT);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				setImplementationClass(IMPLEMENTATION_CLASS_EDEFAULT);
				return;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__NEGATION:
				unsetNegation();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				return ATTRIBUTE_NAME_EDEFAULT == null ? attributeName != null : !ATTRIBUTE_NAME_EDEFAULT.equals(attributeName);
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				return attributeNamePath != null;
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				return ATTRIBUTE_VALUE_EDEFAULT == null ? attributeValue != null : !ATTRIBUTE_VALUE_EDEFAULT.equals(attributeValue);
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				return IMPLEMENTATION_CLASS_EDEFAULT == null ? implementationClass != null : !IMPLEMENTATION_CLASS_EDEFAULT.equals(implementationClass);
			case FilterPackage.ABSTRACT_FILTER_RULE_TYPE__NEGATION:
				return isSetNegation();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (attributeName: ");
		result.append(attributeName);
		result.append(", attributeValue: ");
		result.append(attributeValue);
		result.append(", implementationClass: ");
		result.append(implementationClass);
		result.append(", negation: ");
		if (negationESet) result.append(negation); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //AbstractFilterRuleTypeImpl
