/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterFactoryImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.hyades.logging.adapter.model.internal.filter.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class FilterFactoryImpl extends EFactoryImpl implements FilterFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case FilterPackage.FILTER_CONFIG_TYPE: return createFilterConfigType();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE: return createFilterRuleBlockType();
			case FilterPackage.FILTER_RULE_TYPE: return createFilterRuleType();
			case FilterPackage.NUMERICAL_FILTER_RULE_TYPE: return createNumericalFilterRuleType();
			case FilterPackage.PATH_EXPRESSION_TYPE: return createPathExpressionType();
			case FilterPackage.DOCUMENT_ROOT: return createDocumentRoot();
			case FilterPackage.RANGE_FILTER_RULE_TYPE: return createRangeFilterRuleType();
			case FilterPackage.STRING_FILTER_RULE_TYPE: return createStringFilterRuleType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case FilterPackage.LOGICAL_OPERATOR_TYPE: {
				LogicalOperatorType result = LogicalOperatorType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case FilterPackage.NUMERICAL_RELATIONAL_OPERATOR_TYPE: {
				NumericalRelationalOperatorType result = NumericalRelationalOperatorType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case FilterPackage.RANGE_RELATIONAL_OPERATOR_TYPE: {
				RangeRelationalOperatorType result = RangeRelationalOperatorType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case FilterPackage.STRING_RELATIONAL_OPERATOR_TYPE: {
				StringRelationalOperatorType result = StringRelationalOperatorType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case FilterPackage.LOGICAL_OPERATOR_TYPE_OBJECT:
				return createLogicalOperatorTypeObjectFromString(eDataType, initialValue);
			case FilterPackage.NUMERICAL_RELATIONAL_OPERATOR_TYPE_OBJECT:
				return createNumericalRelationalOperatorTypeObjectFromString(eDataType, initialValue);
			case FilterPackage.RANGE_RELATIONAL_OPERATOR_TYPE_OBJECT:
				return createRangeRelationalOperatorTypeObjectFromString(eDataType, initialValue);
			case FilterPackage.STRING_RELATIONAL_OPERATOR_TYPE_OBJECT:
				return createStringRelationalOperatorTypeObjectFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case FilterPackage.LOGICAL_OPERATOR_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case FilterPackage.NUMERICAL_RELATIONAL_OPERATOR_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case FilterPackage.RANGE_RELATIONAL_OPERATOR_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case FilterPackage.STRING_RELATIONAL_OPERATOR_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case FilterPackage.LOGICAL_OPERATOR_TYPE_OBJECT:
				return convertLogicalOperatorTypeObjectToString(eDataType, instanceValue);
			case FilterPackage.NUMERICAL_RELATIONAL_OPERATOR_TYPE_OBJECT:
				return convertNumericalRelationalOperatorTypeObjectToString(eDataType, instanceValue);
			case FilterPackage.RANGE_RELATIONAL_OPERATOR_TYPE_OBJECT:
				return convertRangeRelationalOperatorTypeObjectToString(eDataType, instanceValue);
			case FilterPackage.STRING_RELATIONAL_OPERATOR_TYPE_OBJECT:
				return convertStringRelationalOperatorTypeObjectToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterConfigType createFilterConfigType() {
		FilterConfigTypeImpl filterConfigType = new FilterConfigTypeImpl();
		return filterConfigType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterRuleBlockType createFilterRuleBlockType() {
		FilterRuleBlockTypeImpl filterRuleBlockType = new FilterRuleBlockTypeImpl();
		return filterRuleBlockType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterRuleType createFilterRuleType() {
		FilterRuleTypeImpl filterRuleType = new FilterRuleTypeImpl();
		return filterRuleType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumericalFilterRuleType createNumericalFilterRuleType() {
		NumericalFilterRuleTypeImpl numericalFilterRuleType = new NumericalFilterRuleTypeImpl();
		return numericalFilterRuleType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PathExpressionType createPathExpressionType() {
		PathExpressionTypeImpl pathExpressionType = new PathExpressionTypeImpl();
		return pathExpressionType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DocumentRoot createDocumentRoot() {
		DocumentRootImpl documentRoot = new DocumentRootImpl();
		return documentRoot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RangeFilterRuleType createRangeFilterRuleType() {
		RangeFilterRuleTypeImpl rangeFilterRuleType = new RangeFilterRuleTypeImpl();
		return rangeFilterRuleType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringFilterRuleType createStringFilterRuleType() {
		StringFilterRuleTypeImpl stringFilterRuleType = new StringFilterRuleTypeImpl();
		return stringFilterRuleType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LogicalOperatorType createLogicalOperatorTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (LogicalOperatorType)FilterFactory.eINSTANCE.createFromString(FilterPackage.eINSTANCE.getLogicalOperatorType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertLogicalOperatorTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return FilterFactory.eINSTANCE.convertToString(FilterPackage.eINSTANCE.getLogicalOperatorType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NumericalRelationalOperatorType createNumericalRelationalOperatorTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (NumericalRelationalOperatorType)FilterFactory.eINSTANCE.createFromString(FilterPackage.eINSTANCE.getNumericalRelationalOperatorType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertNumericalRelationalOperatorTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return FilterFactory.eINSTANCE.convertToString(FilterPackage.eINSTANCE.getNumericalRelationalOperatorType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RangeRelationalOperatorType createRangeRelationalOperatorTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (RangeRelationalOperatorType)FilterFactory.eINSTANCE.createFromString(FilterPackage.eINSTANCE.getRangeRelationalOperatorType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertRangeRelationalOperatorTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return FilterFactory.eINSTANCE.convertToString(FilterPackage.eINSTANCE.getRangeRelationalOperatorType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringRelationalOperatorType createStringRelationalOperatorTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (StringRelationalOperatorType)FilterFactory.eINSTANCE.createFromString(FilterPackage.eINSTANCE.getStringRelationalOperatorType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertStringRelationalOperatorTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return FilterFactory.eINSTANCE.convertToString(FilterPackage.eINSTANCE.getStringRelationalOperatorType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterPackage getFilterPackage() {
		return (FilterPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static FilterPackage getPackage() {
		return FilterPackage.eINSTANCE;
	}

} //FilterFactoryImpl
