/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterPackageImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

import org.eclipse.emf.ecore.xml.type.impl.XMLTypePackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.adapter.impl.AdapterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.ConfigurationPackage;

import org.eclipse.hyades.logging.adapter.model.internal.configuration.impl.ConfigurationPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.context.ContextPackage;

import org.eclipse.hyades.logging.adapter.model.internal.context.impl.ContextPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.ExtractorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.extractor.impl.ExtractorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.filter.AbstractFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.DocumentRoot;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.NumericalRelationalOperatorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.RangeFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.RangeRelationalOperatorType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.FormatterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.formatter.impl.FormatterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterPackage;

import org.eclipse.hyades.logging.adapter.model.internal.outputter.impl.OutputterPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;

import org.eclipse.hyades.logging.adapter.model.internal.parser.impl.ParserPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.impl.SensorPackageImpl;

import org.eclipse.hyades.logging.adapter.model.internal.unit.UnitPackage;

import org.eclipse.hyades.logging.adapter.model.internal.unit.impl.UnitPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class FilterPackageImpl extends EPackageImpl implements FilterPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractFilterRuleTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass filterConfigTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass filterRuleBlockTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass filterRuleTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass numericalFilterRuleTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pathExpressionTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass documentRootEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass rangeFilterRuleTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass stringFilterRuleTypeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum logicalOperatorTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum numericalRelationalOperatorTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum rangeRelationalOperatorTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum stringRelationalOperatorTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType logicalOperatorTypeObjectEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType numericalRelationalOperatorTypeObjectEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType rangeRelationalOperatorTypeObjectEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType stringRelationalOperatorTypeObjectEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private FilterPackageImpl() {
		super(eNS_URI, FilterFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static FilterPackage init() {
		if (isInited) return (FilterPackage)EPackage.Registry.INSTANCE.getEPackage(FilterPackage.eNS_URI);

		// Obtain or create and register package
		FilterPackageImpl theFilterPackage = (FilterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof FilterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new FilterPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		XMLTypePackageImpl.init();

		// Obtain or create and register interdependencies
		ParserPackageImpl theParserPackage = (ParserPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ParserPackage.eNS_URI) instanceof ParserPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ParserPackage.eNS_URI) : ParserPackageImpl.eINSTANCE);
		AdapterPackageImpl theAdapterPackage = (AdapterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(AdapterPackage.eNS_URI) instanceof AdapterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(AdapterPackage.eNS_URI) : AdapterPackageImpl.eINSTANCE);
		ConfigurationPackageImpl theConfigurationPackage = (ConfigurationPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ConfigurationPackage.eNS_URI) instanceof ConfigurationPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ConfigurationPackage.eNS_URI) : ConfigurationPackageImpl.eINSTANCE);
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(UnitPackage.eNS_URI) instanceof UnitPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(UnitPackage.eNS_URI) : UnitPackageImpl.eINSTANCE);
		ContextPackageImpl theContextPackage = (ContextPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ContextPackage.eNS_URI) instanceof ContextPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ContextPackage.eNS_URI) : ContextPackageImpl.eINSTANCE);
		ExtractorPackageImpl theExtractorPackage = (ExtractorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ExtractorPackage.eNS_URI) instanceof ExtractorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ExtractorPackage.eNS_URI) : ExtractorPackageImpl.eINSTANCE);
		FormatterPackageImpl theFormatterPackage = (FormatterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(FormatterPackage.eNS_URI) instanceof FormatterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(FormatterPackage.eNS_URI) : FormatterPackageImpl.eINSTANCE);
		OutputterPackageImpl theOutputterPackage = (OutputterPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(OutputterPackage.eNS_URI) instanceof OutputterPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(OutputterPackage.eNS_URI) : OutputterPackageImpl.eINSTANCE);
		SensorPackageImpl theSensorPackage = (SensorPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) instanceof SensorPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SensorPackage.eNS_URI) : SensorPackageImpl.eINSTANCE);

		// Create package meta-data objects
		theFilterPackage.createPackageContents();
		theParserPackage.createPackageContents();
		theAdapterPackage.createPackageContents();
		theConfigurationPackage.createPackageContents();
		theUnitPackage.createPackageContents();
		theContextPackage.createPackageContents();
		theExtractorPackage.createPackageContents();
		theFormatterPackage.createPackageContents();
		theOutputterPackage.createPackageContents();
		theSensorPackage.createPackageContents();

		// Initialize created meta-data
		theFilterPackage.initializePackageContents();
		theParserPackage.initializePackageContents();
		theAdapterPackage.initializePackageContents();
		theConfigurationPackage.initializePackageContents();
		theUnitPackage.initializePackageContents();
		theContextPackage.initializePackageContents();
		theExtractorPackage.initializePackageContents();
		theFormatterPackage.initializePackageContents();
		theOutputterPackage.initializePackageContents();
		theSensorPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theFilterPackage.freeze();

		return theFilterPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractFilterRuleType() {
		return abstractFilterRuleTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractFilterRuleType_AttributeName() {
		return (EAttribute)abstractFilterRuleTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractFilterRuleType_AttributeNamePath() {
		return (EReference)abstractFilterRuleTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractFilterRuleType_AttributeValue() {
		return (EAttribute)abstractFilterRuleTypeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractFilterRuleType_ImplementationClass() {
		return (EAttribute)abstractFilterRuleTypeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractFilterRuleType_Negation() {
		return (EAttribute)abstractFilterRuleTypeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFilterConfigType() {
		return filterConfigTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFilterConfigType_AbstractFilterRule() {
		return (EReference)filterConfigTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFilterConfigType_FilterRuleBlock() {
		return (EReference)filterConfigTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFilterRuleBlockType() {
		return filterRuleBlockTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFilterRuleBlockType_Group() {
		return (EAttribute)filterRuleBlockTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFilterRuleBlockType_AbstractFilterRule() {
		return (EReference)filterRuleBlockTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getFilterRuleBlockType_FilterRuleBlock() {
		return (EReference)filterRuleBlockTypeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFilterRuleBlockType_Name() {
		return (EAttribute)filterRuleBlockTypeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFilterRuleBlockType_Negation() {
		return (EAttribute)filterRuleBlockTypeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFilterRuleBlockType_Operator() {
		return (EAttribute)filterRuleBlockTypeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getFilterRuleType() {
		return filterRuleTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getFilterRuleType_Operator() {
		return (EAttribute)filterRuleTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getNumericalFilterRuleType() {
		return numericalFilterRuleTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getNumericalFilterRuleType_Operator() {
		return (EAttribute)numericalFilterRuleTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPathExpressionType() {
		return pathExpressionTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPathExpressionType_Group() {
		return (EAttribute)pathExpressionTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPathExpressionType_Node() {
		return (EAttribute)pathExpressionTypeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDocumentRoot() {
		return documentRootEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getDocumentRoot_Mixed() {
		return (EAttribute)documentRootEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_XMLNSPrefixMap() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_XSISchemaLocation() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getDocumentRoot_Filter() {
		return (EReference)documentRootEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getRangeFilterRuleType() {
		return rangeFilterRuleTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getRangeFilterRuleType_Operator() {
		return (EAttribute)rangeFilterRuleTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getStringFilterRuleType() {
		return stringFilterRuleTypeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getStringFilterRuleType_Operator() {
		return (EAttribute)stringFilterRuleTypeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getLogicalOperatorType() {
		return logicalOperatorTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getNumericalRelationalOperatorType() {
		return numericalRelationalOperatorTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getRangeRelationalOperatorType() {
		return rangeRelationalOperatorTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getStringRelationalOperatorType() {
		return stringRelationalOperatorTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getLogicalOperatorTypeObject() {
		return logicalOperatorTypeObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getNumericalRelationalOperatorTypeObject() {
		return numericalRelationalOperatorTypeObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getRangeRelationalOperatorTypeObject() {
		return rangeRelationalOperatorTypeObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EDataType getStringRelationalOperatorTypeObject() {
		return stringRelationalOperatorTypeObjectEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FilterFactory getFilterFactory() {
		return (FilterFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		abstractFilterRuleTypeEClass = createEClass(ABSTRACT_FILTER_RULE_TYPE);
		createEAttribute(abstractFilterRuleTypeEClass, ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME);
		createEReference(abstractFilterRuleTypeEClass, ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH);
		createEAttribute(abstractFilterRuleTypeEClass, ABSTRACT_FILTER_RULE_TYPE__ATTRIBUTE_VALUE);
		createEAttribute(abstractFilterRuleTypeEClass, ABSTRACT_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS);
		createEAttribute(abstractFilterRuleTypeEClass, ABSTRACT_FILTER_RULE_TYPE__NEGATION);

		filterConfigTypeEClass = createEClass(FILTER_CONFIG_TYPE);
		createEReference(filterConfigTypeEClass, FILTER_CONFIG_TYPE__ABSTRACT_FILTER_RULE);
		createEReference(filterConfigTypeEClass, FILTER_CONFIG_TYPE__FILTER_RULE_BLOCK);

		filterRuleBlockTypeEClass = createEClass(FILTER_RULE_BLOCK_TYPE);
		createEAttribute(filterRuleBlockTypeEClass, FILTER_RULE_BLOCK_TYPE__GROUP);
		createEReference(filterRuleBlockTypeEClass, FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE);
		createEReference(filterRuleBlockTypeEClass, FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK);
		createEAttribute(filterRuleBlockTypeEClass, FILTER_RULE_BLOCK_TYPE__NAME);
		createEAttribute(filterRuleBlockTypeEClass, FILTER_RULE_BLOCK_TYPE__NEGATION);
		createEAttribute(filterRuleBlockTypeEClass, FILTER_RULE_BLOCK_TYPE__OPERATOR);

		filterRuleTypeEClass = createEClass(FILTER_RULE_TYPE);
		createEAttribute(filterRuleTypeEClass, FILTER_RULE_TYPE__OPERATOR);

		numericalFilterRuleTypeEClass = createEClass(NUMERICAL_FILTER_RULE_TYPE);
		createEAttribute(numericalFilterRuleTypeEClass, NUMERICAL_FILTER_RULE_TYPE__OPERATOR);

		pathExpressionTypeEClass = createEClass(PATH_EXPRESSION_TYPE);
		createEAttribute(pathExpressionTypeEClass, PATH_EXPRESSION_TYPE__GROUP);
		createEAttribute(pathExpressionTypeEClass, PATH_EXPRESSION_TYPE__NODE);

		documentRootEClass = createEClass(DOCUMENT_ROOT);
		createEAttribute(documentRootEClass, DOCUMENT_ROOT__MIXED);
		createEReference(documentRootEClass, DOCUMENT_ROOT__XMLNS_PREFIX_MAP);
		createEReference(documentRootEClass, DOCUMENT_ROOT__XSI_SCHEMA_LOCATION);
		createEReference(documentRootEClass, DOCUMENT_ROOT__FILTER);

		rangeFilterRuleTypeEClass = createEClass(RANGE_FILTER_RULE_TYPE);
		createEAttribute(rangeFilterRuleTypeEClass, RANGE_FILTER_RULE_TYPE__OPERATOR);

		stringFilterRuleTypeEClass = createEClass(STRING_FILTER_RULE_TYPE);
		createEAttribute(stringFilterRuleTypeEClass, STRING_FILTER_RULE_TYPE__OPERATOR);

		// Create enums
		logicalOperatorTypeEEnum = createEEnum(LOGICAL_OPERATOR_TYPE);
		numericalRelationalOperatorTypeEEnum = createEEnum(NUMERICAL_RELATIONAL_OPERATOR_TYPE);
		rangeRelationalOperatorTypeEEnum = createEEnum(RANGE_RELATIONAL_OPERATOR_TYPE);
		stringRelationalOperatorTypeEEnum = createEEnum(STRING_RELATIONAL_OPERATOR_TYPE);

		// Create data types
		logicalOperatorTypeObjectEDataType = createEDataType(LOGICAL_OPERATOR_TYPE_OBJECT);
		numericalRelationalOperatorTypeObjectEDataType = createEDataType(NUMERICAL_RELATIONAL_OPERATOR_TYPE_OBJECT);
		rangeRelationalOperatorTypeObjectEDataType = createEDataType(RANGE_RELATIONAL_OPERATOR_TYPE_OBJECT);
		stringRelationalOperatorTypeObjectEDataType = createEDataType(STRING_RELATIONAL_OPERATOR_TYPE_OBJECT);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		XMLTypePackageImpl theXMLTypePackage = (XMLTypePackageImpl)EPackage.Registry.INSTANCE.getEPackage(XMLTypePackage.eNS_URI);
		UnitPackageImpl theUnitPackage = (UnitPackageImpl)EPackage.Registry.INSTANCE.getEPackage(UnitPackage.eNS_URI);

		// Add supertypes to classes
		filterConfigTypeEClass.getESuperTypes().add(theUnitPackage.getProcessUnitType());
		filterRuleTypeEClass.getESuperTypes().add(this.getAbstractFilterRuleType());
		numericalFilterRuleTypeEClass.getESuperTypes().add(this.getAbstractFilterRuleType());
		rangeFilterRuleTypeEClass.getESuperTypes().add(this.getAbstractFilterRuleType());
		stringFilterRuleTypeEClass.getESuperTypes().add(this.getAbstractFilterRuleType());

		// Initialize classes and features; add operations and parameters
		initEClass(abstractFilterRuleTypeEClass, AbstractFilterRuleType.class, "AbstractFilterRuleType", IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAbstractFilterRuleType_AttributeName(), theXMLTypePackage.getString(), "attributeName", null, 0, 1, AbstractFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAbstractFilterRuleType_AttributeNamePath(), this.getPathExpressionType(), null, "attributeNamePath", null, 0, 1, AbstractFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAbstractFilterRuleType_AttributeValue(), theXMLTypePackage.getString(), "attributeValue", null, 1, 1, AbstractFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAbstractFilterRuleType_ImplementationClass(), theXMLTypePackage.getString(), "implementationClass", null, 1, 1, AbstractFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAbstractFilterRuleType_Negation(), theXMLTypePackage.getBoolean(), "negation", "false", 0, 1, AbstractFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(filterConfigTypeEClass, FilterConfigType.class, "FilterConfigType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getFilterConfigType_AbstractFilterRule(), this.getAbstractFilterRuleType(), null, "abstractFilterRule", null, 0, 1, FilterConfigType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFilterConfigType_FilterRuleBlock(), this.getFilterRuleBlockType(), null, "filterRuleBlock", null, 0, 1, FilterConfigType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(filterRuleBlockTypeEClass, FilterRuleBlockType.class, "FilterRuleBlockType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFilterRuleBlockType_Group(), ecorePackage.getEFeatureMapEntry(), "group", null, 0, -1, FilterRuleBlockType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getFilterRuleBlockType_AbstractFilterRule(), this.getAbstractFilterRuleType(), null, "abstractFilterRule", null, 0, -1, FilterRuleBlockType.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEReference(getFilterRuleBlockType_FilterRuleBlock(), this.getFilterRuleBlockType(), null, "filterRuleBlock", null, 0, -1, FilterRuleBlockType.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);
		initEAttribute(getFilterRuleBlockType_Name(), theXMLTypePackage.getString(), "name", null, 1, 1, FilterRuleBlockType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFilterRuleBlockType_Negation(), theXMLTypePackage.getBoolean(), "negation", "false", 0, 1, FilterRuleBlockType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getFilterRuleBlockType_Operator(), this.getLogicalOperatorType(), "operator", "AND", 1, 1, FilterRuleBlockType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(filterRuleTypeEClass, FilterRuleType.class, "FilterRuleType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getFilterRuleType_Operator(), theXMLTypePackage.getString(), "operator", null, 1, 1, FilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(numericalFilterRuleTypeEClass, NumericalFilterRuleType.class, "NumericalFilterRuleType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getNumericalFilterRuleType_Operator(), this.getNumericalRelationalOperatorType(), "operator", "equals", 1, 1, NumericalFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pathExpressionTypeEClass, PathExpressionType.class, "PathExpressionType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPathExpressionType_Group(), ecorePackage.getEFeatureMapEntry(), "group", null, 0, -1, PathExpressionType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPathExpressionType_Node(), theXMLTypePackage.getString(), "node", null, 0, -1, PathExpressionType.class, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, IS_DERIVED, IS_ORDERED);

		initEClass(documentRootEClass, DocumentRoot.class, "DocumentRoot", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getDocumentRoot_Mixed(), ecorePackage.getEFeatureMapEntry(), "mixed", null, 0, -1, null, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_XMLNSPrefixMap(), ecorePackage.getEStringToStringMapEntry(), null, "xMLNSPrefixMap", null, 0, -1, null, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_XSISchemaLocation(), ecorePackage.getEStringToStringMapEntry(), null, "xSISchemaLocation", null, 0, -1, null, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getDocumentRoot_Filter(), this.getFilterConfigType(), null, "filter", null, 0, -2, null, IS_TRANSIENT, IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, IS_DERIVED, IS_ORDERED);

		initEClass(rangeFilterRuleTypeEClass, RangeFilterRuleType.class, "RangeFilterRuleType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getRangeFilterRuleType_Operator(), this.getRangeRelationalOperatorType(), "operator", "last", 1, 1, RangeFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(stringFilterRuleTypeEClass, StringFilterRuleType.class, "StringFilterRuleType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStringFilterRuleType_Operator(), this.getStringRelationalOperatorType(), "operator", "equals", 1, 1, StringFilterRuleType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(logicalOperatorTypeEEnum, LogicalOperatorType.class, "LogicalOperatorType");
		addEEnumLiteral(logicalOperatorTypeEEnum, LogicalOperatorType.AND_LITERAL);
		addEEnumLiteral(logicalOperatorTypeEEnum, LogicalOperatorType.OR_LITERAL);

		initEEnum(numericalRelationalOperatorTypeEEnum, NumericalRelationalOperatorType.class, "NumericalRelationalOperatorType");
		addEEnumLiteral(numericalRelationalOperatorTypeEEnum, NumericalRelationalOperatorType.EQUALS_LITERAL);
		addEEnumLiteral(numericalRelationalOperatorTypeEEnum, NumericalRelationalOperatorType.GREATER_THAN_LITERAL);
		addEEnumLiteral(numericalRelationalOperatorTypeEEnum, NumericalRelationalOperatorType.LESS_THAN_LITERAL);
		addEEnumLiteral(numericalRelationalOperatorTypeEEnum, NumericalRelationalOperatorType.GREATER_THAN_OR_EQUAL_LITERAL);
		addEEnumLiteral(numericalRelationalOperatorTypeEEnum, NumericalRelationalOperatorType.LESS_THAN_OR_EQUAL_LITERAL);

		initEEnum(rangeRelationalOperatorTypeEEnum, RangeRelationalOperatorType.class, "RangeRelationalOperatorType");
		addEEnumLiteral(rangeRelationalOperatorTypeEEnum, RangeRelationalOperatorType.LAST_LITERAL);
		addEEnumLiteral(rangeRelationalOperatorTypeEEnum, RangeRelationalOperatorType.FIRST_LITERAL);

		initEEnum(stringRelationalOperatorTypeEEnum, StringRelationalOperatorType.class, "StringRelationalOperatorType");
		addEEnumLiteral(stringRelationalOperatorTypeEEnum, StringRelationalOperatorType.EQUALS_LITERAL);
		addEEnumLiteral(stringRelationalOperatorTypeEEnum, StringRelationalOperatorType.STARTS_WITH_LITERAL);
		addEEnumLiteral(stringRelationalOperatorTypeEEnum, StringRelationalOperatorType.ENDS_WITH_LITERAL);
		addEEnumLiteral(stringRelationalOperatorTypeEEnum, StringRelationalOperatorType.CONTAINS_LITERAL);

		// Initialize data types
		initEDataType(logicalOperatorTypeObjectEDataType, LogicalOperatorType.class, "LogicalOperatorTypeObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);
		initEDataType(numericalRelationalOperatorTypeObjectEDataType, NumericalRelationalOperatorType.class, "NumericalRelationalOperatorTypeObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);
		initEDataType(rangeRelationalOperatorTypeObjectEDataType, RangeRelationalOperatorType.class, "RangeRelationalOperatorTypeObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);
		initEDataType(stringRelationalOperatorTypeObjectEDataType, StringRelationalOperatorType.class, "StringRelationalOperatorTypeObject", IS_SERIALIZABLE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http:///org/eclipse/emf/ecore/util/ExtendedMetaData
		createExtendedMetaDataAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createExtendedMetaDataAnnotations() {
		String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";				
		addAnnotation
		  (abstractFilterRuleTypeEClass, 
		   source, 
		   new String[] {
			 "name", "AbstractFilterRuleType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getAbstractFilterRuleType_AttributeName(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "attributeName"
		   });		
		addAnnotation
		  (getAbstractFilterRuleType_AttributeNamePath(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "attributeNamePath"
		   });		
		addAnnotation
		  (getAbstractFilterRuleType_AttributeValue(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "attributeValue"
		   });		
		addAnnotation
		  (getAbstractFilterRuleType_ImplementationClass(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "implementationClass"
		   });		
		addAnnotation
		  (getAbstractFilterRuleType_Negation(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "negation"
		   });			
		addAnnotation
		  (filterConfigTypeEClass, 
		   source, 
		   new String[] {
			 "name", "FilterConfigType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getFilterConfigType_AbstractFilterRule(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "AbstractFilterRule"
		   });		
		addAnnotation
		  (getFilterConfigType_FilterRuleBlock(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "FilterRuleBlock"
		   });			
		addAnnotation
		  (filterRuleBlockTypeEClass, 
		   source, 
		   new String[] {
			 "name", "FilterRuleBlockType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getFilterRuleBlockType_Group(), 
		   source, 
		   new String[] {
			 "kind", "group",
			 "name", "group:0"
		   });		
		addAnnotation
		  (getFilterRuleBlockType_AbstractFilterRule(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "AbstractFilterRule",
			 "group", "#group:0"
		   });		
		addAnnotation
		  (getFilterRuleBlockType_FilterRuleBlock(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "FilterRuleBlock",
			 "group", "#group:0"
		   });		
		addAnnotation
		  (getFilterRuleBlockType_Name(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "name"
		   });		
		addAnnotation
		  (getFilterRuleBlockType_Negation(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "negation"
		   });		
		addAnnotation
		  (getFilterRuleBlockType_Operator(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "operator"
		   });			
		addAnnotation
		  (filterRuleTypeEClass, 
		   source, 
		   new String[] {
			 "name", "FilterRuleType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getFilterRuleType_Operator(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "operator"
		   });			
		addAnnotation
		  (logicalOperatorTypeEEnum, 
		   source, 
		   new String[] {
			 "name", "LogicalOperatorType"
		   });		
		addAnnotation
		  (logicalOperatorTypeObjectEDataType, 
		   source, 
		   new String[] {
			 "name", "LogicalOperatorType:Object",
			 "baseType", "LogicalOperatorType"
		   });			
		addAnnotation
		  (numericalFilterRuleTypeEClass, 
		   source, 
		   new String[] {
			 "name", "NumericalFilterRuleType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getNumericalFilterRuleType_Operator(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "operator"
		   });			
		addAnnotation
		  (numericalRelationalOperatorTypeEEnum, 
		   source, 
		   new String[] {
			 "name", "NumericalRelationalOperatorType"
		   });		
		addAnnotation
		  (numericalRelationalOperatorTypeObjectEDataType, 
		   source, 
		   new String[] {
			 "name", "NumericalRelationalOperatorType:Object",
			 "baseType", "NumericalRelationalOperatorType"
		   });			
		addAnnotation
		  (pathExpressionTypeEClass, 
		   source, 
		   new String[] {
			 "name", "pathExpressionType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getPathExpressionType_Group(), 
		   source, 
		   new String[] {
			 "kind", "group",
			 "name", "group:0"
		   });		
		addAnnotation
		  (getPathExpressionType_Node(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "node",
			 "group", "#group:0"
		   });		
		addAnnotation
		  (documentRootEClass, 
		   source, 
		   new String[] {
			 "name", "",
			 "kind", "mixed"
		   });		
		addAnnotation
		  (getDocumentRoot_Mixed(), 
		   source, 
		   new String[] {
			 "kind", "elementWildcard",
			 "name", ":mixed"
		   });		
		addAnnotation
		  (getDocumentRoot_XMLNSPrefixMap(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "xmlns:prefix"
		   });		
		addAnnotation
		  (getDocumentRoot_XSISchemaLocation(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "xsi:schemaLocation"
		   });		
		addAnnotation
		  (getDocumentRoot_Filter(), 
		   source, 
		   new String[] {
			 "kind", "element",
			 "name", "Filter",
			 "namespace", "##targetNamespace"
		   });			
		addAnnotation
		  (rangeFilterRuleTypeEClass, 
		   source, 
		   new String[] {
			 "name", "RangeFilterRuleType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getRangeFilterRuleType_Operator(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "operator"
		   });			
		addAnnotation
		  (rangeRelationalOperatorTypeEEnum, 
		   source, 
		   new String[] {
			 "name", "RangeRelationalOperatorType"
		   });		
		addAnnotation
		  (rangeRelationalOperatorTypeObjectEDataType, 
		   source, 
		   new String[] {
			 "name", "RangeRelationalOperatorType:Object",
			 "baseType", "RangeRelationalOperatorType"
		   });			
		addAnnotation
		  (stringFilterRuleTypeEClass, 
		   source, 
		   new String[] {
			 "name", "StringFilterRuleType",
			 "kind", "elementOnly"
		   });		
		addAnnotation
		  (getStringFilterRuleType_Operator(), 
		   source, 
		   new String[] {
			 "kind", "attribute",
			 "name", "operator"
		   });			
		addAnnotation
		  (stringRelationalOperatorTypeEEnum, 
		   source, 
		   new String[] {
			 "name", "StringRelationalOperatorType"
		   });		
		addAnnotation
		  (stringRelationalOperatorTypeObjectEDataType, 
		   source, 
		   new String[] {
			 "name", "StringRelationalOperatorType:Object",
			 "baseType", "StringRelationalOperatorType"
		   });
	}

} //FilterPackageImpl
