/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterRuleBlockTypeImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleBlockType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.LogicalOperatorType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rule Block Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl#getGroup <em>Group</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl#getAbstractFilterRule <em>Abstract Filter Rule</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl#getFilterRuleBlock <em>Filter Rule Block</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl#isNegation <em>Negation</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleBlockTypeImpl#getOperator <em>Operator</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FilterRuleBlockTypeImpl extends EObjectImpl implements FilterRuleBlockType {
	/**
	 * The cached value of the '{@link #getGroup() <em>Group</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGroup()
	 * @generated
	 * @ordered
	 */
	protected FeatureMap group = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isNegation() <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNegation()
	 * @generated
	 * @ordered
	 */
	protected static final boolean NEGATION_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isNegation() <em>Negation</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isNegation()
	 * @generated
	 * @ordered
	 */
	protected boolean negation = NEGATION_EDEFAULT;

	/**
	 * This is true if the Negation attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean negationESet = false;

	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final LogicalOperatorType OPERATOR_EDEFAULT = LogicalOperatorType.AND_LITERAL;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected LogicalOperatorType operator = OPERATOR_EDEFAULT;

	/**
	 * This is true if the Operator attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean operatorESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FilterRuleBlockTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FilterPackage.eINSTANCE.getFilterRuleBlockType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FeatureMap getGroup() {
		if (group == null) {
			group = new BasicFeatureMap(this, FilterPackage.FILTER_RULE_BLOCK_TYPE__GROUP);
		}
		return group;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getAbstractFilterRule() {
		return ((FeatureMap)getGroup()).list(FilterPackage.eINSTANCE.getFilterRuleBlockType_AbstractFilterRule());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFilterRuleBlock() {
		return ((FeatureMap)getGroup()).list(FilterPackage.eINSTANCE.getFilterRuleBlockType_FilterRuleBlock());
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_RULE_BLOCK_TYPE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isNegation() {
		return negation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNegation(boolean newNegation) {
		boolean oldNegation = negation;
		negation = newNegation;
		boolean oldNegationESet = negationESet;
		negationESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_RULE_BLOCK_TYPE__NEGATION, oldNegation, negation, !oldNegationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetNegation() {
		boolean oldNegation = negation;
		boolean oldNegationESet = negationESet;
		negation = NEGATION_EDEFAULT;
		negationESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, FilterPackage.FILTER_RULE_BLOCK_TYPE__NEGATION, oldNegation, NEGATION_EDEFAULT, oldNegationESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetNegation() {
		return negationESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LogicalOperatorType getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(LogicalOperatorType newOperator) {
		LogicalOperatorType oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		boolean oldOperatorESet = operatorESet;
		operatorESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_RULE_BLOCK_TYPE__OPERATOR, oldOperator, operator, !oldOperatorESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetOperator() {
		LogicalOperatorType oldOperator = operator;
		boolean oldOperatorESet = operatorESet;
		operator = OPERATOR_EDEFAULT;
		operatorESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, FilterPackage.FILTER_RULE_BLOCK_TYPE__OPERATOR, oldOperator, OPERATOR_EDEFAULT, oldOperatorESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetOperator() {
		return operatorESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case FilterPackage.FILTER_RULE_BLOCK_TYPE__GROUP:
					return ((InternalEList)getGroup()).basicRemove(otherEnd, msgs);
				case FilterPackage.FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE:
					return ((InternalEList)getAbstractFilterRule()).basicRemove(otherEnd, msgs);
				case FilterPackage.FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK:
					return ((InternalEList)getFilterRuleBlock()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__GROUP:
				return getGroup();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE:
				return getAbstractFilterRule();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK:
				return getFilterRuleBlock();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NAME:
				return getName();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NEGATION:
				return isNegation() ? Boolean.TRUE : Boolean.FALSE;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__OPERATOR:
				return getOperator();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__GROUP:
				getGroup().clear();
				getGroup().addAll((Collection)newValue);
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE:
				getAbstractFilterRule().clear();
				getAbstractFilterRule().addAll((Collection)newValue);
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK:
				getFilterRuleBlock().clear();
				getFilterRuleBlock().addAll((Collection)newValue);
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NAME:
				setName((String)newValue);
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NEGATION:
				setNegation(((Boolean)newValue).booleanValue());
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__OPERATOR:
				setOperator((LogicalOperatorType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__GROUP:
				getGroup().clear();
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE:
				getAbstractFilterRule().clear();
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK:
				getFilterRuleBlock().clear();
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NEGATION:
				unsetNegation();
				return;
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__OPERATOR:
				unsetOperator();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__GROUP:
				return group != null && !group.isEmpty();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__ABSTRACT_FILTER_RULE:
				return !getAbstractFilterRule().isEmpty();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__FILTER_RULE_BLOCK:
				return !getFilterRuleBlock().isEmpty();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__NEGATION:
				return isSetNegation();
			case FilterPackage.FILTER_RULE_BLOCK_TYPE__OPERATOR:
				return isSetOperator();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (group: ");
		result.append(group);
		result.append(", name: ");
		result.append(name);
		result.append(", negation: ");
		if (negationESet) result.append(negation); else result.append("<unset>");
		result.append(", operator: ");
		if (operatorESet) result.append(operator); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //FilterRuleBlockTypeImpl
