/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: FilterRuleTypeImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rule Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.FilterRuleTypeImpl#getOperator <em>Operator</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FilterRuleTypeImpl extends AbstractFilterRuleTypeImpl implements FilterRuleType {
	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final String OPERATOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected String operator = OPERATOR_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FilterRuleTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FilterPackage.eINSTANCE.getFilterRuleType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(String newOperator) {
		String oldOperator = operator;
		operator = newOperator;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.FILTER_RULE_TYPE__OPERATOR, oldOperator, operator));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
					return basicSetAttributeNamePath(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				return getAttributeName();
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				return getAttributeNamePath();
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				return getAttributeValue();
			case FilterPackage.FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				return getImplementationClass();
			case FilterPackage.FILTER_RULE_TYPE__NEGATION:
				return isNegation() ? Boolean.TRUE : Boolean.FALSE;
			case FilterPackage.FILTER_RULE_TYPE__OPERATOR:
				return getOperator();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				setAttributeName((String)newValue);
				return;
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				setAttributeNamePath((PathExpressionType)newValue);
				return;
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				setAttributeValue((String)newValue);
				return;
			case FilterPackage.FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				setImplementationClass((String)newValue);
				return;
			case FilterPackage.FILTER_RULE_TYPE__NEGATION:
				setNegation(((Boolean)newValue).booleanValue());
				return;
			case FilterPackage.FILTER_RULE_TYPE__OPERATOR:
				setOperator((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				setAttributeName(ATTRIBUTE_NAME_EDEFAULT);
				return;
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				setAttributeNamePath((PathExpressionType)null);
				return;
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				setAttributeValue(ATTRIBUTE_VALUE_EDEFAULT);
				return;
			case FilterPackage.FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				setImplementationClass(IMPLEMENTATION_CLASS_EDEFAULT);
				return;
			case FilterPackage.FILTER_RULE_TYPE__NEGATION:
				unsetNegation();
				return;
			case FilterPackage.FILTER_RULE_TYPE__OPERATOR:
				setOperator(OPERATOR_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				return ATTRIBUTE_NAME_EDEFAULT == null ? attributeName != null : !ATTRIBUTE_NAME_EDEFAULT.equals(attributeName);
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				return attributeNamePath != null;
			case FilterPackage.FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				return ATTRIBUTE_VALUE_EDEFAULT == null ? attributeValue != null : !ATTRIBUTE_VALUE_EDEFAULT.equals(attributeValue);
			case FilterPackage.FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				return IMPLEMENTATION_CLASS_EDEFAULT == null ? implementationClass != null : !IMPLEMENTATION_CLASS_EDEFAULT.equals(implementationClass);
			case FilterPackage.FILTER_RULE_TYPE__NEGATION:
				return isSetNegation();
			case FilterPackage.FILTER_RULE_TYPE__OPERATOR:
				return OPERATOR_EDEFAULT == null ? operator != null : !OPERATOR_EDEFAULT.equals(operator);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operator: ");
		result.append(operator);
		result.append(')');
		return result.toString();
	}

} //FilterRuleTypeImpl
