/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: StringFilterRuleTypeImpl.java,v 1.2 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.filter.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.hyades.logging.adapter.model.internal.filter.FilterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.filter.PathExpressionType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.StringFilterRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.filter.StringRelationalOperatorType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>String Filter Rule Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.filter.impl.StringFilterRuleTypeImpl#getOperator <em>Operator</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class StringFilterRuleTypeImpl extends AbstractFilterRuleTypeImpl implements StringFilterRuleType {
	/**
	 * The default value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected static final StringRelationalOperatorType OPERATOR_EDEFAULT = StringRelationalOperatorType.EQUALS_LITERAL;

	/**
	 * The cached value of the '{@link #getOperator() <em>Operator</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperator()
	 * @generated
	 * @ordered
	 */
	protected StringRelationalOperatorType operator = OPERATOR_EDEFAULT;

	/**
	 * This is true if the Operator attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean operatorESet = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringFilterRuleTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return FilterPackage.eINSTANCE.getStringFilterRuleType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StringRelationalOperatorType getOperator() {
		return operator;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperator(StringRelationalOperatorType newOperator) {
		StringRelationalOperatorType oldOperator = operator;
		operator = newOperator == null ? OPERATOR_EDEFAULT : newOperator;
		boolean oldOperatorESet = operatorESet;
		operatorESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, FilterPackage.STRING_FILTER_RULE_TYPE__OPERATOR, oldOperator, operator, !oldOperatorESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetOperator() {
		StringRelationalOperatorType oldOperator = operator;
		boolean oldOperatorESet = operatorESet;
		operator = OPERATOR_EDEFAULT;
		operatorESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, FilterPackage.STRING_FILTER_RULE_TYPE__OPERATOR, oldOperator, OPERATOR_EDEFAULT, oldOperatorESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetOperator() {
		return operatorESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
					return basicSetAttributeNamePath(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				return getAttributeName();
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				return getAttributeNamePath();
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				return getAttributeValue();
			case FilterPackage.STRING_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				return getImplementationClass();
			case FilterPackage.STRING_FILTER_RULE_TYPE__NEGATION:
				return isNegation() ? Boolean.TRUE : Boolean.FALSE;
			case FilterPackage.STRING_FILTER_RULE_TYPE__OPERATOR:
				return getOperator();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				setAttributeName((String)newValue);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				setAttributeNamePath((PathExpressionType)newValue);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				setAttributeValue((String)newValue);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				setImplementationClass((String)newValue);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__NEGATION:
				setNegation(((Boolean)newValue).booleanValue());
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__OPERATOR:
				setOperator((StringRelationalOperatorType)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				setAttributeName(ATTRIBUTE_NAME_EDEFAULT);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				setAttributeNamePath((PathExpressionType)null);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				setAttributeValue(ATTRIBUTE_VALUE_EDEFAULT);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				setImplementationClass(IMPLEMENTATION_CLASS_EDEFAULT);
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__NEGATION:
				unsetNegation();
				return;
			case FilterPackage.STRING_FILTER_RULE_TYPE__OPERATOR:
				unsetOperator();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME:
				return ATTRIBUTE_NAME_EDEFAULT == null ? attributeName != null : !ATTRIBUTE_NAME_EDEFAULT.equals(attributeName);
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_NAME_PATH:
				return attributeNamePath != null;
			case FilterPackage.STRING_FILTER_RULE_TYPE__ATTRIBUTE_VALUE:
				return ATTRIBUTE_VALUE_EDEFAULT == null ? attributeValue != null : !ATTRIBUTE_VALUE_EDEFAULT.equals(attributeValue);
			case FilterPackage.STRING_FILTER_RULE_TYPE__IMPLEMENTATION_CLASS:
				return IMPLEMENTATION_CLASS_EDEFAULT == null ? implementationClass != null : !IMPLEMENTATION_CLASS_EDEFAULT.equals(implementationClass);
			case FilterPackage.STRING_FILTER_RULE_TYPE__NEGATION:
				return isSetNegation();
			case FilterPackage.STRING_FILTER_RULE_TYPE__OPERATOR:
				return isSetOperator();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operator: ");
		if (operatorESet) result.append(operator); else result.append("<unset>");
		result.append(')');
		return result.toString();
	}

} //StringFilterRuleTypeImpl
