/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: RuleElementTypeImpl.java,v 1.11 2005/03/24 21:12:25 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.impl;

import java.math.BigInteger;
import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.util.Guid;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rule Element Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#getRuleElement <em>Rule Element</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#getRuleAttribute <em>Rule Attribute</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#getIndex <em>Index</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#isIsChildChoice <em>Is Child Choice</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#isIsRequiredByParent <em>Is Required By Parent</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.impl.RuleElementTypeImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RuleElementTypeImpl extends EObjectImpl implements RuleElementType {
	/**
	 * The cached value of the '{@link #getRuleElement() <em>Rule Element</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuleElement()
	 * @generated
	 * @ordered
	 */
	protected EList ruleElement = null;

	/**
	 * The cached value of the '{@link #getRuleAttribute() <em>Rule Attribute</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuleAttribute()
	 * @generated
	 * @ordered
	 */
	protected EList ruleAttribute = null;

	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final BigInteger ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected BigInteger id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getIndex() <em>Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndex()
	 * @generated
	 * @ordered
	 */
	protected static final String INDEX_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIndex() <em>Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIndex()
	 * @generated
	 * @ordered
	 */
	protected String index = INDEX_EDEFAULT;

	/**
	 * The default value of the '{@link #isIsChildChoice() <em>Is Child Choice</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsChildChoice()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_CHILD_CHOICE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsChildChoice() <em>Is Child Choice</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsChildChoice()
	 * @generated
	 * @ordered
	 */
	protected boolean isChildChoice = IS_CHILD_CHOICE_EDEFAULT;

	/**
	 * This is true if the Is Child Choice attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean isChildChoiceESet = false;

	/**
	 * The default value of the '{@link #isIsRequiredByParent() <em>Is Required By Parent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsRequiredByParent()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_REQUIRED_BY_PARENT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIsRequiredByParent() <em>Is Required By Parent</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIsRequiredByParent()
	 * @generated
	 * @ordered
	 */
	protected boolean isRequiredByParent = IS_REQUIRED_BY_PARENT_EDEFAULT;

	/**
	 * This is true if the Is Required By Parent attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean isRequiredByParentESet = false;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected RuleElementTypeImpl() {
		super();
		index = (new Guid()).toString();		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ParserPackage.eINSTANCE.getRuleElementType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRuleElement() {
		if (ruleElement == null) {
			ruleElement = new EObjectContainmentEList(RuleElementType.class, this, ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT);
		}
		return ruleElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRuleAttribute() {
		if (ruleAttribute == null) {
			ruleAttribute = new EObjectContainmentEList(RuleAttributeType.class, this, ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE);
		}
		return ruleAttribute;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BigInteger getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(BigInteger newId) {
		BigInteger oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ELEMENT_TYPE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIndex() {
		return index;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIndex(String newIndex) {
		String oldIndex = index;
		index = newIndex;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ELEMENT_TYPE__INDEX, oldIndex, index));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsChildChoice() {
		return isChildChoice;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsChildChoice(boolean newIsChildChoice) {
		boolean oldIsChildChoice = isChildChoice;
		isChildChoice = newIsChildChoice;
		boolean oldIsChildChoiceESet = isChildChoiceESet;
		isChildChoiceESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ELEMENT_TYPE__IS_CHILD_CHOICE, oldIsChildChoice, isChildChoice, !oldIsChildChoiceESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetIsChildChoice() {
		boolean oldIsChildChoice = isChildChoice;
		boolean oldIsChildChoiceESet = isChildChoiceESet;
		isChildChoice = IS_CHILD_CHOICE_EDEFAULT;
		isChildChoiceESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ParserPackage.RULE_ELEMENT_TYPE__IS_CHILD_CHOICE, oldIsChildChoice, IS_CHILD_CHOICE_EDEFAULT, oldIsChildChoiceESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetIsChildChoice() {
		return isChildChoiceESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIsRequiredByParent() {
		return isRequiredByParent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsRequiredByParent(boolean newIsRequiredByParent) {
		boolean oldIsRequiredByParent = isRequiredByParent;
		isRequiredByParent = newIsRequiredByParent;
		boolean oldIsRequiredByParentESet = isRequiredByParentESet;
		isRequiredByParentESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ELEMENT_TYPE__IS_REQUIRED_BY_PARENT, oldIsRequiredByParent, isRequiredByParent, !oldIsRequiredByParentESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetIsRequiredByParent() {
		boolean oldIsRequiredByParent = isRequiredByParent;
		boolean oldIsRequiredByParentESet = isRequiredByParentESet;
		isRequiredByParent = IS_REQUIRED_BY_PARENT_EDEFAULT;
		isRequiredByParentESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ParserPackage.RULE_ELEMENT_TYPE__IS_REQUIRED_BY_PARENT, oldIsRequiredByParent, IS_REQUIRED_BY_PARENT_EDEFAULT, oldIsRequiredByParentESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetIsRequiredByParent() {
		return isRequiredByParentESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ParserPackage.RULE_ELEMENT_TYPE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT:
					return ((InternalEList)getRuleElement()).basicRemove(otherEnd, msgs);
				case ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE:
					return ((InternalEList)getRuleAttribute()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT:
				return getRuleElement();
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE:
				return getRuleAttribute();
			case ParserPackage.RULE_ELEMENT_TYPE__ID:
				return getId();
			case ParserPackage.RULE_ELEMENT_TYPE__INDEX:
				return getIndex();
			case ParserPackage.RULE_ELEMENT_TYPE__IS_CHILD_CHOICE:
				return isIsChildChoice() ? Boolean.TRUE : Boolean.FALSE;
			case ParserPackage.RULE_ELEMENT_TYPE__IS_REQUIRED_BY_PARENT:
				return isIsRequiredByParent() ? Boolean.TRUE : Boolean.FALSE;
			case ParserPackage.RULE_ELEMENT_TYPE__NAME:
				return getName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT:
				getRuleElement().clear();
				getRuleElement().addAll((Collection)newValue);
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE:
				getRuleAttribute().clear();
				getRuleAttribute().addAll((Collection)newValue);
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__ID:
				setId((BigInteger)newValue);
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__INDEX:
				setIndex((String)newValue);
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__IS_CHILD_CHOICE:
				setIsChildChoice(((Boolean)newValue).booleanValue());
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__IS_REQUIRED_BY_PARENT:
				setIsRequiredByParent(((Boolean)newValue).booleanValue());
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__NAME:
				setName((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT:
				getRuleElement().clear();
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE:
				getRuleAttribute().clear();
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__ID:
				setId(ID_EDEFAULT);
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__INDEX:
				setIndex(INDEX_EDEFAULT);
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__IS_CHILD_CHOICE:
				unsetIsChildChoice();
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__IS_REQUIRED_BY_PARENT:
				unsetIsRequiredByParent();
				return;
			case ParserPackage.RULE_ELEMENT_TYPE__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ELEMENT:
				return ruleElement != null && !ruleElement.isEmpty();
			case ParserPackage.RULE_ELEMENT_TYPE__RULE_ATTRIBUTE:
				return ruleAttribute != null && !ruleAttribute.isEmpty();
			case ParserPackage.RULE_ELEMENT_TYPE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case ParserPackage.RULE_ELEMENT_TYPE__INDEX:
				return INDEX_EDEFAULT == null ? index != null : !INDEX_EDEFAULT.equals(index);
			case ParserPackage.RULE_ELEMENT_TYPE__IS_CHILD_CHOICE:
				return isSetIsChildChoice();
			case ParserPackage.RULE_ELEMENT_TYPE__IS_REQUIRED_BY_PARENT:
				return isSetIsRequiredByParent();
			case ParserPackage.RULE_ELEMENT_TYPE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", index: ");
		result.append(index);
		result.append(", isChildChoice: ");
		if (isChildChoiceESet) result.append(isChildChoice); else result.append("<unset>");
		result.append(", isRequiredByParent: ");
		if (isRequiredByParentESet) result.append(isRequiredByParent); else result.append("<unset>");
		result.append(", name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //RuleElementTypeImpl
