/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SensorFactoryImpl.java,v 1.10 2005/03/24 21:12:27 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.sensor.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.*;

import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SensorFactoryImpl extends EFactoryImpl implements SensorFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case SensorPackage.ADAPTER_CBE_SENSOR_TYPE: return createAdapterCBESensorType();
			case SensorPackage.SENSOR_BASE_TYPE: return createSensorBaseType();
			case SensorPackage.SENSOR_CONFIG_TYPE: return createSensorConfigType();
			case SensorPackage.SENSOR_PROPERTY_TYPE: return createSensorPropertyType();
			case SensorPackage.SINGLE_FILE_SENSOR_TYPE: return createSingleFileSensorType();
			case SensorPackage.STATIC_PARSER_SENSOR_TYPE: return createStaticParserSensorType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case SensorPackage.SENSOR_TYPE: {
				SensorType result = SensorType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case SensorPackage.SENSOR_TYPE_OBJECT:
				return createSensorTypeObjectFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case SensorPackage.SENSOR_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case SensorPackage.SENSOR_TYPE_OBJECT:
				return convertSensorTypeObjectToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AdapterCBESensorType createAdapterCBESensorType() {
		AdapterCBESensorTypeImpl adapterCBESensorType = new AdapterCBESensorTypeImpl();
		return adapterCBESensorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorBaseType createSensorBaseType() {
		SensorBaseTypeImpl sensorBaseType = new SensorBaseTypeImpl();
		return sensorBaseType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorConfigType createSensorConfigType() {
		SensorConfigTypeImpl sensorConfigType = new SensorConfigTypeImpl();
		return sensorConfigType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorPropertyType createSensorPropertyType() {
		SensorPropertyTypeImpl sensorPropertyType = new SensorPropertyTypeImpl();
		return sensorPropertyType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SingleFileSensorType createSingleFileSensorType() {
		SingleFileSensorTypeImpl singleFileSensorType = new SingleFileSensorTypeImpl();
		return singleFileSensorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticParserSensorType createStaticParserSensorType() {
		StaticParserSensorTypeImpl staticParserSensorType = new StaticParserSensorTypeImpl();
		return staticParserSensorType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorType createSensorTypeObjectFromString(EDataType eDataType, String initialValue) {
		return (SensorType)SensorFactory.eINSTANCE.createFromString(SensorPackage.eINSTANCE.getSensorType(), initialValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertSensorTypeObjectToString(EDataType eDataType, Object instanceValue) {
		return SensorFactory.eINSTANCE.convertToString(SensorPackage.eINSTANCE.getSensorType(), instanceValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SensorPackage getSensorPackage() {
		return (SensorPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static SensorPackage getPackage() {
		return SensorPackage.eINSTANCE;
	}

} //SensorFactoryImpl
