/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.execution.local.file.FileManagerFactory;
import org.eclipse.hyades.internal.execution.local.common.Console;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;

public class NodeImpl
implements INode {
    private String name;
    private Object sessionLock = new Object();
    private boolean connected = false;
    private static final boolean DEBUG = false;
    IFileManagerExtended fileManager;
    private Node node;

    public NodeImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ISession connect(String daemonType, Principal principal, int iterations) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        ISession sessionInstance = this._connect(daemonType, principal);
        this.fileManager = FileManagerFactory.getInstance().createTimed(this.node.getConnection(), iterations);
        return sessionInstance;
    }

    public ISession connect(String daemonType, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        ISession sessionInstance = this._connect(daemonType, principal);
        this.fileManager = FileManagerFactory.getInstance().create(this.node.getConnection());
        return sessionInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ISession _connect(String daemonType, Principal principal) throws UnknownDaemonException, DaemonConnectException, UnknownHostException {
        try {
            this.node = principal == null ? NodeFactory.createNode(this.name) : NodeFactory.createNode(this.name, principal);
        }
        catch (DuplicateUserException e) {
            throw e;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        try {
            this.node.connect(Integer.parseInt(daemonType));
        }
        catch (SecureConnectionRequiredException e) {
            throw e;
        }
        catch (LoginFailedException e) {
            throw e;
        }
        catch (AgentControllerUnavailableException e) {
            throw e;
        }
        rprocess = ProcessFactory.createProcess(this.node, "HyadesTestingSession");
        ragent = AgentFactory.createAgent(rprocess, "RemoteSession", "HyadesSession");
        ragent.setAutoAttach(true);
        sessionInstance = new SessionStub((IExecutionComponent)new SessionImpl(this, ragent));
        Marshaller.addInstanceToMap((Integer)sessionInstance.getUniqueId(), (Object)sessionInstance);
        try {
            rprocess.setParameters("org.eclipse.hyades.execution.remote.NodeImpl " + sessionInstance.getUniqueId().toString());
        }
        catch (ProcessActiveException e) {
            // empty catch block
        }
        processListener = new ProcessListener(){

            public void processLaunched(Process process) {
            }

            public void processExited(Process process) {
                NodeImpl.this.releaseSessionLock();
            }
        };
        rprocess.addProcessListener(processListener);
        stateChangeListener = new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent event) {
                if (event.getState() == 2) {
                    NodeImpl.this.releaseSessionLock();
                }
            }
        };
        sessionInstance.addExecutionComponentStateChangeListener(stateChangeListener);
        try {
            rprocess.launch();
            rprocess.getProcessId();
            if (true) ** GOTO lbl73
        }
        catch (InactiveProcessException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        catch (NoSuchApplicationException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        catch (ProcessActiveException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        catch (NotConnectedException e) {
            this.cleanup(this.node, rprocess, sessionInstance, processListener, stateChangeListener);
            exc = new DaemonConnectException();
            exc.initCause((Throwable)e);
            throw exc;
        }
        do {
            var8_15 = this.sessionLock;
            synchronized (var8_15) {
                try {
                    this.sessionLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
lbl73:
            // 3 sources

        } while (!this.connected);
        rprocess.removeProcessListener(processListener);
        sessionInstance.removeExecutionComponentStateChangeListener(stateChangeListener);
        return sessionInstance;
    }

    private void cleanup(Node node, Process process, ISession sessionInstance, ProcessListener processListener, IExecutionComponentStateChangeListener stateChangeListener) {
        try {
            process.removeProcessListener(processListener);
            Marshaller.removeInstanceFromMap((Integer)((SessionStub)sessionInstance).getUniqueId());
            sessionInstance.removeExecutionComponentStateChangeListener(stateChangeListener);
            node.getConnection().disconnect();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSessionLock() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.connected = true;
            this.sessionLock.notify();
        }
    }

    private void captureConsoleOutput(Process process) {
        Console console = process.getConsole();
        console.setDataProcessor(new DataProcessor(){

            public void incommingData(byte[] buffer, int length, InetAddress peer) {
                System.out.print("====>");
                System.out.print(new String(buffer, 0, length));
                System.out.flush();
            }

            public void incommingData(char[] buffer, int length, InetAddress peer) {
                System.out.print("====>");
                System.out.print(new String(buffer, 0, length));
                System.out.flush();
            }

            public void invalidDataType(byte[] data, int length, InetAddress peer) {
            }

            public void waitingForData() {
            }
        });
    }

    public IFileManager getFileManager() {
        return this.fileManager;
    }
}

