/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import org.eclipse.hyades.internal.execution.local.control.CommandHandler;

public class ContextMapper {
    protected static final int MAPPING_INCREMENT = 10;
    protected ContextMap[] _map = new ContextMap[10];
    protected int _mappingCount = 0;
    protected int _maxMappingCount = 0;
    private boolean DEBUG = false;

    public ContextMapper() {
        if (this.DEBUG) {
            Thread monitor = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        try {
                            1 var1_2 = this;
                            synchronized (var1_2) {
                                this.wait(30000L);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        System.err.println("====================================================================================");
                        System.err.println("[" + ContextMapper.this._map.length + " items in the context mapper map");
                        int i = 0;
                        while (i < ContextMapper.this._mappingCount) {
                            System.err.println(ContextMapper.this._map[i]._context + " -> " + ContextMapper.this._map[i]._handler);
                            ++i;
                        }
                        System.err.println("====================================================================================");
                    }
                }
            };
            monitor.setName("ContextMapper Monitor");
            monitor.setDaemon(true);
            monitor.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContext(long contextId, CommandHandler handler) {
        ContextMap[] contextMapArray = this._map;
        synchronized (this._map) {
            if (this._maxMappingCount == this._map.length) {
                this.increaseContextmappingCapacity();
            }
            int i = this._mappingCount;
            while (i >= 0) {
                if (this._map[i] == null) {
                    ++this._mappingCount;
                    ++this._maxMappingCount;
                    this._map[i] = new ContextMap();
                    this._map[i]._context = contextId;
                    this._map[i]._handler = handler;
                    this._map[i]._dirty = true;
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                if (!this._map[i]._dirty) {
                    ++this._mappingCount;
                    this._map[i]._context = contextId;
                    this._map[i]._handler = handler;
                    this._map[i]._dirty = true;
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                --i;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandHandler getHandler(long contextid) {
        CommandHandler ch = null;
        ContextMap[] contextMapArray = this._map;
        synchronized (this._map) {
            int i = this._maxMappingCount - 1;
            while (i >= 0) {
                if (this._map[i] == null) break;
                if (this._map[i]._context == contextid && this._map[i]._dirty) {
                    ch = this._map[i]._handler;
                    break;
                }
                --i;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return ch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void increaseContextmappingCapacity() {
        ContextMap[] contextMapArray = this._map;
        synchronized (this._map) {
            ContextMap[] newMapper = new ContextMap[this._maxMappingCount + 10];
            int i = 0;
            while (i < this._maxMappingCount) {
                newMapper[i] = this._map[i];
                ++i;
            }
            this._map = newMapper;
            Object var2_2 = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(long contextId) {
        ContextMap[] contextMapArray = this._map;
        synchronized (this._map) {
            int i = this._maxMappingCount - 1;
            while (i >= 0) {
                if (this._map[i]._context == contextId && this._map[i]._dirty) {
                    --this._mappingCount;
                    this._map[i]._dirty = false;
                    this._map[i]._handler = null;
                    break;
                }
                --i;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    class ContextMap {
        public long _context = 0L;
        public CommandHandler _handler = null;
        public boolean _dirty = false;

        ContextMap() {
        }
    }
}

