/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.commons;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.IExternalizableToXml;
import org.eclipse.hyades.logging.core.IPreemptedLogger;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

public class Logger
implements Log,
IPreemptedLogger {
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    private static final String[] LEVEL_NAMES = new String[]{"TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    protected LoggingAgent loggingAgent = null;
    private int level = 3;
    private String name = null;
    private static final EventFactory EVENT_FACTORY = EventFactoryContext.getInstance().getSimpleEventFactoryHome().getAnonymousEventFactory();
    private static final EventFactoryHome EVENT_FACTORY_HOME = EventFactoryContext.getInstance().getEventFactoryHome("org.eclipse.hyades.logging.events.cbe.impl.EventXMLFileEventFactoryHomeImpl", (class$org$eclipse$hyades$logging$commons$Logger == null ? (class$org$eclipse$hyades$logging$commons$Logger = Logger.class$("org.eclipse.hyades.logging.commons.Logger")) : class$org$eclipse$hyades$logging$commons$Logger).getClassLoader());
    static /* synthetic */ Class class$org$eclipse$hyades$logging$commons$Logger;

    public Logger(String name) {
        this.name = name;
        this.loggingAgent = new LoggingAgent(name);
        this.configure();
    }

    public boolean isTraceEnabled() {
        return this.level <= 0;
    }

    public boolean isDebugEnabled() {
        return this.level <= 1;
    }

    public boolean isInfoEnabled() {
        return this.level <= 2;
    }

    public boolean isWarnEnabled() {
        return this.level <= 3;
    }

    public boolean isErrorEnabled() {
        return this.level <= 4;
    }

    public boolean isFatalEnabled() {
        return this.level <= 5;
    }

    public void trace(Object record) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void trace(Object record, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void debug(Object record) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void debug(Object record, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void info(Object record) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void info(Object record, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void warn(Object record) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void warn(Object record, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void error(Object record) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void error(Object record, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public void fatal(Object record) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
        }
    }

    public void fatal(Object record, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.loggingAgent.write(this.convertToXML(record));
            this.loggingAgent.write(this.convertToXML(throwable));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelAsString() {
        return LEVEL_NAMES[this.level];
    }

    public synchronized void setLevel(int level) throws IllegalArgumentException {
        if (!this.isValidLevel(level)) {
            throw new IllegalArgumentException("Invalid logging level");
        }
        this.level = level;
    }

    public synchronized void setLevelAsString(String stringLevel) throws IllegalArgumentException {
        this.setLevel(this.getLevelInteger(stringLevel));
    }

    private int getLevelInteger(String levelName) {
        block5: {
            if (levelName == null || levelName.trim().length() == 0) break block5;
            String tempLevel = levelName.trim();
            int counter = 0;
            while (counter < LEVEL_NAMES.length) {
                if (tempLevel.equalsIgnoreCase(LEVEL_NAMES[counter])) {
                    return counter;
                }
                ++counter;
            }
            try {
                int levelNum = Integer.parseInt(tempLevel);
                if (this.isValidLevel(levelNum)) {
                    return levelNum;
                }
            }
            catch (NumberFormatException n) {}
        }
        return -1;
    }

    private boolean isValidLevel(int checkLevel) {
        return checkLevel >= 0 || checkLevel <= 5;
    }

    private boolean isValidLevelString(String checkLevel) {
        return this.isValidLevel(this.getLevelInteger(checkLevel));
    }

    private String convertToXML(Object object) {
        if (object instanceof IExternalizableToXml) {
            return ((IExternalizableToXml)object).externalizeCanonicalXmlString();
        }
        CommonBaseEvent commonBaseEvent = EVENT_FACTORY_HOME.getEventFactory(this.name).createCommonBaseEvent();
        try {
            commonBaseEvent.complete();
        }
        catch (CompletionException c) {
            // empty catch block
        }
        EventHelpers.convertObjectToCommonBaseEvent((CommonBaseEvent)commonBaseEvent, (Object)object, (int)4);
        commonBaseEvent.addExtendedDataElement("Logger_Name", this.name);
        commonBaseEvent.addExtendedDataElement("Logging_Level", LEVEL_NAMES[this.level]);
        return EventFormatter.toCanonicalXMLString((CommonBaseEvent)commonBaseEvent, (boolean)true).concat(Constants.LINE_SEPARATOR);
    }

    public final void finalize() {
        this.loggingAgent.deregister();
    }

    public boolean waitUntilLogging(long maxTime) {
        return this.loggingAgent.waitUntilLogging(maxTime);
    }

    public boolean isLogging() {
        return this.loggingAgent.isLogging();
    }

    private void configure() {
        String systemProperty = System.getProperty("org.eclipse.hyades.logging.commons.Logger.Level");
        if (systemProperty != null && systemProperty.trim().length() > 0 && this.isValidLevelString(systemProperty)) {
            this.setLevelAsString(systemProperty);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

