/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;

public class StkEntry
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _method;
    public String _pkg;
    public String _module;
    public int _lineno;
    public boolean _isNative;

    public StkEntry(String string, String string2, String string3, int n, boolean bl) {
        this._version = _curVersion;
        this._method = string;
        this._pkg = string2;
        this._lineno = n;
        this._isNative = bl;
        this._module = string3;
    }

    public String format(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "   ";
            ++n2;
        }
        String string2 = string + "      " + this._pkg + "." + this._method + " " + TAUtils.getNLSValue("ta.string.in", "in") + " " + this._module + " " + TAUtils.getNLSValue("ta.string.native", "native") + "=" + this._isNative;
        return string2;
    }

    public void print(int n) {
        System.out.println(this.format(n));
    }

    public String getFQName() {
        return this._pkg + "." + this._method;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this._version);
        objectOutput.writeObject(this._method);
        objectOutput.writeObject(this._pkg);
        objectOutput.writeObject(this._module);
        objectOutput.writeInt(this._lineno);
        objectOutput.writeBoolean(this._isNative);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._version = objectInput.readInt();
        this._method = (String)objectInput.readObject();
        this._pkg = (String)objectInput.readObject();
        this._module = (String)objectInput.readObject();
        this._lineno = objectInput.readInt();
        this._isNative = objectInput.readBoolean();
    }

    public StkEntry() {
    }
}

