/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.AnalyzerEnv;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.OrbThreadPool;
import org.eclipse.hyades.collection.threadanalyzer.OverallThreadPool;
import org.eclipse.hyades.collection.threadanalyzer.ServletThreadPool;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TOSInfo;
import org.eclipse.hyades.collection.threadanalyzer.TaGridElement;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DumpData
implements Externalizable {
    private static int _curVersion = 2;
    private int _version = -1;
    protected int _totThreads = 0;
    protected int _webWaitThreads = 0;
    protected int _orbWaitThreads = 0;
    protected int _workingOrbThreads = 0;
    protected int _workingWebThreads = 0;
    protected int _unknownThreads = 0;
    protected int _analysisType = 3;
    private int _logLevel = 3;
    public boolean _fHtml = false;
    private Hashtable _threads = null;
    private Hashtable _monitors = null;
    public AnalyzerEnv _env = null;
    protected String _inputFilename = null;
    public int _threadsMissingStacks = 0;
    protected ThreadDump _threadDump = null;
    protected String _description = null;
    protected String _displayName = null;
    protected String dumpParserClassName = null;
    protected String _dumpingJvmName = null;
    protected static final String _sTab = "   ";
    protected transient ResourceBundle _tosTrans = null;
    protected static int _majorVersion = 1;
    protected static int _minorVersion = 1;
    protected transient PrintStream _rptOut = System.out;
    public static final int ANALYZE_SERVLET = 1;
    public static final int ANALYZE_EJB = 2;
    public static final int ANALYZE_WAS = 3;
    public static final int ANALYZE_OTHER = 32768;
    public static final int ANALYZE_ALL = -1;
    private static int _curID = 0;
    public transient Hashtable _threadsByTOS = null;
    public transient TOSInfo _tosInfo = null;
    public transient Vector _threadDetailHelpers = null;
    public transient Vector _monitorDetailHelpers = null;
    private transient Vector deadlockResults = null;
    private transient boolean deadlockExists = false;

    public static synchronized int getID() {
        return ++_curID;
    }

    public DumpData() {
        this._version = _curVersion;
        this._threads = new Hashtable();
        this._monitors = new Hashtable();
        this._threadsByTOS = new Hashtable();
        this._env = new AnalyzerEnv();
        this._fHtml = DumpParser.getArg("reportType").equalsIgnoreCase("html");
        this._threadDump = new ThreadDump();
    }

    public void setDisplayName(String string) {
        this._displayName = string;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDumpingJvmName() {
        return this._dumpingJvmName;
    }

    public void setDumpingJvmName(String string) {
        this._dumpingJvmName = string;
    }

    public void addDumpTextLine(String string, int n) {
        this._threadDump.addLine(string, n);
    }

    public Enumeration getDumpTextEnum() {
        return this._threadDump.getEnumerator();
    }

    public String getNextDumpTextLine(Enumeration enumeration) {
        return this._threadDump.getNextLine(enumeration);
    }

    public void setInputFilename(String string) {
        this._inputFilename = string;
    }

    public Thd addThd(String string, String string2, String string3, String string4) {
        Thd thd = new Thd(string, string2, string3, string4);
        this._threads.put(string2, thd);
        this.logDebug("[DumpData] added thread: " + string + " " + string2);
        return thd;
    }

    public Thd getThd(String string) {
        return (Thd)this._threads.get(string);
    }

    public int getThreadDumpSize() {
        return this._threadDump.getSize();
    }

    public ServletThreadPool getServletThreadPool() {
        return new ServletThreadPool(this);
    }

    public OrbThreadPool getOrbThreadPool() {
        return new OrbThreadPool(this);
    }

    public OverallThreadPool getOverallThreadPool() {
        return new OverallThreadPool(this);
    }

    public void buildCommonTOSLists() {
        Object object;
        Serializable serializable;
        String string;
        if (this._threadsByTOS == null) {
            this._threadsByTOS = new Hashtable();
        }
        Enumeration enumeration = null;
        boolean bl = false;
        enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            Serializable serializable2;
            string = (String)enumeration.nextElement();
            serializable = this.getThd(string);
            int n = Integer.parseInt(((Thd)serializable).getProperty("SIGNIFICANT_TOS_NDX"));
            object = null;
            if (n >= 0) {
                serializable2 = ((Thd)serializable).getStkEntry(n);
                if (serializable2 != null) {
                    object = ((StkEntry)serializable2).getFQName();
                } else {
                    this.logErr("[DumpData] ERROR: stack entry is null");
                }
            } else {
                object = "*** WARNING *** Thread with empty stack";
            }
            serializable2 = (Vector)this._threadsByTOS.get(object);
            if (((Thd)serializable).getName().indexOf("Signal dispatcher") != -1) continue;
            if (serializable2 != null) {
                ((Vector)serializable2).add(serializable);
                continue;
            }
            serializable2 = new Vector();
            ((Vector)serializable2).add(serializable);
            this._threadsByTOS.put(object, serializable2);
        }
        bl = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            serializable = (Vector)this._threadsByTOS.get(string);
            Object object2 = null;
            object = null;
            int n = 0;
            while (n < ((Vector)serializable).size()) {
                object = (Thd)((Vector)serializable).elementAt(n);
                ((Thd)object)._prevByTOS = object2;
                object2 = object;
                if (n + 1 < ((Vector)serializable).size()) {
                    ((Thd)object)._nextByTOS = (Thd)((Vector)serializable).elementAt(n + 1);
                }
                ++n;
            }
        }
    }

    public Monitor addMonitor(String string, int n) {
        Monitor monitor = null;
        string = string.trim();
        monitor = new Monitor(string, n);
        this._monitors.put(string, monitor);
        return monitor;
    }

    public Enumeration getMonitorEnum() {
        Enumeration enumeration = this._monitors.keys();
        return enumeration;
    }

    public Monitor getNextMonitor(Enumeration enumeration) {
        String string = null;
        Monitor monitor = null;
        if (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            monitor = (Monitor)this._monitors.get(string);
        }
        return monitor;
    }

    public Monitor getMonitorById(int n) {
        Enumeration enumeration = this.getMonitorEnum();
        Monitor monitor = this.getNextMonitor(enumeration);
        while (monitor != null) {
            if (monitor.getId() == n) break;
            monitor = this.getNextMonitor(enumeration);
        }
        return monitor;
    }

    public Thd getThreadById(int n) {
        Enumeration enumeration = this.getThreadEnum();
        Thd thd = this.getNextThread(enumeration);
        while (thd != null) {
            if (thd.getId() == n) break;
            thd = this.getNextThread(enumeration);
        }
        return thd;
    }

    public Enumeration getThreadEnum() {
        Enumeration enumeration = this._threads.keys();
        return enumeration;
    }

    public Thd getNextThread(Enumeration enumeration) {
        String string = null;
        Thd thd = null;
        if (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            thd = (Thd)this._threads.get(string);
        }
        return thd;
    }

    public Monitor getHeapLock() {
        Enumeration enumeration = this.getMonitorEnum();
        Monitor monitor = this.getNextMonitor(enumeration);
        while (monitor != null) {
            if (monitor._name.equals("HEAP_LOCK")) {
                return monitor;
            }
            monitor = this.getNextMonitor(enumeration);
        }
        return null;
    }

    public Vector webLockWaiters(Monitor monitor) {
        this.logDebug("Checking monitor: " + monitor.getName() + "  contains " + monitor._waiters.size() + " waiters");
        Vector vector = null;
        if (monitor != null) {
            Vector vector2 = new Vector();
            int n = 0;
            while (n < monitor._waiters.size()) {
                Thd thd = (Thd)monitor._waiters.elementAt(n);
                if (thd.isExecutingWebWork()) {
                    this.logDebug("  thd: " + n + "  is executing web work");
                    vector2.add(monitor._waiters.elementAt(n));
                }
                ++n;
            }
            if (vector2.size() > 0) {
                vector = vector2;
            }
        }
        return vector;
    }

    public Vector orbLockWaiters(Monitor monitor) {
        Vector vector = null;
        if (monitor != null) {
            Vector vector2 = new Vector();
            int n = 0;
            while (n < monitor._waiters.size()) {
                Thd thd = (Thd)monitor._waiters.elementAt(n);
                if (thd.isExecutingRemoteOrbWork()) {
                    vector2.add(monitor._waiters.elementAt(n));
                }
                ++n;
            }
            if (vector2.size() > 0) {
                vector = vector2;
            }
        }
        return vector;
    }

    public void writeTo(String string) throws Exception {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            this.writeExternal(objectOutputStream);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static DumpData readFrom(String string) throws Exception {
        DumpData dumpData = new DumpData();
        FileInputStream fileInputStream = new FileInputStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        dumpData.readExternal(objectInputStream);
        objectInputStream.close();
        return dumpData;
    }

    public void fixupIdRefs() {
        Enumeration enumeration = this.getThreadEnum();
        Thd thd = this.getNextThread(enumeration);
        while (thd != null) {
            Monitor monitor;
            int n = thd.getWaitMonitorId();
            if (n > 0 && (monitor = this.getMonitorById(n)) != null) {
                thd.setWaitMonitor(monitor);
            }
            thd = this.getNextThread(enumeration);
        }
        enumeration = this.getMonitorEnum();
        Monitor monitor = this.getNextMonitor(enumeration);
        while (monitor != null) {
            monitor.fixupWaiters(this);
            monitor = this.getNextMonitor(enumeration);
        }
    }

    public void initAnalysis() {
        Object object;
        int n;
        Object[] objectArray;
        Serializable serializable;
        Object object2;
        this.setAnalysisType();
        this._tosTrans = null;
        try {
            this._tosTrans = ResourceBundle.getBundle("ta_tos_trans");
        }
        catch (Exception exception) {
            object2 = Locale.getDefault();
        }
        this.loadExternalEvaluators(DumpParser.getArg("detailXML"));
        Enumeration enumeration = null;
        object2 = null;
        this.calcMissingThreadStacks();
        enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            serializable = (Thd)this._threads.get(object2);
            objectArray = new Object[]{this._env, serializable};
            this.logDebug(((Thd)serializable).getName() + " has a stack size of: " + ((Thd)serializable).getStkSize() + ". Threads missing stacks is now: " + this._threadsMissingStacks);
            n = 0;
            while (n < this._threadDetailHelpers.size()) {
                object = (Method)this._threadDetailHelpers.elementAt(n);
                try {
                    ((Method)object).invoke(null, objectArray);
                }
                catch (Exception exception) {
                    this.logErr("Exception while executing thread detail helper '" + ((Method)object).getName() + "'");
                    exception.printStackTrace();
                }
                ++n;
            }
        }
        enumeration = this._monitors.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            serializable = (Monitor)this._monitors.get(object2);
            objectArray = new Object[]{this._env, serializable};
            n = 0;
            while (n < this._monitorDetailHelpers.size()) {
                object = (Method)this._monitorDetailHelpers.elementAt(n);
                try {
                    ((Method)object).invoke(null, objectArray);
                }
                catch (Exception exception) {
                    this.logErr("Exception while executing monitor detail helper '" + ((Method)object).getName() + "'");
                }
                ++n;
            }
        }
        serializable = new Vector();
        enumeration = this._monitors.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            ((Vector)serializable).add(object2);
        }
        int n2 = 0;
        while (n2 < ((Vector)serializable).size()) {
            object2 = (String)((Vector)serializable).elementAt(n2);
            Monitor monitor = (Monitor)this._monitors.get(object2);
            object = monitor.getProperty("COALESCE");
            if (object != null && ((String)object).equals("true")) {
                this._monitors.remove(monitor.getName());
                String string = null;
                int n3 = monitor.getName().indexOf(64);
                string = n3 > -1 ? monitor.getName().substring(0, n3) : monitor.getName();
                Monitor monitor2 = (Monitor)this._monitors.get(string);
                if (monitor2 != null) {
                    monitor2._waiters.addAll(monitor._waiters);
                } else {
                    monitor._name = string;
                    this._monitors.put(string, monitor);
                }
            }
            ++n2;
        }
        this.logDebug("DumpData.print - building common TOS lists");
        this.buildCommonTOSLists();
        this._tosInfo = new TOSInfo(this._threadsByTOS);
        this.logDebug("DumpData.print - determining thread breakdown");
        this._totThreads = 0;
        this._unknownThreads = 0;
        this._webWaitThreads = 0;
        this._orbWaitThreads = 0;
        this._workingWebThreads = 0;
        this._workingOrbThreads = 0;
        enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            ++this._totThreads;
            object2 = (String)enumeration.nextElement();
            Thd thd = (Thd)this._threads.get(object2);
            if (thd.waitingForWebWork()) {
                ++this._webWaitThreads;
            }
            if (thd.waitingForOrbWork()) {
                ++this._orbWaitThreads;
            }
            if (thd.isExecutingWebWork()) {
                ++this._workingWebThreads;
            }
            if (!thd.isExecutingRemoteOrbWork()) continue;
            ++this._workingOrbThreads;
        }
        this._unknownThreads = this._totThreads - (this._webWaitThreads + this._orbWaitThreads + this._workingWebThreads + this._workingOrbThreads);
    }

    public void outputVector(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.rptOut2((String)vector.elementAt(n));
            ++n;
        }
    }

    public void warnMissingStacks(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = this.missingStacksMsg();
        if (string != null && string.length() > 0) {
            printStream.println("WARNING: " + string);
        }
    }

    protected void calcMissingThreadStacks() {
        this._threadsMissingStacks = 0;
        Enumeration enumeration = this._threads.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Thd thd = (Thd)this._threads.get(string);
            if (thd.getStkSize() > 0 || thd.getName().equalsIgnoreCase("signal dispatcher")) continue;
            ++this._threadsMissingStacks;
        }
    }

    protected Vector warnMissingStacks() {
        Vector<String> vector = new Vector<String>();
        String string = this.missingStacksMsg();
        if (string != null && string.length() > 0) {
            this.logWarning(string);
            vector.add("WARNING: " + string);
        }
        return vector;
    }

    protected String missingStacksMsg() {
        this.calcMissingThreadStacks();
        String string = "";
        if (this._threadsMissingStacks > 0) {
            string = "" + this._threadsMissingStacks + " threads have no stack information.";
        }
        return string;
    }

    public void print(String string) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logErr("Cannot create output file " + string);
            System.exit(-1);
        }
        this.print(printStream);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        this.setPrintStream(printStream);
        this.logDebug("DumpData.print( ) begins...");
        this.initAnalysis();
        this.logDebug("DumpData.print - beginning of report");
        if (this._fHtml) {
            this.rptOut("<html>");
            this.rptOut2("<title>Thread dump analysis ");
            if (this._inputFilename != null) {
                this.rptOut2("for " + this._inputFilename);
            }
            this.rptOut2("</title>");
            this.rptOut2("<h2>Thread dump analysis ");
            if (this._inputFilename != null) {
                this.rptOut2("for " + this._inputFilename);
            }
            this.rptOut2("</h2>");
            this.printHeading();
            if (this._analysisType != 3) {
                this.rptOut2("Analysis type:" + DumpParser.getArg("analyze"));
            }
            this.rptOut("<a name=top></a><h2>Contents</h2>");
            this.rptOut2("<ul>");
            this.rptOut2("<li><a href=#disclaimer>Disclaimer</a></li>");
            this.rptOut2("<li><a href=#notice>Notice</a></li>");
            this.rptOut2("<li><a href=#summary>Summary</a></li>");
            this.rptOut2("<li><a href=#observations>Observations</a>");
            this.rptOut2("   <ul>");
            if ((this._analysisType & 1) == 1) {
                this.rptOut2("      <li><a href=#spa>Servlet thread pool analysis</a></li>");
                this.rptOut2("      <li><a href=#sta>Servlet engine thread analysis</a></li>");
                this.rptOut2("      <li><a href=#sma>Servlet engine monitor analysis</a></li>");
            }
            if ((this._analysisType & 2) == 2) {
                this.rptOut2("      <li><a href=#opa>ORB thread pool analysis</a></li>");
                this.rptOut2("      <li><a href=#ota>ORB thread analysis</a></li>");
                this.rptOut2("      <li><a href=#oma>ORB monitor analysis</a></li>");
            }
            if ((this._analysisType & 0x8000) == 32768) {
                this.rptOut2("      <li><a href=#ta>Overall thread analysis</a></li>");
                this.rptOut2("      <li><a href=#ma>Overall monitor analysis</a></li>");
            }
            this.rptOut2("   </ul>");
            this.rptOut2("</li>");
            if (this._logLevel >= 3) {
                this.rptOut2("<a href=#dtd><li>Thread details</li></a>");
                this.rptOut2("<a href=#dmd><li>Monitor details</li></a>");
            }
            this.rptOut2("</ul>");
        }
        Enumeration enumeration = null;
        String string = null;
        this.outputVector(this.disclaimer());
        this.outputVector(this.notice());
        if (this._inputFilename != null) {
            this.rptOut("Input file: " + this._inputFilename);
        }
        this.logDebug("DumpData.print - doing summary section");
        this.outputVector(this.summary());
        this.rptOut();
        this.rptOut();
        this.rptOut();
        this.rptOut(this.html("<a name=observations></a><h1>") + "Observations..." + this.html("</h1>"));
        if ((this._analysisType & 1) == 1) {
            this.logDebug("DumpData.print - doing servlet pool analysis");
            this.outputVector(this.servletPoolAnalysis());
            this.servletThreadPool();
            this.outputVector(this.servletThreadAnalysis());
            this.outputVector(this.servletMonitorAnalysis());
        }
        if ((this._analysisType & 2) == 2) {
            this.logDebug("DumpData.print - doing orb pool analysis");
            this.outputVector(this.orbPoolAnalysis());
            this.orbThreadPool();
            this.outputVector(this.orbThreadAnalysis());
            this.outputVector(this.orbMonitorAnalysis());
        }
        if ((this._analysisType & 0x8000) == 32768) {
            this.logDebug("DumpData.print - doing overall thread analysis");
            this.outputVector(this.overallThreadAnalysis());
            this.overallThreadPool();
            this.outputVector(this.overallMonitorAnalysis());
        }
        this.rptOut(this.html("<h3>") + "End of analysis section" + this.html("</h3>"));
        this.rptOut(" ");
        if (this._logLevel >= 3) {
            Externalizable externalizable;
            this.logDebug("DumpData.print - writing thread details");
            this.rptOut(this.html("<a name=dtd></a><h1>") + "Detailed thread dump" + this.html("</h1>"));
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            enumeration = this._threads.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                externalizable = (Thd)this._threads.get(string);
                int n = 0;
                this.rptOut2(this.html("<pre>"));
                this.outputVector(((Thd)externalizable).format(n, this._fHtml));
                this.rptOut2(this.html("<br><a href=#top>[top]</a>"));
                this.rptOut2(this.html("</pre>"));
            }
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            this.rptOut(" ");
            this.logDebug("DumpData.print - writing monitor details");
            enumeration = this.getMonitorEnum();
            externalizable = this.getNextMonitor(enumeration);
            this.rptOut2(this.html("<a name=dmd></a><h3>") + "Detailed monitor dump" + this.html("</h3>"));
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            while (externalizable != null) {
                this.rptOut2(this.html("<pre>"));
                this.outputVector(((Monitor)externalizable).format(1, this._fHtml));
                this.rptOut2(this.html("<br><a href=#top>[top]</a>"));
                this.rptOut2(this.html("</pre>"));
                externalizable = this.getNextMonitor(enumeration);
            }
            this.rptOut("** END Detailed monitor dump **");
            this.rptOut2(this.html("<a href=#top>[top]</a>"));
            this.rptOut(" ");
        }
        this.rptOut("** END OF REPORT **");
        this.rptOut(this.html("</html>"));
        this.logDebug("DumpData.print( ) end.");
        printStream.flush();
        printStream.close();
    }

    protected void setPrintStream(PrintStream printStream) {
        this._rptOut = printStream;
    }

    protected void printHeading() {
        this.rptOut("Thread analyzer version: " + DumpData.formattedVersion());
    }

    public Vector summary() {
        Vector<String> vector = new Vector<String>();
        vector.add("");
        vector.add("");
        vector.add(this.html("<a name=summary><h1>") + "Summary" + this.html("</h1></a>&nbsp;&nbsp;<a href=#top>[top]</a>"));
        vector.add(this.html("<pre>"));
        vector.add("Thread utilization summary: ");
        vector.add("  Total threads................................................... " + this._totThreads);
        vector.add("     threads waiting for web work................................. " + this._webWaitThreads);
        vector.add("     threads waiting for remote orb work.......................... " + this._orbWaitThreads);
        vector.add("     threads doing web or local orb work.......................... " + this._workingWebThreads);
        vector.add("     threads doing remote orb work................................ " + this._workingOrbThreads);
        vector.add("     threads doing other (non web or remote orb workload) tasks... " + this._unknownThreads);
        if (this.deadlockExists) {
            vector.add("\nDeadlock(s) found.  See Overall Monitor Analysis for details.");
        } else {
            vector.add("\nNo deadlock(s) found.");
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add(this.html("</pre>"));
        return vector;
    }

    public Vector disclaimer() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.html("<a name=disclaimer></a><h3>") + "Disclaimer" + this.html("</h3>"));
        vector.add(this.html("<pre>"));
        vector.add("      IBM has made every effort to ensure information and");
        vector.add("      recommendations to be  correct.  However, results are not");
        vector.add("      guaranteed.  System changes should not be made based");
        vector.add("      on information obtained using this or any other tool");
        vector.add("      without full consideration of the possible ramifications");
        vector.add("      of such changes.");
        vector.add(this.html("</pre>"));
        vector.add(this.html("<a href=#top>[top]</a>"));
        return vector;
    }

    public Vector notice() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.html("<a name=notice></a><h3>") + "Notice" + this.html("</h3>"));
        vector.add(this.html("<pre>"));
        vector.add("      This tool primarily focuses on threads created by the IBM WebSphere server runtime.");
        vector.add("      Also, the tool assumes that a representative workload is being driven through");
        vector.add("      the system for analysis.");
        vector.add(this.html("</pre>"));
        vector.add(this.html("<a href=#top>[top]</a>"));
        return vector;
    }

    public void servletThreadPool() {
        ServletThreadPool servletThreadPool = this.getServletThreadPool();
        TaGridElement[][] taGridElementArray = servletThreadPool.getTosGrid();
        Object[] objectArray = servletThreadPool.getTosGridHeaders();
        this.rptOut2(this.html("<b>") + "Top of stack information. " + this.html("</b>"));
        this.rptOut2("Highest weight items *may* indicate the need for more analysis.");
        this.rptOut2("Items with a weight of 0 are shown for completeness, but represent");
        this.rptOut2("   non-applicable system functions.");
        if (taGridElementArray != null) {
            this.rptOut2(this.html("<table border=1 ><tr>"));
            int n = taGridElementArray.length;
            int n2 = taGridElementArray[0].length;
            String string = "";
            int n3 = 0;
            while (n3 < objectArray.length) {
                string = string + this.html("<th>") + objectArray[n3].toString() + "\t\t" + this.html("</th>");
                ++n3;
            }
            this.rptOut2(string);
            this.rptOut2(this.html("</tr>"));
            int n4 = 0;
            while (n4 < n) {
                this.rptOut2(this.html("<tr>"));
                String string2 = "";
                int n5 = 0;
                while (n5 < n2) {
                    string2 = string2 + this.html("<td>") + taGridElementArray[n4][n5].toString() + "\t\t" + this.html("</td>");
                    ++n5;
                }
                this.rptOut2(string2);
                this.rptOut2(this.html("</tr>"));
                ++n4;
            }
            this.rptOut2(this.html("</table><br><br>"));
        }
    }

    public void orbThreadPool() {
        OrbThreadPool orbThreadPool = this.getOrbThreadPool();
        TaGridElement[][] taGridElementArray = orbThreadPool.getTosGrid();
        Object[] objectArray = orbThreadPool.getTosGridHeaders();
        this.rptOut2(this.html("<br><b>") + "Top of stack information. " + this.html("</b><br>"));
        this.rptOut2("Highest weight items *may* indicate the need for more analysis.");
        this.rptOut2("Items with a weight of 0 are shown for completeness, but represent");
        this.rptOut2("   non-applicable system functions.");
        if (taGridElementArray != null) {
            this.rptOut2(this.html("<table border=1 ><tr>"));
            int n = taGridElementArray.length;
            int n2 = taGridElementArray[0].length;
            String string = "";
            int n3 = 0;
            while (n3 < objectArray.length) {
                string = string + this.html("<th>") + objectArray[n3].toString() + "\t\t" + this.html("</th>");
                ++n3;
            }
            this.rptOut2(string);
            this.rptOut2(this.html("</tr>"));
            int n4 = 0;
            while (n4 < n) {
                this.rptOut2(this.html("<tr>"));
                String string2 = "";
                int n5 = 0;
                while (n5 < n2) {
                    string2 = string2 + this.html("<td>") + taGridElementArray[n4][n5].toString() + "\t\t" + this.html("</td>");
                    ++n5;
                }
                this.rptOut2(string2);
                this.rptOut2(this.html("</tr>"));
                ++n4;
            }
            this.rptOut2(this.html("</table><br><br>"));
        }
    }

    public void overallThreadPool() {
        OverallThreadPool overallThreadPool = this.getOverallThreadPool();
        TaGridElement[][] taGridElementArray = overallThreadPool.getTosGrid();
        Object[] objectArray = overallThreadPool.getTosGridHeaders();
        this.rptOut2(this.html("<b>") + "Top of stack information. " + this.html("</b>"));
        this.rptOut2("Overall thread analysis should be interpreted carefully.");
        this.rptOut2("Items with a high number of associated threads *may not*");
        this.rptOut2("   be items of concern since threads waiting for work");
        this.rptOut2("   will show up with large numbers of associated threads.");
        if (taGridElementArray != null) {
            this.rptOut2(this.html("<table border=1 ><tr>"));
            int n = taGridElementArray.length;
            int n2 = taGridElementArray[0].length;
            String string = "";
            int n3 = 0;
            while (n3 < objectArray.length) {
                string = string + this.html("<th>") + objectArray[n3].toString() + "\t\t" + this.html("</th>");
                ++n3;
            }
            this.rptOut2(string);
            this.rptOut2(this.html("</tr>"));
            int n4 = 0;
            while (n4 < n) {
                this.rptOut2(this.html("<tr>"));
                String string2 = "";
                int n5 = 0;
                while (n5 < n2) {
                    string2 = string2 + this.html("<td>") + taGridElementArray[n4][n5].toString() + "\t\t" + this.html("</td>");
                    ++n5;
                }
                this.rptOut2(string2);
                this.rptOut2(this.html("</tr>"));
                ++n4;
            }
            this.rptOut2(this.html("</table><br><br>"));
        }
    }

    public Vector orbPoolAnalysis() {
        return this.orbPoolAnalysis(this._tosTrans, this._orbWaitThreads, this._workingOrbThreads);
    }

    protected Vector orbPoolAnalysis(ResourceBundle resourceBundle, int n, int n2) {
        Vector<String> vector = new Vector<String>();
        Object var5_5 = null;
        Object var6_6 = null;
        int n3 = n + n2;
        double d = (double)n2 / (double)n3;
        double d2 = d * 100.0;
        vector.add(this.html("<pre>"));
        vector.add(this.html("<a name=opa></a><h3>") + "ORB thread pool analysis" + this.html("</h3>"));
        if (n2 > 0) {
            if (d < 0.8) {
                vector.add("      The ORB remote call handler thread pool does not seem to be driven to full capacity.");
                vector.add("      It's possible that there's a network bandwidth or workload generator constraint.");
                vector.add("");
                if (n3 > 5) {
                    vector.add("      It appears that the workload in this pool may be bursty.");
                    vector.add("         Since the ORB remote call handler pool size is dynamic,");
                    vector.add("         it's possible that some other resource may be fully consumed");
                    vector.add("         causing ORB requests to not be handled effectively.");
                }
            } else if (d > 0.98) {
                if (n3 <= 5) {
                    vector.add("      The pool should expand itself.");
                } else {
                    vector.add("       The pool has apparently expanded from the default of 5 to " + n3);
                }
            } else {
                vector.add("      The pool seems to be adequately utilized assuming relatively");
                vector.add("         full resource utilization across the system");
            }
        } else {
            vector.add("   No ORB remote call handler workload appears to be active");
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add(this.html("</pre>"));
        vector.add("");
        vector.add("");
        return vector;
    }

    public Vector orbThreadAnalysis() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = null;
        String string = null;
        vector.add(this.html("<a name=ota></a><h3>") + "ORB thread analysis" + this.html("</h3>"));
        boolean bl = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            double d;
            Object object;
            Object object2;
            string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)this._threadsByTOS.get(string);
            int n = 0;
            int n2 = 0;
            Vector vector3 = new Vector();
            Thd thd = null;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            int n3 = 0;
            int n4 = 0;
            while (n4 < vector2.size()) {
                object2 = (Thd)vector2.elementAt(n4);
                if (((Thd)object2).isExecutingRemoteOrbWork()) {
                    ++n3;
                    if (thd != null) {
                        ((Thd)object2).firstStackDifference(vector3, thd);
                    }
                    if (n3 == 2) {
                        thd.firstStackDifference(vector3, (Thd)object2);
                    }
                    thd = object2;
                    ++n;
                    object = ((Thd)object2).getEjbNames();
                    if (((String[])object).length != 0) {
                        int n5 = 0;
                        while (n5 < ((String[])object).length) {
                            Integer n6 = (Integer)hashtable.get(object[n5]);
                            n6 = n6 == null ? new Integer(1) : new Integer(n6 + 1);
                            hashtable.put(object[n5], n6);
                            ++n5;
                        }
                    }
                } else {
                    ++n2;
                }
                ++n4;
            }
            if (n <= true) continue;
            vector.add(this.html("<pre>"));
            bl = true;
            vector.add("      " + string + " seems to be a ");
            object2 = ".";
            if (n2 > 0) {
                object2 = " and " + n2 + " non-ORB remote call handler threads.";
            }
            vector.add("            concurrently executed by " + n + " ORB remote call handler threads" + (String)object2);
            object = null;
            try {
                object = this._tosTrans.getString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                vector.add("         SPECIFICS about " + string);
                vector.add(this.format(18, 80, "This method " + (String)object));
            }
            if ((d = (double)n / (double)this._workingOrbThreads) > 0.25) {
                int n7 = (int)(d * 100.0);
                vector.add("         Since " + n7 + "% (" + n + " out of " + this._workingOrbThreads + ") of the threads doing ORB remote call handler work seem to be");
                vector.add("             executing this method, it would seem that there ");
                vector.add("             is some possibility that this method and its call path");
                vector.add("             may warrant investigation.");
            }
            if ((enumeration2 = hashtable.keys()).hasMoreElements()) {
                vector.add("         EJBs affected: ");
            }
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                vector.add("            " + string2 + " [" + (Integer)hashtable.get(string2) + " occurrances]");
            }
            vector.add("         callers (ORB RCH threads only): ");
            if (vector3.size() <= 0) {
                vector.add("            The method seems to be called by EJBs from one code path.");
            }
            int n8 = 0;
            while (n8 < vector3.size()) {
                vector.add("            " + Thd.getCallerName(vector3.elementAt(n8)) + " [" + Thd.getCallerCount(vector3.elementAt(n8)) + "]");
                ++n8;
            }
            vector.add(" ");
            vector.add(this.html("</pre>"));
        }
        if (!bl) {
            vector.add("         no observations to report.");
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add("");
        vector.add("");
        return vector;
    }

    public Vector orbMonitorAnalysis() {
        return this.orbMonitorAnalysis(this._workingOrbThreads);
    }

    protected Vector orbMonitorAnalysis(int n) {
        Vector<String> vector = new Vector<String>();
        vector.add(this.html("<a name=oma></a><h3>") + "ORB monitor analysis" + this.html("</h1>"));
        Enumeration enumeration = this.getMonitorEnum();
        Monitor monitor = null;
        int n2 = 0;
        Vector vector2 = new Vector();
        vector.add(this.html("<pre>"));
        while ((monitor = this.getNextMonitor(enumeration)) != null) {
            Vector vector3 = this.orbLockWaiters(monitor);
            int n3 = 0;
            if (vector3 != null) {
                n3 = vector3.size();
            }
            if (n3 <= 0) continue;
            ++n2;
            vector.add("      Lock name: " + monitor.getName());
            if (monitor.getName().equals("com.ibm.ejs.cm.pool.Waiter")) {
                vector.add("         NOTE: " + monitor.getName() + " is the monitor used to mutex datasource");
                vector.add("               connection pools within WebSphere. It's very possible that");
                vector.add("               SLIGHTLY increasing the connection pool size for the affected datasource.");
                vector.add("               may relieve the constraint.");
            }
            vector.add("         There is/are " + n3 + " ORB remote call handler thread(s) waiting on the lock.");
            this.logDebug("Threre are " + n + " working remote threads.");
            double d = (double)n3 / (double)n;
            if (d > 0.25) {
                vector.add("         It seems that a significant number of ORB remote call handler threads doing work");
                vector.add("            are blocked on this lock.");
                vector.add("         Understanding the usage of this lock");
                vector.add("            may be important.");
            }
            vector.add("");
            Thd thd = null;
            int n4 = 0;
            while (n4 < n3) {
                Thd thd2 = (Thd)vector3.elementAt(n4);
                if (thd != null) {
                    thd2.firstStackDifference(vector2, thd);
                }
                if (n4 == 1) {
                    thd.firstStackDifference(vector2, thd2);
                }
                thd = thd2;
                ++n4;
            }
        }
        if (n2 == 0) {
            vector.add("      No 'running' ORB remote call handler threads seem to be blocked by java monitors.");
            vector.add("         NOTE: running means threads not waiting for work.");
            vector.add("                 since threads waiting for work always appear blocked.");
        } else {
            vector.add("      Blocked callers: ");
            if (vector2.size() <= 0) {
                vector.add("         The blockage seems to be entered from one code path.");
            }
            int n5 = 0;
            while (n5 < vector2.size()) {
                vector.add("         " + Thd.getCallerName(vector2.elementAt(n5)) + " [" + Thd.getCallerCount(vector2.elementAt(n5)) + "]");
                ++n5;
            }
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add("");
        vector.add("");
        vector.add(this.html("</pre>"));
        return vector;
    }

    public Vector overallThreadAnalysis() {
        return this.overallThreadAnalysis(this._tosTrans);
    }

    protected Vector overallThreadAnalysis(ResourceBundle resourceBundle) {
        Vector<String> vector = new Vector<String>();
        vector.add(this.html("<a name=ta></a><h3>") + "Overall thread analysis" + this.html("</h3>"));
        vector.add(this.html("<pre>"));
        Enumeration enumeration = null;
        String string = null;
        boolean bl = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)this._threadsByTOS.get(string);
            int n = 0;
            Vector vector3 = new Vector();
            Thd thd = null;
            int n2 = 0;
            while (n2 < vector2.size()) {
                object = (Thd)vector2.elementAt(n2);
                if (thd != null) {
                    ((Thd)object).firstStackDifference(vector3, thd);
                }
                if (n2 == vector2.size() - 1 && vector2.size() > 1) {
                    thd.firstStackDifference(vector3, (Thd)object);
                }
                thd = object;
                ++n;
                ++n2;
            }
            if (n <= true) continue;
            bl = true;
            vector.add("      " + string + " is being executed by ");
            vector.add("            " + n + " threads.");
            object = null;
            try {
                object = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) {
                vector.add("         SPECIFICS about " + string);
                vector.add(this.format(18, 80, "This method " + (String)object));
            }
            vector.add("         callers: ");
            if (vector3.size() <= 0) {
                vector.add("            The method seems to be called from one code path.");
            }
            int n3 = 0;
            while (n3 < vector3.size()) {
                vector.add("            " + Thd.getCallerName(vector3.elementAt(n3)) + " [" + Thd.getCallerCount(vector3.elementAt(n3)) + "]");
                ++n3;
            }
            vector.add(" ");
        }
        if (!bl) {
            vector.add("         no observations to report.");
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add("");
        vector.add("");
        vector.add(this.html("</pre>"));
        return vector;
    }

    public Vector overallMonitorAnalysis() {
        Vector<String> vector = new Vector<String>();
        if (this._monitors.size() > 0) {
            vector.add(this.html("<a name=ma></a><h3>") + "Overall monitor analysis" + this.html("</h1>"));
        } else if (this.deadlockResults == null) {
            vector.add(this.html("<a name=ma></a><h3>") + "No monitor information in thread dump provided by JDK" + this.html("</h1>"));
        }
        if (this.deadlockResults != null) {
            vector.addAll(this.deadlockResults);
        }
        return vector;
    }

    public Vector servletMonitorAnalysis() {
        return this.servletMonitorAnalysis(this._workingWebThreads);
    }

    protected Vector servletMonitorAnalysis(int n) {
        Vector<String> vector = new Vector<String>();
        vector.add(this.html("<a name=sma></a><h3>") + "Servlet engine monitor analysis" + this.html("</h1>"));
        vector.add(this.html("<pre>"));
        Enumeration enumeration = this.getMonitorEnum();
        Monitor monitor = null;
        int n2 = 0;
        Vector vector2 = new Vector();
        while ((monitor = this.getNextMonitor(enumeration)) != null) {
            Vector vector3 = this.webLockWaiters(monitor);
            int n3 = 0;
            if (vector3 != null) {
                n3 = vector3.size();
            }
            this.logDebug(n3 + " waiters and " + n + " workingWebThreads");
            if (n3 <= 0) continue;
            ++n2;
            vector.add("      Lock name: " + monitor.getName());
            if (monitor.getName().equals("com.ibm.ejs.cm.pool.Waiter")) {
                vector.add("         NOTE: " + monitor.getName() + " is the monitor used to mutex datasource");
                vector.add("               connection pools within WebSphere. It's very possible that");
                vector.add("               SLIGHTLY increasing the connection pool size for the affected datasource.");
                vector.add("               may relieve the constraint.");
            }
            vector.add("         There is/are " + n3 + " servlet engine thread(s) waiting on the lock.");
            double d = (double)n3 / (double)n;
            if (d > 0.25) {
                vector.add("         It seems that a significant number of servlet threads doing work");
                vector.add("            (" + n3 + " out of " + n + ") are waiting on this lock.");
                vector.add("         Understanding the reason behind this wait ");
                vector.add("            could lead to a way to improve performance for the servlets involved.");
            }
            vector.add("");
            Thd thd = null;
            int n4 = 0;
            while (n4 < n3) {
                Thd thd2 = (Thd)vector3.elementAt(n4);
                if (thd != null) {
                    thd2.firstStackDifference(vector2, thd);
                }
                if (n4 == 1) {
                    thd.firstStackDifference(vector2, thd2);
                }
                thd = thd2;
                ++n4;
            }
        }
        if (n2 == 0) {
            vector.add("      No 'running' servlet threads seem to be blocked by java monitors.");
            vector.add("         NOTE: running means servlet threads not waiting for work.");
            vector.add("                 since servlet threads waiting for work always appear blocked.");
        } else {
            vector.add("      Blocked callers: ");
            if (vector2.size() <= 0) {
                vector.add("         The blockage seems to be entered from one code path.");
            }
            int n5 = 0;
            while (n5 < vector2.size()) {
                vector.add("         " + Thd.getCallerName(vector2.elementAt(n5)) + " [" + Thd.getCallerCount(vector2.elementAt(n5)) + "]");
                ++n5;
            }
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add("");
        vector.add("");
        vector.add(this.html("</pre>"));
        return vector;
    }

    public Vector servletPoolAnalysis() {
        return this.servletPoolAnalysis(this._tosTrans, this._webWaitThreads, this._workingWebThreads);
    }

    protected Vector servletPoolAnalysis(ResourceBundle resourceBundle, int n, int n2) {
        Vector<String> vector = new Vector<String>();
        String string = _sTab;
        Object var6_6 = null;
        Object var7_7 = null;
        int n3 = n + n2;
        double d = (double)n2 / (double)n3;
        double d2 = d * 100.0;
        vector.add(this.html("<a name=spa></a><h3>") + "Servlet engine thread pool analysis (MAX CONNECTIONS)" + this.html("</h3>"));
        vector.add(this.html("<pre>"));
        if (n2 > 0) {
            if (d < 0.8) {
                vector.add(string + "   The servlet thread pool does not seem to be driven to full capacity.");
                vector.add(string + "   It's possible that there's a network bandwidth or workload generator constraint.");
                vector.add("");
                vector.add("");
                vector.add(string + "   It's also possible that the system under test is saturated.");
                vector.add(string + "      In this case, it's possible that the servlet thread pool may be over allocated.");
                vector.add(string + "      Check the thread pool size (MAX CONNECTIONS) in the servlet engine configuration.");
                vector.add(string + "      Currently, it's adequate to allocate no more than 5 or 6 threads per processor");
                vector.add(string + "         unless the workload tends to wait on external resources, locks or java monitors.");
                vector.add(string + "         If threads tend to wait, then experimentation may be required to find the \"sweet spot\".");
            } else if (d > 0.98) {
                vector.add(string + "   If the WebSphere system under test has extra capacity, performance may be enhanced by increasing MAX CONNECTIONS for the servlet engine.");
            } else {
                vector.add(string + "   Assuming the system under test is near capacity with respect to resources, it would seem that the servlet engine is adequately busy.");
                vector.add(string + "      more analysis will follow.");
            }
        } else {
            vector.add(string + "No servlet workload appears to be active");
        }
        vector.add(this.html("<a href=#top>[top]</a>"));
        vector.add("");
        vector.add("");
        return vector;
    }

    public Vector servletThreadAnalysis() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = null;
        String string = null;
        String string2 = _sTab;
        vector.add(this.html("<a name=sta></a><h3>") + "Servlet engine thread analysis" + this.html("</h3>"));
        boolean bl = false;
        enumeration = this._threadsByTOS.keys();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            double d;
            String string3;
            Object object;
            string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)this._threadsByTOS.get(string);
            int n = 0;
            int n2 = 0;
            Vector vector3 = new Vector();
            Thd thd = null;
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            int n3 = 0;
            int n4 = 0;
            while (n4 < vector2.size()) {
                object = (Thd)vector2.elementAt(n4);
                if (((Thd)object).isExecutingWebWork()) {
                    ++n3;
                    if (thd != null) {
                        ((Thd)object).firstStackDifference(vector3, thd);
                    }
                    if (n3 == 2) {
                        thd.firstStackDifference(vector3, (Thd)object);
                    }
                    thd = object;
                    ++n;
                    string3 = ((Thd)object).getServletName();
                    if (string3 != null) {
                        Integer n5 = (Integer)hashtable.get(string3);
                        n5 = n5 == null ? new Integer(1) : new Integer(n5 + 1);
                        hashtable.put(string3, n5);
                    }
                } else {
                    ++n2;
                }
                ++n4;
            }
            if (n <= true) continue;
            bl = true;
            vector.add(string2 + _sTab + string + " seems to be currently executing on ");
            object = ".";
            if (n2 > 0) {
                object = " and " + n2 + " non-servlet threads.";
            }
            vector.add(string2 + "          " + n + " servlet threads" + (String)object);
            string3 = null;
            try {
                string3 = this._tosTrans.getString(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 != null) {
                vector.add(string2 + "      SPECIFICS about " + string);
                vector.add(this.format(18, 80, "This method " + string3));
            }
            if ((d = (double)n / (double)this._workingWebThreads) > 0.25) {
                int n6 = (int)(d * 100.0);
                vector.add(string2 + "      Since " + n6 + "% (" + n + " out of " + this._workingWebThreads + ") of the threads doing servlet work seem to be");
                vector.add("             executing this method, it would seem that there ");
                vector.add("             is some possibility that this method and its call path");
                vector.add("             may warrant investigation.");
            }
            if ((enumeration2 = hashtable.keys()).hasMoreElements()) {
                vector.add(string2 + "      Servlets affected: ");
            }
            while (enumeration2.hasMoreElements()) {
                String string4 = (String)enumeration2.nextElement();
                vector.add(string2 + "         " + string4 + " [" + (Integer)hashtable.get(string4) + " occurrances]");
            }
            vector.add(string2 + "      Callers (servlet threads only): ");
            if (vector3.size() <= 0) {
                vector.add(string2 + "         The method seems to be called by servlets from one code path.");
            }
            int n7 = 0;
            while (n7 < vector3.size()) {
                vector.add(string2 + "         " + Thd.getCallerName(vector3.elementAt(n7)) + " [" + Thd.getCallerCount(vector3.elementAt(n7)) + "]");
                ++n7;
            }
            vector.add(" ");
        }
        if (!bl) {
            vector.add(string2 + "      no observations to report.");
        }
        vector.add(this.html("</pre>"));
        vector.add(this.html("<a href=#top>[top]</a>"));
        return vector;
    }

    protected void loadExternalEvaluators(String string) {
        this._monitorDetailHelpers = new Vector();
        this._threadDetailHelpers = new Vector();
        Vector<String> vector = new Vector<String>();
        vector.add("com.ibm.ws.performance.threadanalyzer.utils.V353MonDetail");
        vector.add("com.ibm.ws.performance.threadanalyzer.utils.V353ThdDetail");
        this.logDebug("*Analysis helper classes*");
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            string2 = string2.replace('/', '.');
            try {
                this.logDebug(_sTab + string2);
                Class<?> clazz = Class.forName(string2);
                Method[] methodArray = clazz.getDeclaredMethods();
                int n2 = 0;
                while (n2 < methodArray.length) {
                    Class<?>[] classArray;
                    String string3 = "unknown";
                    if (methodArray[n2].getName().equals("setProps") && (classArray = methodArray[n2].getParameterTypes()).length == 2 && classArray[0].getName().equals("com.ibm.ws.performance.threadanalyzer.AnalyzerEnv")) {
                        Class<?> clazz2 = methodArray[n2].getReturnType();
                        int n3 = methodArray[n2].getModifiers();
                        if (Modifier.isStatic(n3) && Modifier.isPublic(n3) && !Modifier.isAbstract(n3) && clazz2.getName().equals("void")) {
                            if (classArray[1].getName().equals("com.ibm.ws.performance.threadanalyzer.Thd")) {
                                string3 = "Thd";
                                this._threadDetailHelpers.add(methodArray[n2]);
                            } else if (classArray[1].getName().equals("com.ibm.ws.performance.threadanalyzer.Monitor")) {
                                string3 = "Monitor";
                                this._monitorDetailHelpers.add(methodArray[n2]);
                            }
                        }
                    }
                    if (string3.equals("Thd") || string3.equals("Monitor")) {
                        this.logDebug("      " + methodArray[n2].toString());
                        this.logDebug("      method type: " + string3);
                    }
                    ++n2;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logErr("      WARNING: " + string2 + " described in detail XML not found.");
            }
            ++n;
        }
    }

    private void rptOut(String string) {
        this._rptOut.println(this.html("<pre>") + string + this.html("</pre>"));
    }

    private void rptOut2(String string) {
        this._rptOut.println(string);
    }

    private void rptOut2() {
        this._rptOut.println();
    }

    private void rptOut() {
        this._rptOut.println(this.html("<br>"));
    }

    private void logOut(String string) {
        System.err.println(string);
    }

    private void logErr(String string) {
        System.err.println(string);
    }

    private void logWarning(String string) {
        if (this._logLevel >= 1) {
            System.err.println("WARNING: " + string);
        }
    }

    private void logDebug(String string) {
        if (this._logLevel >= 4) {
            System.err.println("DEBUG: " + string);
        }
    }

    public int getLogLevel() {
        return this._logLevel;
    }

    private String html(String string) {
        if (this._fHtml) {
            return string;
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private String format(int var1_1, int var2_2, String var3_3) {
        var4_4 = "";
        var5_5 = "";
        var6_6 = 1;
        var7_7 = new StringTokenizer(var3_3, " \t\n");
        ** GOTO lbl17
        {
            var4_4 = var4_4 + " ";
            do {
                if (++var6_6 < var1_1) continue block0;
                var5_5 = var7_7.nextToken();
                if ((var6_6 += var5_5.length()) > var1_1) {
                    var4_4 = var4_4 + " ";
                    ++var6_6;
                }
                var4_4 = var4_4 + var5_5;
                if (var6_6 < var2_2) continue;
                var6_6 = 1;
                var4_4 = var4_4 + "\r\n";
lbl17:
                // 3 sources

            } while (var7_7.hasMoreTokens());
        }
        return var4_4;
    }

    public void setLogLevel(int n) {
        this._logLevel = n;
    }

    public void setAnalysisType() {
        String string = DumpParser.getArg("analyze");
        int n = 0;
        if (string.equalsIgnoreCase("all")) {
            n = -1;
        }
        if (string.equalsIgnoreCase("was")) {
            n = 3;
        }
        if (string.equalsIgnoreCase("servlet")) {
            n = 1;
        }
        if (string.equalsIgnoreCase("ejb")) {
            n = 2;
        }
        if (string.equalsIgnoreCase("other")) {
            n = 32768;
        }
        if (n != 0) {
            this._analysisType = n;
        }
    }

    protected static String formattedVersion() {
        String string = null;
        string = "" + _majorVersion + "." + _minorVersion;
        if (_majorVersion < 1) {
            string = string + " (pre-release INTERNAL USE ONLY)";
        }
        return string;
    }

    public int getWebWaiting() {
        return this._webWaitThreads;
    }

    public int getWebWorking() {
        return this._workingWebThreads;
    }

    public int getOrbWaiting() {
        return this._orbWaitThreads;
    }

    public int getOrbWorking() {
        return this._workingOrbThreads;
    }

    public int getOthers() {
        return this._unknownThreads;
    }

    public int getTotal() {
        return this._totThreads;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(_curVersion);
        objectOutput.writeInt(this._totThreads);
        objectOutput.writeInt(this._webWaitThreads);
        objectOutput.writeInt(this._orbWaitThreads);
        objectOutput.writeInt(this._workingOrbThreads);
        objectOutput.writeInt(this._workingWebThreads);
        objectOutput.writeInt(this._unknownThreads);
        objectOutput.writeInt(this._analysisType);
        objectOutput.writeInt(this._logLevel);
        objectOutput.writeBoolean(this._fHtml);
        int n = this._threads.size();
        objectOutput.writeInt(n);
        Enumeration enumeration = this.getThreadEnum();
        Thd thd = this.getNextThread(enumeration);
        while (thd != null) {
            thd.writeExternal(objectOutput);
            thd = this.getNextThread(enumeration);
        }
        int n2 = this._monitors.size();
        objectOutput.writeInt(n2);
        enumeration = this.getMonitorEnum();
        Monitor monitor = this.getNextMonitor(enumeration);
        while (monitor != null) {
            monitor.writeExternal(objectOutput);
            monitor = this.getNextMonitor(enumeration);
        }
        this._env.writeExternal(objectOutput);
        objectOutput.writeObject(this._inputFilename);
        objectOutput.writeInt(this._threadsMissingStacks);
        this._threadDump.writeExternal(objectOutput);
        objectOutput.writeObject(this._displayName);
        objectOutput.writeObject(this._description);
        objectOutput.writeObject(this.dumpParserClassName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._version = objectInput.readInt();
        this._totThreads = objectInput.readInt();
        this._webWaitThreads = objectInput.readInt();
        this._orbWaitThreads = objectInput.readInt();
        this._workingOrbThreads = objectInput.readInt();
        this._workingWebThreads = objectInput.readInt();
        this._unknownThreads = objectInput.readInt();
        this._analysisType = objectInput.readInt();
        objectInput.readInt();
        this._fHtml = objectInput.readBoolean();
        int n = objectInput.readInt();
        if (this._threads == null) {
            this._threads = new Hashtable();
        }
        int n2 = 0;
        while (n2 < n) {
            Thd thd = new Thd();
            thd.readExternal(objectInput);
            this._threads.put(thd.getThreadId(), thd);
            ++n2;
        }
        int n3 = objectInput.readInt();
        if (this._monitors == null) {
            this._monitors = new Hashtable();
        }
        int n4 = 0;
        while (n4 < n3) {
            Monitor monitor = new Monitor();
            monitor.readExternal(objectInput);
            this._monitors.put(monitor.getName(), monitor);
            ++n4;
        }
        this._env = new AnalyzerEnv();
        this._env.readExternal(objectInput);
        this._inputFilename = (String)objectInput.readObject();
        this._threadsMissingStacks = objectInput.readInt();
        if (this._threadDump == null) {
            this._threadDump = new ThreadDump();
        }
        this._threadDump.readExternal(objectInput);
        this._displayName = (String)objectInput.readObject();
        this._description = (String)objectInput.readObject();
        this.dumpParserClassName = this._version >= 2 ? (String)objectInput.readObject() : null;
        this.fixupIdRefs();
    }

    public Hashtable getThreads() {
        return this._threads;
    }

    public Hashtable getMonitors() {
        return this._monitors;
    }

    public ThreadDump getThreadDump() {
        return this._threadDump;
    }

    public void setDeadLockResults(Vector vector) {
        this.deadlockResults = vector;
    }

    public void setDeadLockExists(boolean bl) {
        this.deadlockExists = bl;
    }

    public boolean isDeadLockExists() {
        return this.deadlockExists;
    }

    public void setDumpParserClassName(String string) {
        this.dumpParserClassName = string;
    }

    public String getDumpParserClassName() {
        return this.dumpParserClassName;
    }

    public String getDumpParserClassNameFromDumpData() {
        int n = DumpParser.getDumpParserTypeFromDumpData(this);
        DumpParser dumpParser = DumpParser.createParser(n, null);
        if (dumpParser != null) {
            return dumpParser.getClass().getName();
        }
        return null;
    }
}

