/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.File;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;

public class PlatformObject {
    public static final String name = System.getProperty("os.name", "Unknown");
    public static final String sr = File.separator;
    public static final String pr = File.pathSeparator;
    public static final String encoding = PlatformObject.getEncoding();
    public static final String libEnv = PlatformObject.getLibEnv();
    public static final String libPath = PlatformObject.getLibPath();
    public static final String exeExt = PlatformObject.getExeExt();
    public static final String dataSize = PlatformObject.getDataSize();
    public static final String tempDir = ConfigUtility.removeTrailings(System.getProperty("java.io.tmpdir", "%RASERVER_HOME%"));
    public static final String jvmLib = PlatformObject.getJvmLib();

    private static String getEncoding() {
        if (name.equals("z/OS") || name.equals("OS/390")) {
            return "ibm-1047-s390";
        }
        return "UTF-8";
    }

    private static String getLibEnv() {
        if (name.equals("AIX") || name.equals("OS/400") || name.equals("z/OS") || name.equals("OS/390")) {
            return "LIBPATH";
        }
        if (name.equals("HP-UX")) {
            return "SHLIB_PATH";
        }
        if (name.startsWith("Windows")) {
            return "PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    private static String getLibPath() {
        if (name.startsWith("Windows")) {
            return "bin";
        }
        return "lib";
    }

    private static String getExeExt() {
        if (name.startsWith("Windows")) {
            return ".exe";
        }
        return "";
    }

    private static String getDataSize() {
        if (name.startsWith("Windows")) {
            return "64M";
        }
        return "30M";
    }

    private static String getJvmLib() {
        if (name.startsWith("Windows")) {
            return "jvm.dll";
        }
        if (name.equals("AIX")) {
            return "libjvm.a";
        }
        if (name.equals("HP-UX")) {
            return "libjvm.sl";
        }
        return "libjvm.so";
    }
}

