/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.log4j;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.hyades.logging.core.LoggingAgent;
import org.eclipse.hyades.logging.log4j.XmlLayout;

public class SingleLoggingAgentAppender
extends AppenderSkeleton {
    private static LoggingAgent loggingAgent = null;
    private static int instanceCount = 0;
    private static final Object CURRENT_THREAD_LOCK = new Object();
    public static final String DEFAULT_LOGGING_AGENT_NAME = "Logging Agent Appender";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleLoggingAgentAppender() {
        super.setLayout((Layout)new XmlLayout());
        Object object = CURRENT_THREAD_LOCK;
        synchronized (object) {
            ++instanceCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent loggingEvent) {
        if (!this.closed && loggingEvent != null) {
            String formattedLoggingEvent = null;
            try {
                formattedLoggingEvent = this.getLayout().format(loggingEvent);
            }
            catch (Exception e) {
                this.getErrorHandler().error(null, e, 1, loggingEvent);
                return;
            }
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (loggingAgent == null) {
                    loggingAgent = new LoggingAgent(DEFAULT_LOGGING_AGENT_NAME);
                }
                loggingAgent.write(formattedLoggingEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (!this.closed) {
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (loggingAgent != null) {
                    loggingAgent.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.closed) {
            this.flush();
            Object object = CURRENT_THREAD_LOCK;
            synchronized (object) {
                if (--instanceCount == 0 && loggingAgent != null) {
                    loggingAgent.deregister();
                }
            }
            this.closed = true;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setLayout(Layout layout) {
    }
}

