/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RABinaryArray;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.SimpleAgentInfoCommand;

public class MonitorPeerRequestCommand
extends SimpleAgentInfoCommand {
    protected RABinaryArray _peerNode = new RABinaryArray();
    protected RABinaryArray _targetNode = new RABinaryArray();
    protected RAString _peerName = new RAString("");
    protected long _peerProcessId;
    private InetAddress _peerAddress = null;
    private InetAddress _targetAddress = null;

    public MonitorPeerRequestCommand() {
        this._tag = 98L;
    }

    public int getSize() {
        return super.getSize() + this._peerNode.getSize() + 4 + this._peerName.getSize();
    }

    public InetAddress getPeerNode() throws UnknownHostException {
        if (this._peerAddress != null) {
            return this._targetAddress;
        }
        if (this._peerNode.length() == 0L) {
            return null;
        }
        byte[] data = this._peerNode.getData();
        String addr = new String();
        addr = addr + this.convertPointAddress(new Byte(data[0]).intValue());
        int i = 1;
        while ((long)i < this._peerNode.length()) {
            addr = addr + "." + this.convertPointAddress(new Byte(data[i]).intValue());
            ++i;
        }
        return InetAddress.getByName(addr);
    }

    public InetAddress getTargetNode() throws UnknownHostException {
        if (this._targetAddress != null) {
            return this._targetAddress;
        }
        if (this._targetNode.length() == 0L) {
            return null;
        }
        byte[] data = this._targetNode.getData();
        String addr = new String();
        addr = addr + this.convertPointAddress(new Byte(data[0]).intValue());
        int i = 1;
        while ((long)i < this._targetNode.length()) {
            addr = addr + "." + this.convertPointAddress(new Byte(data[i]).intValue());
            ++i;
        }
        return InetAddress.getByName(addr);
    }

    public String getPeerAgentName() {
        if (this._peerName != null) {
            return this._peerName.getData();
        }
        return null;
    }

    public long getPeerProcessId() {
        return this._peerProcessId;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        current = Message.readRABinaryArrayFromBuffer(buffer, current, this._targetNode);
        this._peerProcessId = Message.readRALongFromBuffer(buffer, current);
        current += 4;
        current = Message.readRAStringFromBuffer(buffer, current, this._peerName);
        current = Message.readRABinaryArrayFromBuffer(buffer, current, this._peerNode);
        return current;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = super.writeToBuffer(buffer, offset);
        current = Message.writeRABinaryArrayToBuffer(buffer, current, this._targetNode);
        current = Message.writeRALongToBuffer(buffer, current, this._peerProcessId);
        current = Message.writeRAStringToBuffer(buffer, current, this._peerName);
        current = Message.writeRABinaryArrayToBuffer(buffer, current, this._peerNode);
        return current;
    }

    private int convertPointAddress(int pointAddress) {
        if (pointAddress < 0) {
            pointAddress = 256 - Math.abs(pointAddress);
        }
        return pointAddress;
    }
}

