/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.model.util;

import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.InvocationEvent;
import org.eclipse.hyades.test.common.event.MessageEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;

public abstract class EventLogger {
    public void logMessage(NamedElement namedElement, int n, String string) {
        if (namedElement == null) {
            return;
        }
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setOwnerId(ModelUtil.getHierarchyId(namedElement));
        messageEvent.setText(string);
        messageEvent.setSeverity(n);
        this.log((ExecutionEvent)messageEvent);
    }

    public void logTyped(NamedElement namedElement, int n, String string) {
        if (namedElement == null) {
            return;
        }
        TypedEvent typedEvent = new TypedEvent();
        typedEvent.setOwnerId(ModelUtil.getHierarchyId(namedElement));
        typedEvent.setText(string);
        typedEvent.setType(n);
        this.log((ExecutionEvent)typedEvent);
    }

    public void logInvocation(TestInvocation testInvocation, int n, String string) {
        if (testInvocation == null) {
            return;
        }
        InvocationEvent invocationEvent = new InvocationEvent();
        invocationEvent.setOwnerId(ModelUtil.getHierarchyId(testInvocation));
        invocationEvent.setText(string);
        if (testInvocation.getTest() == null) {
            invocationEvent.setStatus(2);
            invocationEvent.setReason(5);
        } else {
            invocationEvent.setInvokedId(ModelUtil.appendHierarchyId((NamedElement)testInvocation.getTest(), invocationEvent.getOwnerId()));
            invocationEvent.setStatus(n);
        }
        this.log((ExecutionEvent)invocationEvent);
    }

    public abstract void log(ExecutionEvent var1);
}

