/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class SaveManager
extends TimerTask {
    public static final Map RESOURCE_OPTIONS = new HashMap();
    private static SaveManager instance;
    private Timer timer;
    private List resources;
    private ArrayList saveState;
    private boolean running;

    private SaveManager() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
        this.running = false;
    }

    public synchronized void dispose() {
        this.stop();
        if (this.resources != null) {
            this.resources.clear();
        }
        instance = null;
    }

    public static SaveManager getInstance() {
        if (instance == null) {
            instance = new SaveManager();
        }
        return instance;
    }

    public static void saveResource(EObject eObject) {
        if (eObject != null) {
            SaveManager.saveResource(eObject.eResource());
        }
    }

    public static void saveResource(Resource resource) {
        block2: {
            if (resource == null) break block2;
            try {
                resource.save(RESOURCE_OPTIONS);
            }
            catch (IOException e) {}
        }
    }

    public void addResource(Resource resource) {
        if (resource == null) {
            return;
        }
        resource.setTrackingModification(true);
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        if (this.saveState == null) {
            this.saveState = new ArrayList();
        }
        this.resources.add(resource);
        this.saveState.add(Boolean.FALSE);
    }

    public void removeResource(Resource resource) {
        int index;
        if (this.resources != null && (index = this.resources.indexOf(resource)) != -1) {
            this.saveState.remove(index);
            this.resources.remove(index);
        }
    }

    public void removeAllResources() {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (this.saveState != null) {
            this.saveState.clear();
        }
    }

    public Resource[] getResources() {
        if (this.resources == null) {
            return new Resource[0];
        }
        return this.resources.toArray(new Resource[this.resources.size()]);
    }

    public Boolean[] getSaveState() {
        if (this.saveState == null) {
            return new Boolean[0];
        }
        return this.saveState.toArray(new Boolean[this.saveState.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResources() {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        Resource[] resourceArray = this.getResources();
        Boolean resourceSaveState = Boolean.FALSE;
        Resource resource = null;
        int i = 0;
        int maxi = resourceArray.length;
        while (i < maxi) {
            block9: {
                resource = resourceArray[i];
                try {
                    if (!resource.isModified()) break block9;
                    Resource resource2 = resource;
                    synchronized (resource2) {
                        resourceSaveState = (Boolean)this.saveState.get(i);
                        if (resourceSaveState == Boolean.TRUE) {
                            break block9;
                        }
                        this.saveState.set(i, Boolean.TRUE);
                    }
                    SaveManager.saveResource(resource);
                    if (this.resources.contains(resource)) {
                        this.saveState.set(i, Boolean.FALSE);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public synchronized void start(long saveInterval) {
        if (!this.isRunning() && saveInterval > 0L) {
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)this, saveInterval, saveInterval);
            this.running = true;
        }
    }

    public synchronized void stop() {
        this.running = false;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        if (this.resources == null || this.resources.isEmpty()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                if (SaveManager.this.isRunning()) {
                    SaveManager.this.saveResources();
                }
            }
        };
        thread.setName(this.getClass().getName());
        thread.start();
    }
}

