/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IExecutorWithProgressMonitorSupport;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.core.task.ProgressiveTask;
import org.eclipse.hyades.execution.core.util.MutableObject;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutionComponentStub;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public abstract class ExecutorStub
extends ExecutionComponentStub
implements IExecutorWithProgressMonitorSupport {
    private String executionResultLocation = null;
    private String executionResultName = null;
    private String communicationPort = null;
    public IDataProcessor[] dataProcessors = null;
    protected int agentInitCount;
    static /* synthetic */ Class class$org$eclipse$hyades$execution$core$IExecutableObject;

    public ExecutorStub() {
    }

    public ExecutorStub(IExecutionComponent delegate) {
        super(delegate);
    }

    public void launch(IProgressMonitor progressMonitor) {
        ReturnData invokeRtn = this.delegateRemoteCall(new Class[0], new Object[0], "launch");
        Object rtnValue = invokeRtn.getReturnValue();
        if (invokeRtn.isError()) {
            throw new RemoteInvocationException((Throwable)rtnValue);
        }
        this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)this, 3));
    }

    public void launch() throws ExecutionComponentStateException {
        this.launch((IProgressMonitor)new NullProgressMonitor());
    }

    public void kill(IProgressMonitor progressMonitor) throws ExecutionComponentStateException {
        ReturnData invokeRtn = this.delegateRemoteCall(new Class[0], new Object[0], "kill");
        Object rtnValue = invokeRtn.getReturnValue();
        if (invokeRtn.isError()) {
            throw new RemoteInvocationException((Throwable)rtnValue);
        }
        this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)this, 4));
    }

    public void kill() throws ExecutionComponentStateException {
        this.kill((IProgressMonitor)new NullProgressMonitor());
    }

    public void setExecutableObject(IExecutableObject theExecutableObject) throws ExecutionComponentStateException {
        ((IExecutor)this.delegate).setExecutableObject(theExecutableObject);
        ReturnData invokeRtn = this.delegateRemoteCall(new Class[]{class$org$eclipse$hyades$execution$core$IExecutableObject == null ? (class$org$eclipse$hyades$execution$core$IExecutableObject = ExecutorStub.class$("org.eclipse.hyades.execution.core.IExecutableObject")) : class$org$eclipse$hyades$execution$core$IExecutableObject}, new Object[]{theExecutableObject}, "setExecutableObject");
        Object rtnValue = invokeRtn.getReturnValue();
        if (invokeRtn.isError()) {
            throw new RemoteInvocationException((Throwable)rtnValue);
        }
        theExecutableObject.setExecutor((IExecutor)this);
    }

    public IExecutableObject getExecutableObject() {
        return ((IExecutor)this.delegate).getExecutableObject();
    }

    public IProcessConsole getProcessConsole() throws ExecutionComponentStateException {
        return null;
    }

    public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
        ExecutionComponentFactoryImpl factory = (ExecutionComponentFactoryImpl)ExecutionComponentFactoryImpl.getInstance(this.getSessionContext());
        IRemoteObject remoteObj = factory.createRemoteObjectByType(classname);
        if (!(remoteObj instanceof IExecutableObject)) {
            throw new ClassCastException("Component factory returned an incorrect type; expected an IExecutableObject");
        }
        return (IExecutableObject)remoteObj;
    }

    public String getExecutionResultLocation() {
        return this.executionResultLocation;
    }

    public String getExecutionResultName() {
        return this.executionResultName;
    }

    public void setExecutionResultLocation(String string) {
        this.executionResultLocation = string;
    }

    public void setExecutionResultName(String string) {
        this.executionResultName = string;
    }

    public IDataProcessor[] getDataProcessors() {
        return this.dataProcessors;
    }

    public void setDataProcessors(IDataProcessor[] processors) {
        this.dataProcessors = processors;
    }

    public String getPid() {
        ReturnData invokeRtn = this.delegateRemoteCall(new Class[0], new Object[0], "getPid");
        Object rtnValue = invokeRtn.getReturnValue();
        if (invokeRtn.isError()) {
            throw new RemoteInvocationException((Throwable)rtnValue);
        }
        return (String)rtnValue;
    }

    protected Process findProcess(String pid, Node node) throws NotConnectedException, InactiveProcessException {
        Object proc = null;
        Enumeration processes = node.listProcesses();
        while (processes.hasMoreElements()) {
            Process procBuf = (Process)processes.nextElement();
            if (!procBuf.getProcessId().equals(pid)) continue;
            return procBuf;
        }
        return null;
    }

    protected Process waitForProcess(final String processIdentity, final Node node, final int timeout, IProgressMonitor progressMonitor) throws NotConnectedException {
        final MutableObject foundProcess = new MutableObject();
        final MutableObject notConnectedException = new MutableObject();
        ProgressiveTask findProcess = new ProgressiveTask("Find Process", new Runnable(){

            public void run() {
                try {
                    foundProcess.setValue((Object)node.waitForProcess(processIdentity, timeout));
                }
                catch (InactiveProcessException e) {
                }
                catch (NotConnectedException e) {
                    notConnectedException.setValue((Object)e);
                }
            }
        }, progressMonitor, 3000);
        findProcess.execute(ProgressiveTask.Synchronicity.SYNCHRONOUS);
        NotConnectedException taskException = (NotConnectedException)notConnectedException.getValue();
        if (taskException != null) {
            throw taskException;
        }
        Process process = (Process)foundProcess.getValue();
        foundProcess.clear();
        return process;
    }

    protected Agent findAgent(Process proc, String agentType, String agentName) {
        Enumeration agents = proc.getAgentsByType(agentType);
        while (agents.hasMoreElements()) {
            Agent agent = (Agent)agents.nextElement();
            if (agent.getName().indexOf(agentName) == -1) continue;
            return agent;
        }
        return null;
    }

    protected void setupControlListener(AgentListener agentListener, Agent agent) throws InactiveAgentException, InactiveProcessException, UnsupportedEncodingException {
        String script;
        agent.addAgentListener(agentListener);
        agent.attach();
        String controlAgentName = agent.getName();
        IExecutionComponent[] children = this.getChildren();
        ++this.agentInitCount;
        ((JavaTaskRemoteHyadesComponentStub)children[this.agentInitCount - 1]).setAgent(agent);
        IExecutableObject executableObject = this.getExecutableObject();
        if (executableObject instanceof JavaProcessExecutableObjectStub && (script = ((JavaProcessExecutableObjectStub)executableObject).getAgentData()) != null) {
            BinaryCustomCommand agentData = new BinaryCustomCommand();
            agentData.setData(script.getBytes("UTF-8"));
            agent.invokeCustomCommand(agentData);
        }
    }

    protected void resetAgentInitCount() {
        this.agentInitCount = 0;
    }

    public String getCommunicationPort() {
        return this.communicationPort;
    }

    public void setCommunicationPort(String communicationPort) {
        this.communicationPort = communicationPort;
    }

    protected Agent waitForAgent(final String agentType, final String agentName, final Process process, final int timeout, IProgressMonitor progressMonitor) throws NotConnectedException {
        final MutableObject foundAgent = new MutableObject();
        final MutableObject notConnectedException = new MutableObject();
        ProgressiveTask findAgent = new ProgressiveTask("Find Agent", new Runnable(){

            public void run() {
                try {
                    foundAgent.setValue((Object)process.waitForAgent(agentType, agentName, timeout));
                }
                catch (InactiveProcessException e) {
                }
                catch (NotConnectedException e) {
                    notConnectedException.setValue((Object)e);
                }
            }
        }, progressMonitor, 3000);
        findAgent.execute(ProgressiveTask.Synchronicity.SYNCHRONOUS);
        NotConnectedException taskException = (NotConnectedException)notConnectedException.getValue();
        if (taskException != null) {
            notConnectedException.clear();
            throw taskException;
        }
        Agent agent = (Agent)foundAgent.getValue();
        foundAgent.clear();
        return agent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

