/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RABinaryArray;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.SimpleAgentInfoCommand;

public class CustomCommand
extends SimpleAgentInfoCommand {
    protected RAString _data = null;
    protected RABinaryArray _binaryData = null;

    public CustomCommand() {
        this._tag = 26L;
    }

    public String getData() {
        if (this._data != null) {
            return this._data.getData();
        }
        if (this._binaryData != null) {
            try {
                return new String(this._binaryData.getData(), "UTF-8");
            }
            catch (Exception e) {
                return new String(this._binaryData.getData());
            }
        }
        return null;
    }

    public byte[] getDataBinary() {
        if (this._binaryData != null) {
            return this._binaryData.getData();
        }
        if (this._data != null) {
            return this._data.getData().getBytes();
        }
        return null;
    }

    public int getSize() {
        if (this._data != null) {
            return super.getSize() + this._data.getSize();
        }
        if (this._binaryData != null) {
            return super.getSize() + this._binaryData.getSize();
        }
        return super.getSize() + 4;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = super.readFromBuffer(buffer, offset);
        this._binaryData = new RABinaryArray();
        current = Message.readRABinaryArrayFromBuffer(buffer, current, this._binaryData);
        return current;
    }

    public void setData(String data) {
        if (this._data == null) {
            this._data = new RAString(data);
        } else {
            this._data.setData(data);
        }
        this._binaryData = null;
    }

    public void setData(byte[] data) {
        if (this._binaryData == null) {
            this._binaryData = new RABinaryArray(data);
        } else {
            this._binaryData.setData(data);
        }
        this._data = null;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current;
        if (this._data != null) {
            current = super.writeToBuffer(buffer, offset);
            current = Message.writeRAStringToBuffer(buffer, current, this._data);
        } else if (this._binaryData != null) {
            current = super.writeToBuffer(buffer, offset);
            current = Message.writeRABinaryArrayToBuffer(buffer, current, this._binaryData);
        } else {
            current = super.writeToBuffer(buffer, offset);
            current = Message.writeRAStringToBuffer(buffer, current, new RAString(""));
        }
        return current;
    }
}

