/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class BasicEMap
implements EMap,
Cloneable,
Serializable {
    protected transient EList delegateEList;
    protected int size;
    protected transient BasicEList[] entryData;
    protected transient int modCount;
    protected transient View view;

    public BasicEMap() {
        this.initializeDelegateEList();
    }

    protected void initializeDelegateEList() {
        this.delegateEList = new BasicEList(){

            protected void didAdd(int index, Object newObject) {
                BasicEMap.this.doPut((Entry)newObject);
            }

            protected void didSet(int index, Object newObject, Object oldObject) {
                this.didRemove(index, oldObject);
                this.didAdd(index, newObject);
            }

            protected void didRemove(int index, Object oldObject) {
                BasicEMap.this.doRemove((Entry)oldObject);
            }

            protected void didClear(int size, Object[] oldObjects) {
                BasicEMap.this.doClear();
            }

            protected void didMove(int index, Object movedObject, int oldIndex) {
                BasicEMap.this.doMove((Entry)movedObject);
            }
        };
    }

    public BasicEMap(int initialCapacity) {
        this();
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity:" + initialCapacity);
        }
        this.entryData = this.newEntryData(initialCapacity);
    }

    public BasicEMap(Map map) {
        this();
        int mapSize = map.size();
        if (mapSize > 0) {
            this.entryData = this.newEntryData(2 * mapSize);
            this.putAll(map);
        }
    }

    protected BasicEList[] newEntryData(int capacity) {
        return new BasicEList[capacity];
    }

    protected void ensureEntryDataExists() {
        if (this.entryData == null) {
            this.entryData = this.newEntryData(2 * this.size + 1);
            int oldModCount = this.modCount;
            this.size = 0;
            Iterator i = this.delegateEList.iterator();
            while (i.hasNext()) {
                Entry entry = (Entry)i.next();
                this.doPut(entry);
            }
            this.modCount = oldModCount;
        }
    }

    protected BasicEList newList() {
        return new BasicEList(){

            public Object[] newData(int listCapacity) {
                return new EntryImpl[listCapacity];
            }
        };
    }

    protected Entry newEntry(int hash, Object key, Object value) {
        this.validateKey(key);
        this.validateValue(value);
        return new EntryImpl(hash, key, value);
    }

    protected Object putEntry(Entry entry, Object value) {
        return entry.setValue(value);
    }

    protected boolean useEqualsForKey() {
        return true;
    }

    protected boolean useEqualsForValue() {
        return true;
    }

    protected Object resolve(Object key, Object value) {
        return value;
    }

    protected void validateKey(Object key) {
    }

    protected void validateValue(Object value) {
    }

    protected void didAdd(Entry entry) {
    }

    protected void didModify(Entry entry, Object oldValue) {
    }

    protected void didRemove(Entry entry) {
    }

    protected void didClear(BasicEList[] oldEntryData) {
        if (oldEntryData != null) {
            int i = 0;
            while (i < oldEntryData.length) {
                BasicEList eList = oldEntryData[i];
                if (eList != null) {
                    Entry[] entries = (Entry[])eList.data;
                    int size = eList.size;
                    int j = 0;
                    while (j < size) {
                        Entry entry = entries[j];
                        this.didRemove(entry);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int indexOfKey(Object key) {
        if (this.useEqualsForKey() && key != null) {
            int i = 0;
            int size = this.delegateEList.size();
            while (i < size) {
                Entry entry = (Entry)this.delegateEList.get(i);
                if (key.equals(entry.getKey())) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            int size = this.delegateEList.size();
            while (i < size) {
                Entry entry = (Entry)this.delegateEList.get(i);
                if (key == entry.getKey()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (this.size > 0) {
            this.ensureEntryDataExists();
            int hash = this.hashOf(key);
            int index = this.indexOf(hash);
            int entryIndex = this.entryIndexForKey(index, hash, key);
            return entryIndex != -1;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        block10: {
            if (this.size <= 0) break block10;
            this.ensureEntryDataExists();
            if (this.useEqualsForValue() && value != null) {
                int i = 0;
                while (i < this.entryData.length) {
                    BasicEList eList = this.entryData[i];
                    if (eList != null) {
                        Entry[] entries = (Entry[])eList.data;
                        int size = eList.size;
                        int j = 0;
                        while (j < size) {
                            Entry entry = entries[j];
                            if (value.equals(entry.getValue())) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.entryData.length) {
                    BasicEList eList = this.entryData[i];
                    if (eList != null) {
                        Entry[] entries = (Entry[])eList.data;
                        int size = eList.size;
                        int j = 0;
                        while (j < size) {
                            Entry entry = entries[j];
                            if (value == entry.getValue()) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public Object get(Object key) {
        if (this.size > 0) {
            this.ensureEntryDataExists();
            int hash = this.hashOf(key);
            int index = this.indexOf(hash);
            Entry entry = this.entryForKey(index, hash, key);
            if (entry != null) {
                return this.resolve(key, entry.getValue());
            }
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int index;
        Entry entry;
        this.ensureEntryDataExists();
        int hash = this.hashOf(key);
        if (this.size > 0 && (entry = this.entryForKey(index = this.indexOf(hash), hash, key)) != null) {
            Object result = this.putEntry(entry, value);
            this.didModify(entry, result);
            return result;
        }
        Entry entry2 = this.newEntry(hash, key, value);
        this.delegateEList.add(entry2);
        return null;
    }

    protected void doPut(Entry entry) {
        if (this.entryData == null) {
            ++this.modCount;
            ++this.size;
        } else {
            int hash = entry.getHash();
            this.grow(this.size + 1);
            int index = this.indexOf(hash);
            BasicEList eList = this.entryData[index];
            if (eList == null) {
                eList = this.entryData[index] = this.newList();
            }
            eList.add(entry);
            ++this.size;
            this.didAdd(entry);
        }
    }

    public Object removeKey(Object key) {
        this.ensureEntryDataExists();
        int hash = this.hashOf(key);
        int index = this.indexOf(hash);
        Entry entry = this.entryForKey(index, hash, key);
        if (entry != null) {
            this.remove(entry);
            return entry.getValue();
        }
        return null;
    }

    protected void doRemove(Entry entry) {
        if (this.entryData == null) {
            ++this.modCount;
            --this.size;
        } else {
            Object key = entry.getKey();
            int hash = entry.getHash();
            int index = this.indexOf(hash);
            this.removeEntry(index, this.entryIndexForKey(index, hash, key));
        }
    }

    protected Object removeEntry(int index, int entryIndex) {
        ++this.modCount;
        --this.size;
        Entry entry = (Entry)this.entryData[index].remove(entryIndex);
        return entry.getValue();
    }

    public void putAll(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(EMap map) {
        Iterator i = map.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void doClear() {
        if (this.entryData == null) {
            ++this.modCount;
            this.size = 0;
            this.didClear(null);
        } else {
            ++this.modCount;
            BasicEList[] oldEntryData = this.entryData;
            this.entryData = null;
            this.size = 0;
            this.didClear(oldEntryData);
        }
    }

    protected void doMove(Entry entry) {
        ++this.modCount;
    }

    public Object clone() {
        try {
            BasicEMap result = (BasicEMap)super.clone();
            if (this.entryData != null) {
                result.entryData = this.newEntryData(this.entryData.length);
                int i = 0;
                while (i < this.entryData.length) {
                    result.entryData[i] = this.entryData[i] == null ? null : (BasicEList)this.entryData[i].clone();
                    ++i;
                }
            }
            result.view = null;
            result.modCount = 0;
            return result;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Map map() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.map == null) {
            this.view.map = new DelegatingMap();
        }
        return this.view.map;
    }

    public Set keySet() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.keySet == null) {
            this.view.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return BasicEMap.this.size == 0 ? ECollections.EMPTY_ELIST.iterator() : new BasicEMapKeyIterator();
                }

                public int size() {
                    return BasicEMap.this.size;
                }

                public boolean contains(Object key) {
                    return BasicEMap.this.containsKey(key);
                }

                public boolean remove(Object key) {
                    int oldSize = BasicEMap.this.size;
                    BasicEMap.this.removeKey(key);
                    return BasicEMap.this.size != oldSize;
                }

                public void clear() {
                    BasicEMap.this.clear();
                }
            };
        }
        return this.view.keySet;
    }

    public Collection values() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.values == null) {
            this.view.values = new AbstractCollection(){

                public Iterator iterator() {
                    return BasicEMap.this.size == 0 ? ECollections.EMPTY_ELIST.iterator() : new BasicEMapValueIterator();
                }

                public int size() {
                    return BasicEMap.this.size;
                }

                public boolean contains(Object value) {
                    return BasicEMap.this.containsValue(value);
                }

                public void clear() {
                    BasicEMap.this.clear();
                }
            };
        }
        return this.view.values;
    }

    public Set entrySet() {
        if (this.view == null) {
            this.view = new View();
        }
        if (this.view.entrySet == null) {
            this.view.entrySet = new AbstractSet(){

                public int size() {
                    return BasicEMap.this.size;
                }

                public boolean contains(Object object) {
                    if (BasicEMap.this.size > 0 && object instanceof Map.Entry) {
                        BasicEMap.this.ensureEntryDataExists();
                        Map.Entry otherEntry = (Map.Entry)object;
                        Object key = otherEntry.getKey();
                        int hash = key == null ? 0 : key.hashCode();
                        int index = BasicEMap.this.indexOf(hash);
                        BasicEList eList = BasicEMap.this.entryData[index];
                        if (eList != null) {
                            Entry[] entries = (Entry[])eList.data;
                            int size = eList.size;
                            int j = 0;
                            while (j < size) {
                                Entry entry = entries[j];
                                if (entry.getHash() == hash && entry.equals(otherEntry)) {
                                    return true;
                                }
                                ++j;
                            }
                        }
                    }
                    return false;
                }

                public boolean remove(Object object) {
                    if (BasicEMap.this.size > 0 && object instanceof Map.Entry) {
                        BasicEMap.this.ensureEntryDataExists();
                        Map.Entry otherEntry = (Map.Entry)object;
                        Object key = otherEntry.getKey();
                        int hash = key == null ? 0 : key.hashCode();
                        int index = BasicEMap.this.indexOf(hash);
                        BasicEList eList = BasicEMap.this.entryData[index];
                        if (eList != null) {
                            Entry[] entries = (Entry[])eList.data;
                            int size = eList.size;
                            int j = 0;
                            while (j < size) {
                                Entry entry = entries[j];
                                if (entry.getHash() == hash && entry.equals(otherEntry)) {
                                    this.remove(otherEntry);
                                    return true;
                                }
                                ++j;
                            }
                        }
                    }
                    return false;
                }

                public void clear() {
                    BasicEMap.this.clear();
                }

                public Iterator iterator() {
                    return BasicEMap.this.size == 0 ? ECollections.EMPTY_ELIST.iterator() : new BasicEMapIterator();
                }
            };
        }
        return this.view.entrySet;
    }

    protected int hashOf(Object key) {
        return key == null ? 0 : key.hashCode();
    }

    protected int indexOf(int hash) {
        return (hash & Integer.MAX_VALUE) % this.entryData.length;
    }

    protected Entry entryForKey(int index, int hash, Object key) {
        block6: {
            BasicEList eList = this.entryData[index];
            if (eList == null) break block6;
            Entry[] entries = (Entry[])eList.data;
            int size = eList.size;
            if (this.useEqualsForKey() && key != null) {
                int j = 0;
                while (j < size) {
                    Entry entry = entries[j];
                    if (entry.getHash() == hash && key.equals(entry.getKey())) {
                        return entry;
                    }
                    ++j;
                }
            } else {
                int j = 0;
                while (j < size) {
                    Entry entry = entries[j];
                    if (entry.getKey() == key) {
                        return entry;
                    }
                    ++j;
                }
            }
        }
        return null;
    }

    protected int entryIndexForKey(int index, int hash, Object key) {
        block6: {
            block5: {
                if (!this.useEqualsForKey() || key == null) break block5;
                BasicEList eList = this.entryData[index];
                if (eList == null) break block6;
                Entry[] entries = (Entry[])eList.data;
                int size = eList.size;
                int j = 0;
                while (j < size) {
                    Entry entry = entries[j];
                    if (entry.getHash() == hash && key.equals(entry.getKey())) {
                        return j;
                    }
                    ++j;
                }
                break block6;
            }
            BasicEList eList = this.entryData[index];
            if (eList != null) {
                Entry[] entries = (Entry[])eList.data;
                int size = eList.size;
                int j = 0;
                while (j < size) {
                    Entry entry = entries[j];
                    if (entry.getKey() == key) {
                        return j;
                    }
                    ++j;
                }
            }
        }
        return -1;
    }

    protected boolean grow(int minimumCapacity) {
        int oldCapacity;
        ++this.modCount;
        int n = oldCapacity = this.entryData == null ? 0 : this.entryData.length;
        if (minimumCapacity > oldCapacity) {
            BasicEList[] oldEntryData = this.entryData;
            this.entryData = this.newEntryData(2 * oldCapacity + 4);
            int i = 0;
            while (i < oldCapacity) {
                BasicEList oldEList = oldEntryData[i];
                if (oldEList != null) {
                    Entry[] entries = (Entry[])oldEList.data;
                    int size = oldEList.size;
                    int j = 0;
                    while (j < size) {
                        Entry entry = entries[j];
                        int index = this.indexOf(entry.getHash());
                        BasicEList eList = this.entryData[index];
                        if (eList == null) {
                            eList = this.entryData[index] = this.newList();
                        }
                        eList.add(entry);
                        ++j;
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.entryData == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.entryData.length);
            int i = 0;
            while (i < this.entryData.length) {
                BasicEList eList = this.entryData[i];
                if (eList != null) {
                    Entry[] entries = (Entry[])eList.data;
                    int size = eList.size;
                    int j = 0;
                    while (j < size) {
                        Entry entry = entries[j];
                        objectOutputStream.writeObject(entry.getKey());
                        objectOutputStream.writeObject(entry.getValue());
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int capacity = objectInputStream.readInt();
        if (capacity > 0) {
            this.entryData = this.newEntryData(capacity);
            int i = 0;
            while (i < this.size) {
                Object key = objectInputStream.readObject();
                Object value = objectInputStream.readObject();
                this.put(key, value);
                ++i;
            }
        }
    }

    public boolean contains(Object object) {
        return this.delegateEList.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.delegateEList.containsAll(collection);
    }

    public int indexOf(Object object) {
        return this.delegateEList.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.delegateEList.lastIndexOf(object);
    }

    public Object[] toArray() {
        return this.delegateEList.toArray();
    }

    public Object[] toArray(Object[] array) {
        return this.delegateEList.toArray(array);
    }

    public Object get(int index) {
        return this.delegateEList.get(index);
    }

    public Object set(int index, Object object) {
        return this.delegateEList.set(index, object);
    }

    public boolean add(Object object) {
        return this.delegateEList.add(object);
    }

    public void add(int index, Object object) {
        this.delegateEList.add(index, object);
    }

    public boolean addAll(Collection collection) {
        return this.delegateEList.addAll(collection);
    }

    public boolean addAll(int index, Collection collection) {
        return this.delegateEList.addAll(index, collection);
    }

    public boolean remove(Object object) {
        if (object instanceof Map.Entry) {
            return this.delegateEList.remove(object);
        }
        boolean result = this.containsKey(object);
        this.removeKey(object);
        return result;
    }

    public boolean removeAll(Collection collection) {
        return this.delegateEList.removeAll(collection);
    }

    public Object remove(int index) {
        return this.delegateEList.remove(index);
    }

    public boolean retainAll(Collection collection) {
        return this.delegateEList.retainAll(collection);
    }

    public void clear() {
        this.delegateEList.clear();
    }

    public void move(int index, Object object) {
        this.delegateEList.move(index, object);
    }

    public Object move(int targetIndex, int sourceIndex) {
        return this.delegateEList.move(targetIndex, sourceIndex);
    }

    public Iterator iterator() {
        return this.delegateEList.iterator();
    }

    public ListIterator listIterator() {
        return this.delegateEList.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.delegateEList.listIterator(index);
    }

    public List subList(int start, int end) {
        return this.delegateEList.subList(start, end);
    }

    public int hashCode() {
        return this.delegateEList.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof EMap) {
            return this.delegateEList.equals(object);
        }
        return false;
    }

    public String toString() {
        return this.delegateEList.toString();
    }

    public static interface Entry
    extends Map.Entry {
        public void setKey(Object var1);

        public int getHash();

        public void setHash(int var1);
    }

    protected static class View {
        public transient Map map;
        public transient Set keySet;
        public transient Set entrySet;
        public transient Collection values;
    }

    protected class DelegatingMap
    implements EMap.InternalMapView {
        public EMap eMap() {
            return BasicEMap.this;
        }

        public int size() {
            return BasicEMap.this.size();
        }

        public boolean isEmpty() {
            return BasicEMap.this.isEmpty();
        }

        public boolean containsKey(Object key) {
            return BasicEMap.this.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return BasicEMap.this.containsValue(value);
        }

        public Object get(Object key) {
            return BasicEMap.this.get(key);
        }

        public Object put(Object key, Object value) {
            return BasicEMap.this.put(key, value);
        }

        public Object remove(Object key) {
            return BasicEMap.this.removeKey(key);
        }

        public void putAll(Map map) {
            BasicEMap.this.putAll(map);
        }

        public void clear() {
            BasicEMap.this.clear();
        }

        public Set keySet() {
            return BasicEMap.this.keySet();
        }

        public Collection values() {
            return BasicEMap.this.values();
        }

        public Set entrySet() {
            return BasicEMap.this.entrySet();
        }

        public boolean equals(Object object) {
            return BasicEMap.this.equals(object);
        }

        public int hashCode() {
            return BasicEMap.this.hashCode();
        }
    }

    protected class EntryImpl
    implements Entry {
        protected int hash;
        protected Object key;
        protected Object value;

        public EntryImpl(int hash, Object key, Object value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        protected Object clone() {
            return BasicEMap.this.newEntry(this.hash, this.key, this.value);
        }

        public int getHash() {
            return this.hash;
        }

        public void setHash(int hash) {
            this.hash = hash;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            throw new RuntimeException();
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            BasicEMap.this.validateValue(value);
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (BasicEMap.this.useEqualsForKey() && this.key != null ? this.key.equals(entry.getKey()) : this.key == entry.getKey()) && (BasicEMap.this.useEqualsForValue() && this.value != null ? this.value.equals(entry.getValue()) : this.value == entry.getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }

    protected class BasicEMapIterator
    implements Iterator {
        protected int cursor;
        protected int entryCursor = -1;
        protected int lastCursor;
        protected int lastEntryCursor;
        protected int expectedModCount;

        BasicEMapIterator() {
            this.expectedModCount = BasicEMap.this.modCount;
            if (BasicEMap.this.size > 0) {
                this.scan();
            }
        }

        protected Object yield(Entry entry) {
            return entry;
        }

        protected void scan() {
            BasicEList eList;
            BasicEMap.this.ensureEntryDataExists();
            if (this.entryCursor != -1) {
                ++this.entryCursor;
                eList = BasicEMap.this.entryData[this.cursor];
                if (this.entryCursor < eList.size) {
                    return;
                }
                ++this.cursor;
            }
            while (this.cursor < BasicEMap.this.entryData.length) {
                eList = BasicEMap.this.entryData[this.cursor];
                if (eList != null && !eList.isEmpty()) {
                    this.entryCursor = 0;
                    return;
                }
                ++this.cursor;
            }
            this.entryCursor = -1;
        }

        public boolean hasNext() {
            return this.entryCursor != -1;
        }

        public Object next() {
            if (BasicEMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entryCursor == -1) {
                throw new NoSuchElementException();
            }
            this.lastCursor = this.cursor;
            this.lastEntryCursor = this.entryCursor;
            this.scan();
            return this.yield((Entry)BasicEMap.this.entryData[this.lastCursor].data[this.lastEntryCursor]);
        }

        public void remove() {
            if (BasicEMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastEntryCursor == -1) {
                throw new IllegalStateException();
            }
            BasicEMap.this.delegateEList.remove(BasicEMap.this.entryData[this.lastCursor].get(this.lastEntryCursor));
            this.expectedModCount = BasicEMap.this.modCount;
            this.lastEntryCursor = -1;
        }
    }

    protected class BasicEMapKeyIterator
    extends BasicEMapIterator {
        BasicEMapKeyIterator() {
        }

        protected Object yield(Entry entry) {
            return entry.getKey();
        }
    }

    protected class BasicEMapValueIterator
    extends BasicEMapIterator {
        BasicEMapValueIterator() {
        }

        protected Object yield(Entry entry) {
            return entry.getValue();
        }
    }
}

