/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.runner.internal.exec;

import java.io.InputStream;
import java.io.OutputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.hyades.test.http.runner.HttpRequest;
import org.eclipse.hyades.test.http.runner.HttpResponse;
import org.eclipse.hyades.test.http.runner.internal.exec.HttpRequestHandler;
import org.eclipse.hyades.test.http.runner.internal.exec.PlaybackX509TrustManager;

public class SSLHttpExecutor {
    private String strLastHost = null;
    private int iLastPort = 0;
    private SSLSocketFactory ssf = null;
    private SSLSocket sslSocket = null;
    private InputStream from_server = null;
    private OutputStream to_server = null;
    private HttpRequestHandler httpRequestHandler = null;
    private int socketBufSize = 0;

    public SSLHttpExecutor(HttpRequestHandler httpRequestHandler) {
        this.httpRequestHandler = httpRequestHandler;
    }

    public HttpResponse execute(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        String string = httpRequest.getURL();
        String string2 = httpRequest.getHost();
        int n = httpRequest.getPort();
        long l = System.currentTimeMillis();
        if (!(n == this.iLastPort && this.strLastHost != null && string2.regionMatches(0, this.strLastHost, 0, this.strLastHost.length()) && this.sslSocket != null && !this.sslSocket.isClosed() || this.connectToSecureServer(httpResponse, string2, n))) {
            return httpResponse;
        }
        if (!this.httpRequestHandler.sendRequest(httpRequest, this.to_server)) {
            if (!this.connectToSecureServer(httpResponse, string2, n)) {
                httpResponse.setCode(-1);
                return httpResponse;
            }
            if (!this.httpRequestHandler.sendRequest(httpRequest, this.to_server)) {
                httpResponse.setCode(-1);
                return httpResponse;
            }
        }
        this.httpRequestHandler.getServerResponse(httpRequest, httpResponse, this.from_server, this.socketBufSize);
        if (httpResponse.getCode() == 0 && this.connectToSecureServer(httpResponse, string2, n) && this.httpRequestHandler.sendRequest(httpRequest, this.to_server)) {
            this.httpRequestHandler.getServerResponse(httpRequest, httpResponse, this.from_server, this.socketBufSize);
        }
        if (httpResponse.getShouldCloseSocket()) {
            this.strLastHost = null;
        }
        return httpResponse;
    }

    private boolean connectToSecureServer(HttpResponse httpResponse, String string, int n) {
        try {
            if (this.sslSocket != null) {
                this.sslSocket.close();
            }
            if (this.ssf == null) {
                TrustManager[] trustManagerArray = new TrustManager[]{new PlaybackX509TrustManager()};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(null, trustManagerArray, null);
                this.ssf = sSLContext.getSocketFactory();
            }
            this.sslSocket = (SSLSocket)this.ssf.createSocket(string, n);
            this.from_server = this.sslSocket.getInputStream();
            this.to_server = this.sslSocket.getOutputStream();
            this.socketBufSize = this.sslSocket.getReceiveBufferSize();
            this.iLastPort = n;
            this.strLastHost = string;
        }
        catch (Exception exception) {
            httpResponse.setCode(-1);
            httpResponse.setDetail(exception.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

