/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.util.CompoundIterator;
import org.eclipse.hyades.models.hierarchy.util.EObjectsTraverser;
import org.eclipse.hyades.models.hierarchy.util.FastList;

public class ContainmentTraverser
extends EObjectsTraverser {
    private ChildrenIteratorPool childrenIteratorPool;
    private ChildrenListPool childrenPool;
    private boolean resolve;

    public ContainmentTraverser(Collection contents) {
        super(contents);
        this.resolve = true;
        this.childrenPool = new ChildrenListPool();
        this.childrenIteratorPool = new ChildrenIteratorPool();
    }

    public ContainmentTraverser(Collection contents, boolean resolve) {
        super(contents);
        this.resolve = resolve;
        this.childrenPool = new ChildrenListPool();
        this.childrenIteratorPool = new ChildrenIteratorPool();
    }

    protected EObject getElement(EObject traversedElement) {
        return traversedElement;
    }

    protected Iterator getIterator(EList result) {
        if (this.resolve) {
            return result.iterator();
        }
        return ((InternalEList)result).basicIterator();
    }

    protected boolean isRequiredFeature(EStructuralFeature sf) {
        return true;
    }

    private void populateChildrenList(EObject parent, List children) {
        EList features = parent.eClass().getEAllContainments();
        int i = features.size() - 1;
        while (i >= 0) {
            EStructuralFeature sf = (EStructuralFeature)features.get(i);
            if (this.isRequiredFeature(sf) && parent.eIsSet(sf)) {
                Object result = parent.eGet(sf, this.resolve);
                if (result instanceof EList) {
                    Iterator iter2 = this.getIterator((EList)result);
                    while (iter2.hasNext()) {
                        EObject element = (EObject)iter2.next();
                        if (element == null) continue;
                        children.add(element);
                    }
                } else if (result != null) {
                    children.add(result);
                }
            }
            --i;
        }
    }

    private void populateChildrenIterator(EObject parent, CompoundIterator childrenIterator) {
        EList features = parent.eClass().getEAllContainments();
        int i = features.size() - 1;
        while (i >= 0) {
            EStructuralFeature sf = (EStructuralFeature)features.get(i);
            if (this.isRequiredFeature(sf) && parent.eIsSet(sf)) {
                Object result = parent.eGet(sf, this.resolve);
                if (result instanceof EList) {
                    childrenIterator.addIterator(this.getIterator((EList)result));
                } else if (result != null) {
                    childrenIterator.addObject(result);
                }
            }
            --i;
        }
    }

    protected boolean traverseEObject(EObject object) {
        return this.traverseEObjectChildrenIterator(object);
    }

    protected boolean traverseEObjectChildrenIterator(EObject object) {
        CompoundIterator childrenIterator = this.childrenIteratorPool.alloc();
        this.populateChildrenIterator(object, childrenIterator);
        boolean res = this.traverse(childrenIterator);
        this.childrenIteratorPool.release(childrenIterator);
        return res;
    }

    protected boolean traverseEObjectChildrenList(EObject object) {
        List children = this.childrenPool.alloc();
        this.populateChildrenList(object, children);
        boolean res = this.traverse(children);
        this.childrenPool.release(children);
        return res;
    }

    public static final class ChildrenListPool {
        private int currentEntryIndex = -1;
        private ArrayList lists = new ArrayList(20);

        public List alloc() {
            Object list;
            if (this.lists.size() == this.currentEntryIndex + 1) {
                list = new FastList();
                this.lists.add(list);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                list = (List)this.lists.get(this.currentEntryIndex);
            }
            return list;
        }

        public void release(List children) {
            children.clear();
            --this.currentEntryIndex;
        }
    }

    public static final class ChildrenIteratorPool {
        private int currentEntryIndex = -1;
        private ArrayList iterators = new ArrayList(20);

        public CompoundIterator alloc() {
            CompoundIterator iterator;
            if (this.iterators.size() == this.currentEntryIndex + 1) {
                iterator = new CompoundIterator();
                this.iterators.add(iterator);
                ++this.currentEntryIndex;
            } else {
                ++this.currentEntryIndex;
                iterator = (CompoundIterator)this.iterators.get(this.currentEntryIndex);
            }
            return iterator;
        }

        public void release(CompoundIterator children) {
            children.clear();
            --this.currentEntryIndex;
        }
    }
}

