/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;
import org.eclipse.hyades.execution.recorder.http.remote.PeekSocket;
import org.eclipse.hyades.execution.recorder.http.remote.SSLCheckClass;
import org.eclipse.hyades.execution.recorder.http.remote.ServerSideReader;

public class ClientSideReaderHTTP
extends ClientSideReader {
    public static final String ERROR_SSL_REQUEST_MADE = "-1";
    public static final String ERROR_NO_TESTKEYS = "-2";
    static final String STR_KEEP_ALIVE = "Proxy-Connection: Keep-Alive\r\n";
    static int iConn = 0;
    static final String ClientSideReaderException = HttpRecResourceBundle.getInstance().getString("RECORDER_CLIENTSIDE_READER_EXCEPTION");
    String iProxyAddr = "";
    int iProxyPort = 0;
    boolean secureConnectionOK = false;
    boolean didOpenConnection = false;
    boolean wroteOnePacket = false;
    String iSSLProxyAddr = "";
    int iSSLProxyPort = 0;

    ClientSideReaderHTTP(PeekSocket peekSocket, PacketWriter packetWriter, String string, String string2, int n) {
        super(peekSocket, packetWriter, string);
        this.iProxyAddr = string2;
        this.iProxyPort = n;
    }

    ClientSideReaderHTTP(PeekSocket peekSocket, PacketWriter packetWriter, String string, String string2, int n, String string3, int n2, String string4, String string5) {
        super(peekSocket, packetWriter, string);
        this.iProxyAddr = string2;
        this.iProxyPort = n;
        this.iSSLProxyAddr = string3;
        this.iSSLProxyPort = n2;
    }

    public void run() {
        block28: {
            int n = 0;
            String string = null;
            boolean bl = false;
            boolean bl2 = false;
            if (ClientSideReader.isSSLClassAvailable == -1 && (ClientSideReader.isSSLClassAvailable = this.findSSLClass()) == 1) {
                ClientSideReader.foundTestKeys = this.checkForTestKeys();
            }
            this.setName("ClientSideReaderHTTP-Conn:" + this.iConnection + ":" + this.iProxyAddr + ":" + this.iProxyPort);
            try {
                byte[] byArray = new byte[this.client.getReceiveBufferSize()];
                bl = this.connectToProxyServer();
                if (bl) {
                    while ((n = this.from_client.read(byArray)) != -1) {
                        Thread.sleep(1L);
                        Thread.yield();
                        this.bNoPrintToServer = false;
                        boolean bl3 = false;
                        String string2 = new String(byArray, 0, n);
                        bl2 = this.checkForSSLRequest(string2);
                        this.wroteOnePacket = true;
                        if (bl2 && ClientSideReader.isSSLClassAvailable == 1) {
                            if (ClientSideReader.foundTestKeys) {
                                SSLCheckClass sSLCheckClass = new SSLCheckClass(this, this.keyFile);
                                this.to_server = this.httpServer.getOutputStream();
                                this.from_server = this.httpServer.getInputStream();
                                if (this.iSSLProxyAddr.length() > 0 && this.iSSLProxyPort > 0) {
                                    sSLCheckClass.makeSecureConnectionHTTP(string2, this.iSSLProxyAddr, this.iSSLProxyPort, true);
                                } else {
                                    sSLCheckClass.makeSecureConnectionHTTP(string2, this.iProxyAddr, this.iProxyPort, false);
                                }
                            } else {
                                this.packetWriter.getAgentController().sendControlMessageToDataProcessor(ERROR_NO_TESTKEYS);
                                return;
                            }
                        }
                        if (!this.bSecure && !this.didOpenConnection) {
                            string = this.makeRegularConnection();
                        }
                        if (this.bSecure) {
                            this.packetWriter.writePacket(this.bSecure, true, this.connectionNumber, byArray, n, this.to_server, this.bNoPrintToServer);
                        }
                        if (this.bSecure) continue;
                        this.packetWriter.writePacket(this.bSecure, true, this.connectionNumber, string2.getBytes(), string2.getBytes().length, this.to_server, this.bNoPrintToServer);
                    }
                }
                if (this.httpServer == null) break block28;
                this.httpServer.setSoLinger(false, 0);
                if (!this.wroteOnePacket) {
                    if (!this.httpServer.isClosed()) {
                        this.httpServer.close();
                    }
                } else if (!this.httpServer.isOutputShutdown()) {
                    if (this.bSecure) {
                        this.to_server.flush();
                        this.httpServer.close();
                    } else {
                        this.httpServer.shutdownOutput();
                    }
                }
                if (this.serverReader != null) {
                    this.serverReader.setClosedByClient();
                }
            }
            catch (Exception exception) {
                try {
                    if (this.httpServer != null) {
                        if (!this.wroteOnePacket) {
                            if (!this.httpServer.isClosed()) {
                                this.httpServer.close();
                            }
                        } else if (!this.httpServer.isOutputShutdown()) {
                            if (this.bSecure) {
                                this.to_server.flush();
                                this.httpServer.close();
                            } else {
                                this.httpServer.shutdownOutput();
                            }
                        }
                    }
                    Thread.yield();
                }
                catch (IOException iOException) {
                    String string3 = iOException.getMessage();
                    if (string3.indexOf("Stream closed") >= 0 || string3.indexOf("Socket closed") >= 0 || string3.indexOf("JVM_recv in socket input") >= 0 || string3.indexOf("onnection closed") >= 0 || string3.indexOf("socket closed") >= 0 || string3.indexOf("onnection reset") >= 0 || string3.indexOf("Socket is closed") >= 0) break block28;
                    this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + " : " + exception.getLocalizedMessage());
                }
            }
        }
    }

    private boolean connectToProxyServer() {
        boolean bl;
        block3: {
            bl = false;
            try {
                this.httpServer = new Socket(this.iProxyAddr, this.iProxyPort);
                if (this.httpServer != null) {
                    bl = true;
                    break block3;
                }
                bl = false;
                this.packetWriter.writeRecorderMessage(1, "Error connecting to Server:" + this.destServer + " Port: " + this.serverPort);
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(1, "Error Connecting to Proxy Server:" + this.iProxyAddr + ":" + this.iProxyPort + iOException);
            }
        }
        return bl;
    }

    private void respondToClient(boolean bl) {
        byte[] byArray = new byte[8];
        byArray[0] = 0;
        byArray[1] = bl ? 90 : 91;
        try {
            this.to_client.write(byArray, 0, 8);
            this.to_client.flush();
        }
        catch (Exception exception) {}
    }

    private boolean checkForSSLRequest(String string) {
        boolean bl = false;
        int n = string.indexOf("CONNECT ");
        if (n >= 0) {
            bl = true;
            int n2 = string.indexOf(":", n += 8);
            if (n2 > n) {
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                if ((n2 = string.indexOf(" ", n)) > n) {
                    String string3 = string.substring(n, n2);
                    int n3 = Integer.parseInt(string3);
                    this.destServer = string2;
                    this.serverPort = n3;
                }
            }
        }
        return bl;
    }

    private String makeRegularConnection() {
        String string = null;
        boolean bl = false;
        try {
            this.packetWriter.writeOpenConnectionInfo(this.bSecure, this.iConnection, this.iProxyAddr, this.iProxyPort, this.client, this.httpServer, null, null);
            this.to_server = this.httpServer.getOutputStream();
            this.from_server = this.httpServer.getInputStream();
            this.serverReader = new ServerSideReader(this.client, this.httpServer, this.from_server, this.to_client, this.packetWriter, this.connectionNumber, this.bSecure, this.httpServer.getReceiveBufferSize());
            this.serverReader.start();
        }
        catch (Exception exception) {
            this.packetWriter.writeRecorderMessage(2, "exception in ClientSideReader: " + exception);
            this.packetWriter.getAgentController().reportException(ClientSideReaderException, (Throwable)exception);
            this.packetWriter.writeCloseConnectionInfo(this.connectionNumber);
            try {
                this.client.close();
                string = null;
            }
            catch (IOException iOException) {
                this.packetWriter.writeRecorderMessage(2, "IOException in ClientSideReader connection " + this.iConnection + ": " + iOException);
            }
        }
        this.didOpenConnection = true;
        return string;
    }
}

