/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Operand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;

public class QueryUtils {
    public static final String DOLLAR_SIGN = "$";
    protected static Map subTypesIndex = new HashMap();

    public static SimpleSearchQuery removeClasses(SimpleSearchQuery simpleSearchQuery, final Set classes) {
        SimpleSearchQuery query = (SimpleSearchQuery)EcoreUtil.copy((EObject)simpleSearchQuery);
        final HashMap alreadyProcessed = new HashMap();
        final HashSet removeSet = new HashSet();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (alreadyProcessed.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                alreadyProcessed.put(element, null);
                if (element instanceof SimpleOperand) {
                    BinaryExpression be;
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c == null && o.getFeature() != null) {
                        c = o.getFeature().getEContainingClass();
                    }
                    if (c != null && classes.contains(c) && (be = QueryUtils.getParentBinaryExpression(o)) != null) {
                        removeSet.add(be);
                    }
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        QueryUtils.removeElementsAndCompactQuery(query, removeSet);
        return query;
    }

    public static BinaryExpression getParentBinaryExpression(EObject o) {
        if (o != null) {
            if (o instanceof BinaryExpression) {
                return (BinaryExpression)o;
            }
            return QueryUtils.getParentBinaryExpression(o.eContainer());
        }
        return null;
    }

    public static void removeElementsAndCompactQuery(SimpleSearchQuery query, Set elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            QueryUtils.removeElementAndCompactContainers(element);
        }
    }

    public static void removeElementAndCompactContainers(EObject element) {
        if (element == null) {
            return;
        }
        EObject container = element.eContainer();
        if (container == null) {
            return;
        }
        if (container instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)container;
            le.getArguments().remove((Object)element);
            if (le.getArguments().isEmpty()) {
                QueryUtils.removeElementAndCompactContainers(le);
            } else {
                QueryUtils.compactWhereExpression(le);
            }
        }
    }

    public static void compactWhereExpression(WhereExpression we) {
        if (we instanceof LogicalExpression && ((LogicalExpression)we).getArguments().size() > 0) {
            QueryUtils.compactLogicalExpression((LogicalExpression)we);
            return;
        }
        QueryUtils.compactBinaryExpression((BinaryExpression)we);
    }

    public static void compactLogicalExpression(LogicalExpression le) {
        if (le.getArguments().size() == 1 && le.getOperator() == LogicalOperators.NOT_LITERAL) {
            return;
        }
        if (le.getArguments().size() > 1) {
            return;
        }
        EObject container = le.eContainer();
        if (container == null) {
            return;
        }
        if (container instanceof LogicalExpression) {
            LogicalExpression c = (LogicalExpression)container;
            if (le.getArguments().size() == 1) {
                c.getArguments().set(c.getArguments().indexOf((Object)le), le.getArguments().get(0));
            } else {
                c.getArguments().remove((Object)le);
            }
            QueryUtils.compactLogicalExpression(c);
        }
    }

    public static void compactBinaryExpression(BinaryExpression be) {
        if (be.getRightOperands().size() > 0) {
            return;
        }
        EObject container = be.eContainer();
        if (container == null) {
            return;
        }
        if (container instanceof LogicalExpression) {
            LogicalExpression c = (LogicalExpression)container;
            c.getArguments().remove((Object)be);
            QueryUtils.compactLogicalExpression(c);
        }
    }

    public static String getElementName(EObject element) {
        if (element instanceof WhereExpression) {
            return ((WhereExpression)element).getName();
        }
        if (element instanceof Operand) {
            return ((Operand)element).getName();
        }
        return element.toString();
    }

    public static Set getAllSubTypes(EClass c) {
        HashSet<EClass> s = (HashSet<EClass>)subTypesIndex.get(c);
        if (s == null) {
            s = new HashSet<EClass>();
            subTypesIndex.put(c, s);
            Iterator iter = EPackage.Registry.INSTANCE.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry packageEntry = (Map.Entry)iter.next();
                if (packageEntry.getValue() == null || !(packageEntry.getValue() instanceof EPackage)) continue;
                Iterator iterator = ((EPackage)packageEntry.getValue()).getEClassifiers().iterator();
                while (iterator.hasNext()) {
                    EClass class1;
                    EClassifier classifier = (EClassifier)iterator.next();
                    if (!(classifier instanceof EClass) || !(class1 = (EClass)classifier).getEAllSuperTypes().contains((Object)c)) continue;
                    s.add(class1);
                }
            }
        }
        return s;
    }

    public static void addSubTypes(EClass c, Map m, Collection l) {
        Iterator iter = QueryUtils.getAllSubTypes(c).iterator();
        while (iter.hasNext()) {
            EClass element = (EClass)iter.next();
            Collection l1 = (Collection)m.get(element);
            if (l1 != null) {
                l1.addAll(l);
                continue;
            }
            m.put(element, l);
        }
    }

    public static void addSuperTypes(EClass c, Map m, Collection l) {
        Iterator iter = c.getEAllSuperTypes().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            Collection l1 = (Collection)m.get(element);
            if (l1 != null) {
                l1.addAll(l);
                continue;
            }
            m.put(element, l);
        }
    }

    public static void addSuperTypes(EClass c, Collection s) {
        Iterator iter = c.getEAllSuperTypes().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            s.add(element);
        }
    }

    public static void addSubTypes(EClass c, Collection s) {
        Iterator iter = QueryUtils.getAllSubTypes(c).iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            s.add(element);
        }
    }

    public static Map getClassPredicatesIndex(SimpleSearchQuery query) {
        final HashMap whereExpressionValuesIndex = new HashMap();
        final HashMap classPredicatesIndex = new HashMap();
        final HashMap namesIndex = new HashMap();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (whereExpressionValuesIndex.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                whereExpressionValuesIndex.put(element, null);
                if (element instanceof SimpleOperand) {
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c != null) {
                        HashSet<EObject> l = (HashSet<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new HashSet<EObject>();
                            classPredicatesIndex.put(c, l);
                            QueryUtils.addSubTypes(c, classPredicatesIndex, l);
                        }
                        l.add(element);
                    } else if (o.getFeature() != null) {
                        c = o.getFeature().getEContainingClass();
                        HashSet<EObject> l = (HashSet<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new HashSet<EObject>();
                            classPredicatesIndex.put(c, l);
                            QueryUtils.addSubTypes(c, classPredicatesIndex, l);
                        }
                        l.add(element);
                    }
                }
                if (name != null) {
                    namesIndex.put(name, element);
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        return classPredicatesIndex;
    }

    public static Map getClassPredicatesNoSubClassesIndex(SimpleSearchQuery query) {
        final HashMap whereExpressionValuesIndex = new HashMap();
        final HashMap classPredicatesIndex = new HashMap();
        final HashMap namesIndex = new HashMap();
        ArrayList<WhereExpression> roots = new ArrayList<WhereExpression>();
        if (query.getWhereExpression() == null) {
            return classPredicatesIndex;
        }
        roots.add(query.getWhereExpression());
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(roots){

            protected boolean beforeChildren(EObject element) {
                String name = QueryUtils.getElementName(element);
                if (name != null && name.startsWith(QueryUtils.DOLLAR_SIGN)) {
                    return super.beforeChildren(element);
                }
                if (whereExpressionValuesIndex.containsKey(element)) {
                    return super.beforeChildren(element);
                }
                whereExpressionValuesIndex.put(element, null);
                if (element instanceof SimpleOperand) {
                    SimpleOperand o = (SimpleOperand)element;
                    EClass c = o.getType();
                    if (c != null) {
                        ArrayList<EObject> l = (ArrayList<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new ArrayList<EObject>();
                            classPredicatesIndex.put(c, l);
                        }
                        if (!l.contains(element)) {
                            l.add(element);
                        }
                    } else if (o.getFeature() != null) {
                        c = o.getFeature().getEContainingClass();
                        ArrayList<EObject> l = (ArrayList<EObject>)classPredicatesIndex.get(c);
                        if (l == null) {
                            l = new ArrayList<EObject>();
                            classPredicatesIndex.put(c, l);
                        }
                        if (!l.contains(element)) {
                            l.add(element);
                        }
                    }
                }
                if (name != null) {
                    namesIndex.put(name, element);
                }
                return super.beforeChildren(element);
            }
        };
        containmentTraverser.traverse();
        return classPredicatesIndex;
    }

    public static void removeClass(SimpleSearchQuery searchQuery, EClass clazz) {
        HashSet<EClass> s = new HashSet<EClass>();
        s.add(clazz);
        QueryUtils.removeClasses(searchQuery, s);
    }

    public static SimpleSearchQuery getEmptyQuery() {
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        query.setName("EmptyFilter");
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        query.setWhereExpression(logicalExpression);
        return query;
    }

    public static TimeBasedCorrelationQuery getEmptyTimeBasedCorrelationQuery() {
        TimeBasedCorrelationQuery query = ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
        query.setName("EmptyFilter");
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
        query.setWhereExpression(logicalExpression);
        return query;
    }
}

