/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.hierarchy.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.loaders.util.AgentsContext;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.loaders.util.ResourceExtensions;
import org.eclipse.hyades.loaders.util.XMLResourceLoader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.ContainmentTraverser;
import org.eclipse.hyades.models.hierarchy.util.EMFUtil;
import org.eclipse.hyades.models.hierarchy.util.EObjectVisitor;
import org.eclipse.hyades.models.hierarchy.util.HierarchyXMISaveImpl;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IndexHashTable;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;

public class HierarchyXMIResourceImpl
extends XMIResourceImpl
implements XMIResource,
IHyadesExtendedResource {
    private static final int INDEX_MAX = 10000;
    protected HierarchyContext context = null;
    protected boolean register = true;
    private ArrayList intAndStrList = new ArrayList(10000);
    private ArrayList featureList = new ArrayList();
    private ArrayList containerList = new ArrayList();
    private StringBuffer result = new StringBuffer();
    private HashMap objectIndexes;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$HierarchyContext;
    static /* synthetic */ Class class$org$eclipse$hyades$loaders$util$AgentsContext;

    public HierarchyXMIResourceImpl() {
        this.initHierarchyResource();
    }

    public HierarchyXMIResourceImpl(URI uri) {
        super(uri);
        this.initHierarchyResource();
    }

    public EObject getEObject(String uriFragment) {
        if (!this.isPath(uriFragment)) {
            if (this.idToEObjectMap != null) {
                EObject eObject = (EObject)this.idToEObjectMap.get(uriFragment);
                return eObject;
            }
            return null;
        }
        return super.getEObject(uriFragment);
    }

    public String getIndexStr(int index) {
        int size = this.intAndStrList.size();
        if (index >= size) {
            this.intAndStrList.ensureCapacity(index + 1);
            int i = size;
            while (i < index) {
                this.intAndStrList.add(i, null);
                ++i;
            }
            String indexStr = Integer.toString(index);
            this.intAndStrList.add(index, indexStr);
            return indexStr;
        }
        if (this.intAndStrList.get(index) == null) {
            String indexStr = Integer.toString(index);
            this.intAndStrList.set(index, indexStr);
            return indexStr;
        }
        return (String)this.intAndStrList.get(index);
    }

    public String getURIFragment(EObject eObject) {
        String id = EcoreUtil.getID((EObject)eObject);
        if (id != null) {
            return id;
        }
        this.result.setLength(0);
        EObject container = eObject.eContainer();
        while (container != null) {
            EReference eStructuralFeature = eObject.eContainmentFeature();
            if (eStructuralFeature.isMany()) {
                EList eList = (EList)container.eGet((EStructuralFeature)eStructuralFeature, false);
                int index = eList.indexOf((Object)eObject);
                if (index < 10000) {
                    this.result.insert(0, this.getIndexStr(index));
                } else {
                    this.result.insert(0, index);
                }
                this.result.insert(0, '.');
                this.result.insert(0, eStructuralFeature.getName());
                this.result.insert(0, '@');
            } else {
                this.result.insert(0, eStructuralFeature.getName());
                this.result.insert(0, '@');
            }
            this.result.insert(0, '/');
            eObject = container;
            container = eObject.eContainer();
        }
        this.result.insert(0, this.getURIFragmentRootSegment(eObject));
        this.result.insert(0, '/');
        return this.result.toString();
    }

    private void addIndex(EList list, EObject object) {
        int index;
        if (list.size() < 10000) {
            int index2 = list.indexOf((Object)object);
            if (index2 < 10000) {
                this.result.insert(0, this.getIndexStr(index2));
            } else {
                this.result.insert(0, index2);
            }
            return;
        }
        IndexHashTable objects = (IndexHashTable)this.objectIndexes.get(list);
        if (objects == null) {
            objects = new IndexHashTable();
        } else {
            index = objects.get(object);
            if (index != -1) {
                this.result.insert(0, index);
                return;
            }
        }
        index = list.indexOf((Object)object);
        if (index < 10000) {
            this.result.insert(0, this.getIndexStr(index));
        } else {
            this.result.insert(0, index);
        }
        objects.put(object, index);
    }

    public void attached(EObject value) {
        if (this.register) {
            LookupServiceExtensions.getInstance().register(this.getContext(value), value);
        }
    }

    public void detached(EObject value) {
        LookupServiceExtensions.getInstance().deregister(this.getContext(value), value);
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.doLoad() uri=" + this.getURI(), true);
        try {
            this.register = false;
            super.doLoad(inputStream, options);
            ContainmentTraverser containmentTraverser = new ContainmentTraverser((Collection)this.getContents());
            EObjectVisitor objectVisitor = new EObjectVisitor(){

                public boolean afterChildren(EObject element) {
                    return true;
                }

                public boolean beforeChildren(EObject element) {
                    LookupServiceExtensions.getInstance().register(HierarchyXMIResourceImpl.this.getContext(element), element);
                    return true;
                }
            };
            containmentTraverser.registerVisitors(objectVisitor);
            containmentTraverser.traverse();
            this.register = true;
        }
        catch (IOException e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        p.stopAndPrintStatus(Arrays.asList(new Throwable().getStackTrace()).toString());
    }

    public void doShallowDelete() {
        this.unloadLookupContext();
        Iterator iter = EMFUtil.delete(this).iterator();
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            if (res == null) continue;
            res.setModified(true);
        }
        if (this.context != null && this.context.getAgentProxy() != null) {
            this.context.getAgentProxy().setAgent(null);
        }
    }

    public void doShallowUnload() {
        this.unloadLookupContext();
        EMFUtil.unload(this);
    }

    protected HierarchyContext getContext(EObject object) {
        if (this.context == null && object instanceof TRCAgent) {
            this.context = (HierarchyContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, this.getURI().toString());
            if (this.context == null) {
                this.context = new HierarchyContext();
            }
            TRCAgent agent = (TRCAgent)object;
            AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(agent.getRuntimeId()));
            if (agentsContext == null) {
                agentsContext = new AgentsContext(agent.getRuntimeId());
                LookupServiceExtensions.getInstance().register(null, agentsContext);
            }
            agentsContext.registerAgent(agent);
            this.context.setAgent(agent);
            this.context.setContextURI(this.getURI().toString());
            LookupServiceExtensions.getInstance().register(null, this.context);
            return null;
        }
        if (object instanceof UnresolvedCorrelation) {
            return null;
        }
        return this.context;
    }

    protected XMLLoad createXMLLoad() {
        XMLResourceLoader resourceLoader = null;
        try {
            resourceLoader = (XMLResourceLoader)ResourceExtensions.getInstance().get(this.getURI().fileExtension());
            if (resourceLoader != null) {
                resourceLoader = (XMLResourceLoader)resourceLoader.getClass().newInstance();
                resourceLoader.setXMLHelper(this.createXMLHelper());
            }
        }
        catch (Exception e) {
            HierarchyPlugin.log(e.getLocalizedMessage());
        }
        if (resourceLoader == null) {
            return super.createXMLLoad();
        }
        return resourceLoader;
    }

    protected XMLSave createXMLSave() {
        return new HierarchyXMISaveImpl(this.createXMLHelper());
    }

    protected void doUnload() {
        PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.doUnload() uri=" + this.getURI(), true);
        this.doShallowUnload();
        p.stopAndPrintStatus();
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.doSave() uri=" + this.getURI(), true);
        try {
            super.doSave(outputStream, options);
        }
        catch (IOException e) {
            p.stopAndPrintStatus(e.getLocalizedMessage());
            throw e;
        }
        p.stopAndPrintStatus();
    }

    protected void unloadLookupContext() {
        if (this.context != null) {
            if (this.context.getAgent() != null) {
                TRCAgent agent = this.context.getAgent();
                AgentsContext agentsContext = (AgentsContext)LookupServiceExtensions.getInstance().locate(null, class$org$eclipse$hyades$loaders$util$AgentsContext == null ? (class$org$eclipse$hyades$loaders$util$AgentsContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.AgentsContext")) : class$org$eclipse$hyades$loaders$util$AgentsContext, LoadersUtils.getLookUpKey(agent.getRuntimeId()));
                if (agentsContext != null) {
                    agentsContext.deregisterAgent(agent);
                }
                this.deregisterContents((List)this.getContents());
            }
            LookupServiceExtensions.getInstance().deregister(this.context);
            LookupServiceExtensions.getInstance().deregister(null, class$org$eclipse$hyades$loaders$util$HierarchyContext == null ? (class$org$eclipse$hyades$loaders$util$HierarchyContext = HierarchyXMIResourceImpl.class$("org.eclipse.hyades.loaders.util.HierarchyContext")) : class$org$eclipse$hyades$loaders$util$HierarchyContext, this.getURI().toString());
            this.context = null;
        }
    }

    private void deregisterContents(List l) {
        ContainmentTraverser containmentTraverser = new ContainmentTraverser(l);
        EObjectVisitor objectVisitor = new EObjectVisitor(){

            public boolean afterChildren(EObject element) {
                LookupServiceExtensions.getInstance().deregister(HierarchyXMIResourceImpl.this.context, element);
                return true;
            }

            public boolean beforeChildren(EObject element) {
                return true;
            }
        };
        containmentTraverser.registerVisitors(objectVisitor);
        containmentTraverser.traverse();
    }

    private void initHierarchyResource() {
        int i = 0;
        while (i < 10000) {
            this.intAndStrList.add(i, null);
            ++i;
        }
    }

    public boolean delete() {
        PerfUtil p = new PerfUtil("HierarchyXMIResourceImpl.delete() uri=" + this.getURI(), true);
        this.doShallowDelete();
        p.stopAndPrintStatus();
        return true;
    }

    public boolean deleteObjects(EList uris) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean unloadObjects(EList uris) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

