/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.User;

public class NodeFactory {
    private static final int INITIAL_SERVERS = 16;
    private static Node[] _servers = new Node[16];

    public static Node createNode(String hostname) throws UnknownHostException {
        try {
            return NodeFactory.createNode(hostname, null);
        }
        catch (DuplicateUserException e) {
            return NodeFactory.containsNode(hostname, null);
        }
    }

    public static Node createNode(String hostname, Principal principal) throws UnknownHostException, DuplicateUserException {
        Node result = NodeFactory.containsNode(hostname, principal);
        if (result == null) {
            InetAddress addr = InetAddress.getByName(hostname);
            return NodeFactory.addNode(hostname, addr, principal);
        }
        throw new DuplicateUserException();
    }

    public static Node createNode(InetAddress address) throws UnknownHostException {
        return NodeFactory.createNode(address, null);
    }

    public static Node createNode(InetAddress address, Principal principal) throws UnknownHostException {
        String hostname = address.getHostName();
        Node result = NodeFactory.containsNode(hostname, principal);
        if (result == null) {
            result = NodeFactory.addNode(hostname, address, principal);
        }
        return result;
    }

    public static Node getLocalHost() throws UnknownHostException {
        if (_servers[0] == null) {
            throw new UnknownHostException();
        }
        return _servers[0];
    }

    public static Node getLocalHost(Principal principal) throws UnknownHostException {
        if (_servers[0] == null) {
            throw new UnknownHostException();
        }
        String hostname = _servers[0].getName();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node addNode(String name, InetAddress addr, Principal principal) {
        if (name.equals("localhost")) {
            try {
                name = InetAddress.getLocalHost().getHostName();
                InetAddress[] addrs = InetAddress.getAllByName(name);
                addr = addrs[0];
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        Node[] nodeArray = _servers;
        synchronized (_servers) {
            int i = 0;
            while (i < _servers.length) {
                if (_servers[i] == null) {
                    NodeFactory._servers[i] = new NodeImpl(name, addr);
                    if (principal instanceof User) {
                        ((NodeImpl)_servers[i]).setUser((User)principal);
                    } else if (principal instanceof Application) {
                        ((NodeImpl)_servers[i]).setApplication((Application)principal);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return _servers[i];
                }
                ++i;
            }
            Node[] oldEntries = _servers;
            _servers = new Node[oldEntries.length + 1];
            int i2 = 0;
            while (i2 < oldEntries.length) {
                NodeFactory._servers[i2] = oldEntries[i2];
                ++i2;
            }
            NodeFactory._servers[oldEntries.length] = new NodeImpl(name, addr);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return _servers[oldEntries.length];
        }
    }

    private static Node containsNode(String name) {
        return NodeFactory.containsNode(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node containsNode(String name, Principal principal) {
        Node[] nodeArray = _servers;
        synchronized (_servers) {
            if (name.equals("localhost")) {
                try {
                    name = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            InetAddress[] addresses = null;
            try {
                addresses = InetAddress.getAllByName(name);
                addresses = InetAddress.getAllByName(addresses[0].getHostName());
            }
            catch (UnknownHostException e) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            int i = 0;
            while (i < _servers.length) {
                if (_servers[i] != null) {
                    int k = 0;
                    while (k < addresses.length) {
                        InetAddress temp = _servers[i].getInetAddress();
                        if (addresses[k].equals(temp)) {
                            if (principal == null) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return _servers[i];
                            }
                            if (principal instanceof User && _servers[i].getUser() != null) {
                                if (principal.getName().equals(_servers[i].getUser().getName())) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return _servers[i];
                                }
                            } else if (principal instanceof Application && _servers[i].getApplication() != null && principal.getName().equals(_servers[i].getApplication().getName())) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return _servers[i];
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public static Node getNode(InetAddress addr) {
        return NodeFactory.getNode(addr, null);
    }

    public static Node getNode(InetAddress addr, Principal principal) {
        return NodeFactory.containsNode(addr.getHostName(), principal);
    }

    public static Node getNode(String name, Principal principal) throws UnknownHostException {
        return NodeFactory.getNode(InetAddress.getByName(name), principal);
    }

    static {
        try {
            NodeFactory._servers[0] = NodeFactory.createNode(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {}
    }
}

