/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.execution.local;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Random;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.core.file.IFileManager;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.execution.local.NodeImpl;

public class FileManagerExtendedTest {
    private static final int FILE_COUNT = 10;
    private static final int FILE_SAMPLE_SIZE = 10;
    private static final String HEADER = "File transfer test with a file of size: ";
    private static final String HOST = "127.0.0.1";
    private static final int ITERATIONS = 10000;
    private static final int OFFSET = 4096;
    private static final int COMMAND_INTERVAL_SLEEP = 1000;
    private static final int CONCURRENT_CLIENT_THREADS = 1;
    private static final int CONCURRENT_CLIENT_WORKER_THREADS = 1;
    private static final int THREAD_START_DELAY = 1250;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i = 0;
        while (i < 1) {
            new Thread(){

                public void run() {
                    new FileManagerExtendedTest().execute();
                }
            }.start();
            Thread thread = Thread.currentThread();
            synchronized (thread) {
                try {
                    Thread.currentThread().wait(1250L);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ++i;
        }
    }

    private File createAndPopulateFile(String name, String extension, int size) throws IOException {
        File temp = File.createTempFile(name, extension);
        RandomAccessFile file = new RandomAccessFile(temp, "rw");
        FileChannel channel = file.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
        byteBuffer.clear();
        String string = HEADER + size;
        byteBuffer.put(string.getBytes("UTF-8"));
        byteBuffer.put(this.getFixedLengthRandomBytes(size - string.length()));
        byteBuffer.flip();
        channel.position(0L);
        channel.write(byteBuffer);
        channel.close();
        file.close();
        return temp;
    }

    private IFileManagerExtended.FileIdentifierList createDestinationIdentifiers(IFileManagerExtended.FileIdentifierList sourceIdentifiers) {
        IFileManagerExtended.FileIdentifierList destinationIdentifiers = IFileManagerExtended.FileIdentifierList.create();
        Iterator iterator = sourceIdentifiers.iterator();
        while (iterator.hasNext()) {
            String fileIdentifier = (String)iterator.next();
            int extension = fileIdentifier.lastIndexOf(".");
            destinationIdentifiers.add(fileIdentifier.substring(0, extension).concat("-destination") + fileIdentifier.substring(extension));
        }
        return destinationIdentifiers;
    }

    public void execute() {
        NodeImpl node = new NodeImpl(HOST);
        ISession session = null;
        try {
            session = node.connect("10002", null, 10000);
        }
        catch (UnknownHostException e) {
        }
        catch (UnknownDaemonException e) {
        }
        catch (DaemonConnectException e) {
            // empty catch block
        }
        IFileManager fileManager = node.getFileManager();
        Assert.isTrue((boolean)(fileManager instanceof IFileManagerExtended));
        final IFileManagerExtended manager = (IFileManagerExtended)fileManager;
        try {
            final IFileManagerExtended.FileIdentifierList sourceFileIdentifiers = this.generateSourceTestFiles();
            final IFileManagerExtended.FileIdentifierList destinationFileIdentifiers = this.createDestinationIdentifiers(sourceFileIdentifiers);
            int i = 0;
            while (i < 1) {
                new Thread(){

                    public void run() {
                        try {
                            Assert.isTrue((boolean)manager.isServerAvailable());
                            Thread.sleep(1000L);
                            manager.putFile(sourceFileIdentifiers, destinationFileIdentifiers);
                            Thread.sleep(1000L);
                            manager.getFile(sourceFileIdentifiers, destinationFileIdentifiers);
                            Thread.sleep(1000L);
                            manager.deleteFile(destinationFileIdentifiers);
                            Thread.sleep(1000L);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }.start();
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        session.release();
    }

    private IFileManagerExtended.FileIdentifierList generateSourceTestFiles() throws IOException {
        IFileManagerExtended.FileIdentifierList generatedFiles = IFileManagerExtended.FileIdentifierList.create();
        File[] files = new File[10];
        int i = 0;
        while (i < 10) {
            int size = (int)Math.pow(2.0, i) + 4096;
            int j = 0;
            while (j < 10) {
                files[i] = this.createAndPopulateFile("file_" + j + "-" + String.valueOf(size - 4096) + "+" + String.valueOf(4096) + "__", ".dummy", size);
                generatedFiles.add(files[i]);
                ++j;
            }
            ++i;
        }
        return generatedFiles;
    }

    private byte[] getFixedLengthRandomBytes(int count) {
        Random random = new Random(System.currentTimeMillis());
        byte[] bytes = new byte[count];
        random.nextBytes(bytes);
        return bytes;
    }
}

