/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.eclipse.hyades.test.common.event.ExecutionEvent;
import org.eclipse.hyades.test.common.event.TypedEvent;
import org.eclipse.hyades.test.common.event.VerdictEvent;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.IVerdictListener;
import org.eclipse.hyades.test.manual.runner.model.Loop;
import org.eclipse.hyades.test.manual.runner.model.TestCase;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.model.util.Verdict;
import org.eclipse.hyades.test.manual.runner.ui.panel.BasePanel;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

public class TestInvocationExecutionPanel
extends BasePanel
implements IVerdictListener {
    private JComboBox verdictCombo;
    private JTextArea infoText;
    private JButton doneButton;

    public TestInvocationExecutionPanel() {
        TestInvocation.addListener(this);
    }

    protected void createControl() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.add((Component)jPanel2, "Center");
        this.verdictCombo = new JComboBox();
        this.verdictCombo.setAlignmentX(0.0f);
        this.verdictCombo.setPreferredSize(new JTextField().getPreferredSize());
        this.verdictCombo.setEditable(false);
        Iterator iterator = ModelUtil.getVerdicts().iterator();
        while (iterator.hasNext()) {
            this.verdictCombo.addItem(iterator.next());
        }
        JLabel jLabel = new JLabel(RemoteAppResourceBundle.getString("label.Status"));
        jLabel.setLabelFor(this.verdictCombo);
        jLabel.setAlignmentX(0.0f);
        SwingUtil.adjustMnemonic(jLabel);
        jPanel.add(jLabel);
        jPanel.add(this.verdictCombo);
        this.infoText = new JTextArea(3, 0);
        this.infoText.setRequestFocusEnabled(true);
        jLabel = new JLabel(RemoteAppResourceBundle.getString("label.Info"));
        jLabel.setLabelFor(this.infoText);
        jLabel.setAlignmentX(0.0f);
        SwingUtil.adjustMnemonic(jLabel);
        JScrollPane jScrollPane = new JScrollPane(this.infoText, 20, 30);
        jScrollPane.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel2.add(jScrollPane);
        this.doneButton = new JButton();
        this.doneButton.setText(RemoteAppResourceBundle.getString("action.NextTask"));
        SwingUtil.adjustMnemonic(this.doneButton);
        this.doneButton.setToolTipText(RemoteAppResourceBundle.getString("button.done.Description"));
        this.doneButton.setAlignmentY(1.0f);
        this.doneButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.add((Component)jPanel3, "South");
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.doneButton);
    }

    protected boolean isValidData(Object object) {
        TestInvocation testInvocation;
        if (object instanceof TestInvocation && (testInvocation = (TestInvocation)object).getTest() != null) {
            if (testInvocation.getTest() instanceof TestCase) {
                return true;
            }
            TestSuite testSuite = (TestSuite)testInvocation.getTest();
            return !testSuite.getActions().isEmpty();
        }
        return false;
    }

    protected void invalidData() {
        this.infoText.setText("");
    }

    protected void refreshPanel(boolean bl) {
        if (this.getTestInvocation().getVerdictEvent() != null) {
            this.verdictCombo.setSelectedItem(ModelUtil.getVerdict(this.getTestInvocation().getVerdictEvent().getVerdict()));
            this.infoText.setText(BaseString.toString((Object)this.getTestInvocation().getVerdictEvent().getText()));
        } else {
            this.verdictCombo.setSelectedItem(ModelUtil.getDefaultVerdict());
            this.infoText.grabFocus();
            this.infoText.requestFocus();
            this.infoText.setText(null);
        }
    }

    protected void setEditable(boolean bl) {
        this.verdictCombo.setEnabled(bl);
        this.doneButton.setEnabled(bl && this.getTestInvocation().getTest() != null);
        this.infoText.setEditable(bl);
        JTextField jTextField = new JTextField();
        jTextField.setEditable(bl);
        this.infoText.setBackground(jTextField.getBackground());
    }

    public TestInvocation getTestInvocation() {
        return (TestInvocation)this.getCurrentData();
    }

    public void updateCurrentData(EventObject eventObject) {
        if (eventObject.getSource() == this.doneButton && this.verdictCombo.getSelectedItem() != null) {
            Object object;
            if (this.getTestInvocation().getExecutionCount() == 0) {
                if (this.getTestInvocation().getTest() instanceof TestCase && ((TestSuite)(object = ((TestCase)this.getTestInvocation().getTest()).getTestSuite())).getTestInvocation() != null) {
                    TestInvocation testInvocation = ((TestSuite)object).getTestInvocation();
                    Collection collection = ModelUtil.DEFAULT_EXECUTION_MANAGER.getExecutedTestInvocations();
                    if (!collection.contains(testInvocation)) {
                        collection.add(testInvocation);
                        ModelUtil.getEventLogger().logInvocation(testInvocation, 1, null);
                        TypedEvent typedEvent = ModelUtil.createTestTypedEvent(testInvocation);
                        typedEvent.setType(0);
                        ModelUtil.getEventLogger().log((ExecutionEvent)typedEvent);
                    }
                }
                if (this.getTestInvocation().getOwner() instanceof Loop) {
                    ModelUtil.DEFAULT_EXECUTION_MANAGER.startLoop((Loop)this.getTestInvocation().getOwner());
                }
                ModelUtil.getEventLogger().logInvocation(this.getTestInvocation(), 1, null);
                object = ModelUtil.createTestTypedEvent(this.getTestInvocation());
                object.setType(0);
                ModelUtil.getEventLogger().log((ExecutionEvent)object);
            }
            object = ModelUtil.createTestVerdictEvent(this.getTestInvocation());
            object.setVerdict(((Verdict)this.verdictCombo.getSelectedItem()).getValue());
            if (this.infoText.getText() != null && this.infoText.getText().trim().length() > 0) {
                object.setText(this.infoText.getText());
                object.setReason(2);
            }
            ModelUtil.getEventLogger().log((ExecutionEvent)object);
            this.getTestInvocation().setVerdictEvent((VerdictEvent)object);
        }
    }

    public void handleVerdict(TestInvocation testInvocation) {
        if (this.getTestInvocation() == testInvocation) {
            this.setEditable(this.infoText.isEditable());
        }
    }
}

