/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.config.outputters;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.config.StaticParserWrapper;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.commons.FileLogger;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

public class StaticParserOutputter
extends Outputter
implements IOutputter {
    protected Log outLogger;

    public void update() throws AdapterInvalidConfig {
        String key = null;
        super.update();
        Hashtable outputterProperties = this.getProperties();
        if (outputterProperties != null && !outputterProperties.isEmpty()) {
            key = (String)outputterProperties.get(Messages.getString((String)"HyadesGAStaticParserLoggerKeyName"));
        }
        if (key != null) {
            this.outLogger = StaticParserWrapper.getLogInstance(key);
        }
    }

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null || this.outLogger == null) {
            return msgs;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                if (events[i] != null) {
                    try {
                        this.outLogger.trace((Object)events[i]);
                        this.incrementItemsProcessedCount();
                    }
                    catch (Exception ioe) {
                        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
                        String loggerName = "unknown";
                        if (this.outLogger instanceof Logger) {
                            loggerName = ((Logger)this.outLogger).getName();
                        } else if (this.outLogger instanceof FileLogger) {
                            loggerName = ((FileLogger)this.outLogger).getName();
                        }
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), loggerName, ioe.getMessage()});
                        event.setSeverity((short)60);
                        this.log(event);
                    }
                }
                ++i;
            }
            return events;
        }
        return null;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return msgs;
    }
}

