/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class PositionParser {
    static final String POSITION_SEPARATOR = "@@";
    static final String HASH_START = "$h(";
    static final String HASH_END = ")";

    public static List getPositionedString(String strPositions, boolean bStripHash) {
        if (strPositions == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Object> newList = new ArrayList<Object>();
        StringTokenizer s = new StringTokenizer(strPositions, POSITION_SEPARATOR);
        while (s.hasMoreTokens()) {
            list.add(s.nextToken());
        }
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String current = (String)iterator.next();
            if (current == null) continue;
            current.trim();
            if (current.equals("")) continue;
            Object result = null;
            if (PositionParser.isHashPosition(current)) {
                result = bStripHash ? current.substring(4, current.length() - 2).trim() : current;
            } else {
                try {
                    result = Long.decode(current);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (result == null) continue;
            newList.add(result);
        }
        return newList;
    }

    private static boolean isHashPosition(String text) {
        if (text != null) {
            return text.startsWith(HASH_START) && text.endsWith(HASH_END);
        }
        return false;
    }
}

