/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.logging.core;

import java.awt.EventQueue;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.core.XmlUtility;

public final class XmlGenerator {
    private String lineSeparator = null;
    private String loggingLevel = null;
    private String loggerName = null;
    private boolean format;
    private int currentLevel;
    private int maxLevels;
    private boolean includeTimeStamp = false;
    private final byte SIMPLE_TYPE = 1;
    private final byte COMPLEX_TYPE = (byte)2;

    public XmlGenerator() {
    }

    public XmlGenerator(String string) {
        this.loggerName = string;
    }

    public static synchronized String getThrowableStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "null";
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toString().trim();
        }
        catch (Exception exception) {
            return throwable.toString();
        }
    }

    public static String getThreadStackTrace(Thread thread) {
        if (thread == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("Stack trace of ");
        stringBuffer.append(thread.toString());
        stringBuffer.append(Constants.LINE_SEPARATOR);
        String string = XmlGenerator.getThrowableStackTrace(new Throwable());
        stringBuffer.append(string.substring(string.indexOf(Constants.LINE_SEPARATOR) + 2));
        return stringBuffer.toString();
    }

    public void reset(String string, boolean bl, int n, boolean bl2) {
        this.loggingLevel = string;
        this.format = bl;
        this.maxLevels = n;
        this.includeTimeStamp = bl2;
    }

    public void reset(String string, boolean bl, int n) {
        this.reset(string, bl, n, false);
    }

    public String objectToXML(Object object) {
        if (object == null) {
            return this.nullObjectToXML(null, null, this.loggerName, this.loggingLevel, null);
        }
        if (this.getType(object.getClass()) == 1) {
            return this.simpleObjectToXML(object, null, this.loggerName, this.loggingLevel, null);
        }
        this.lineSeparator = this.format ? Constants.LINE_SEPARATOR : "";
        this.currentLevel = -1;
        Method[] methodArray = object.getClass().getMethods();
        boolean bl = false;
        int n = methodArray.length - 1;
        while (n >= 0) {
            if (methodArray[n].getName().equals("toCanonicalXMLString") || methodArray[n].getName().equals("externalizeCanonicalXmlString")) {
                bl = true;
                break;
            }
            --n;
        }
        if (bl) {
            try {
                return this.createCanonicalXMLString(object, null, this.loggerName, this.loggingLevel, null);
            }
            catch (Throwable throwable) {
            }
        }
        return this.createXMLTag(object, null).toString().trim();
    }

    private StringBuffer createXMLTag(Object objectArray, String string) {
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indention(++this.currentLevel));
        if (objectArray == null) {
            if (this.currentLevel == 0) {
                stringBuffer.append(this.nullObjectToXML(null, null, this.loggerName, this.loggingLevel, string));
            } else {
                stringBuffer.append(this.nullObjectToXML(null, null, null, null, string));
            }
            stringBuffer.append(this.lineSeparator);
            return stringBuffer;
        }
        Class<?> clazz = objectArray.getClass();
        if (clazz.isArray()) {
            string3 = "Array";
            string2 = string3.concat(XmlGenerator.getClassName(clazz));
        } else {
            string2 = clazz.getName().trim();
            string3 = this.removeTagNameChars(string2.substring(string2.lastIndexOf(46) + 1));
        }
        String string4 = string2 + "_" + new Guid().toString();
        try {
            if (this.currentLevel == 0) {
                stringBuffer.append(this.createCanonicalXMLString(objectArray, string4, this.loggerName, this.loggingLevel, string));
            } else {
                stringBuffer.append(this.createCanonicalXMLString(objectArray, string4, null, null, string));
            }
            stringBuffer.append(this.lineSeparator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.getType(clazz) == 1) {
            if (this.currentLevel == 0) {
                stringBuffer.append(this.simpleObjectToXML(objectArray, string4, this.loggerName, this.loggingLevel, string));
            } else {
                stringBuffer.append(this.simpleObjectToXML(objectArray, string4, null, null, string));
            }
            stringBuffer.append(this.lineSeparator);
            return stringBuffer;
        }
        stringBuffer.append("<");
        stringBuffer.append(string3);
        stringBuffer.append(this.getNameAttribute(string));
        stringBuffer.append(this.getIdAttribute(string4));
        stringBuffer.append(this.getTimeStamp());
        if (this.currentLevel == 0) {
            stringBuffer.append(XmlGenerator.getLoggerNameAttribute(this.loggerName));
            stringBuffer.append(XmlGenerator.getLevelAttribute(this.loggingLevel));
        }
        if (clazz.isArray() || objectArray instanceof Collection || objectArray instanceof Enumeration || objectArray instanceof Iterator) {
            if (!clazz.isArray()) {
                if (objectArray instanceof Collection) {
                    objectArray = ((Collection)objectArray).toArray();
                } else if (objectArray instanceof Enumeration) {
                    Vector vector = new Vector();
                    while (((Enumeration)objectArray).hasMoreElements()) {
                        vector.add(((Enumeration)objectArray).nextElement());
                    }
                    objectArray = vector.toArray();
                } else if (objectArray instanceof Iterator) {
                    Vector vector = new Vector();
                    while (((Iterator)objectArray).hasNext()) {
                        vector.add(((Iterator)objectArray).next());
                    }
                    objectArray = vector.toArray();
                }
            }
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            if (this.currentLevel == this.maxLevels) {
                stringBuffer.append(this.indention(this.currentLevel + 1) + this.getEndOfNestingTag());
            } else {
                this.logEachEntry(objectArray, stringBuffer, clazz, string4, string);
            }
            this.endTag(string3, stringBuffer);
        } else if (objectArray instanceof Thread) {
            stringBuffer.append(" Name=\"");
            stringBuffer.append(((Thread)objectArray).getName().trim());
            stringBuffer.append("\"");
            stringBuffer.append(" Priority=\"");
            stringBuffer.append(((Thread)objectArray).getPriority());
            stringBuffer.append("\"");
            stringBuffer.append(" Group=\"");
            stringBuffer.append(((Thread)objectArray).getThreadGroup().getName().trim());
            stringBuffer.append("\">");
            stringBuffer.append(this.lineSeparator);
            stringBuffer.append(this.stackTraceToXML(this.currentLevel));
            this.endTag(string3, stringBuffer);
        } else if (objectArray instanceof Throwable) {
            String string5 = ((Throwable)objectArray).getMessage();
            if (string5 != null) {
                stringBuffer.append(" Message=\"");
                stringBuffer.append(string5);
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            StringTokenizer stringTokenizer = new StringTokenizer(XmlGenerator.getThrowableStackTrace((Throwable)objectArray), Constants.LINE_SEPARATOR);
            stringTokenizer.nextToken();
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    stringBuffer.append(this.simpleObjectToXML(stringTokenizer.nextToken().trim(), null, null, null, string));
                    stringBuffer.append(this.lineSeparator);
                }
            }
            catch (Exception exception) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.simpleObjectToXML(XmlGenerator.getThrowableStackTrace((Throwable)objectArray), null, null, null, string));
                stringBuffer.append(this.lineSeparator);
            }
            this.endTag(string3, stringBuffer);
        } else if (objectArray instanceof Map) {
            stringBuffer.append(">");
            stringBuffer.append(this.lineSeparator);
            if (this.currentLevel == this.maxLevels) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.getEndOfNestingTag());
            } else {
                Iterator iterator = ((Map)objectArray).keySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    stringBuffer.append(this.indention(this.currentLevel + 1)).append("<Entry>").append(this.lineSeparator).append(this.indention(this.currentLevel + 2)).append("<Key>").append(this.lineSeparator).append(this.indention(this.currentLevel + 3)).append(this.createXMLTag(k, null).toString().trim());
                    --this.currentLevel;
                    stringBuffer.append(this.indention(this.currentLevel + 2)).append("</Key>").append(this.lineSeparator).append(this.indention(this.currentLevel + 2)).append("<Value>").append(this.lineSeparator).append(this.indention(this.currentLevel + 3)).append(this.createXMLTag(((Map)objectArray).get(k), null).toString().trim());
                    --this.currentLevel;
                    stringBuffer.append(this.indention(this.currentLevel + 2)).append("</Value>").append(this.lineSeparator).append(this.indention(this.currentLevel + 1)).append("</Entry>").append(this.lineSeparator);
                }
            }
            this.endTag(string3, stringBuffer);
        } else if (objectArray instanceof EventQueue) {
            stringBuffer.append("/>");
            stringBuffer.append(this.lineSeparator);
        } else if (objectArray instanceof Class) {
            stringBuffer.append(" Name=\"").append(XmlGenerator.getClassName((Class)objectArray)).append("\"").append(" Type=\"");
            if (this.isPrimitive((Class)objectArray)) {
                stringBuffer.append("primitive");
            } else if (((Class)objectArray).isArray()) {
                stringBuffer.append("array");
            } else if (((Class)objectArray).isInterface()) {
                stringBuffer.append("interface");
            } else {
                stringBuffer.append("class");
            }
            stringBuffer.append("\"");
            stringBuffer.append(" Package=\"");
            try {
                stringBuffer.append(((Class)objectArray).getPackage().getName());
            }
            catch (Exception exception) {
                stringBuffer.append("null");
            }
            stringBuffer.append("\"");
            stringBuffer.append(" Modifers=\"").append(Modifier.toString(((Class)objectArray).getModifiers())).append("\"");
            stringBuffer.append(" Superclass=\"");
            try {
                stringBuffer.append(XmlGenerator.getClassName(((Class)objectArray).getSuperclass()));
            }
            catch (Exception exception) {
                stringBuffer.append("null");
            }
            stringBuffer.append("\"/>").append(this.lineSeparator);
        } else {
            Object object;
            Method method;
            String string6;
            Vector<Method> vector = new Vector<Method>();
            Vector<Method> vector2 = new Vector<Method>();
            Method[] methodArray = new Method[]{};
            try {
                methodArray = clazz.getMethods();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = methodArray.length - 1;
            while (n >= 0) {
                string6 = methodArray[n].getName().trim();
                if (string6.length() > 3 && string6.startsWith("get") && methodArray[n].getParameterTypes().length == 0) {
                    if (this.getType(methodArray[n].getReturnType()) == 1) {
                        vector.addElement(methodArray[n]);
                    } else {
                        vector2.addElement(methodArray[n]);
                    }
                }
                --n;
            }
            if (vector.size() + vector2.size() == 0) {
                stringBuffer.append("/>");
                stringBuffer.append(this.lineSeparator);
                return stringBuffer;
            }
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                block72: {
                    method = (Method)vector.elementAt(n2);
                    string6 = method.getName().trim().substring(3);
                    stringBuffer.append(" ");
                    stringBuffer.append(string6);
                    stringBuffer.append("=\"");
                    try {
                        object = method.invoke((Object)objectArray, null);
                        if (object != null) {
                            stringBuffer.append(XmlUtility.normalize(object.toString().trim()));
                            break block72;
                        }
                        throw new Exception();
                    }
                    catch (Exception exception) {
                        stringBuffer.append("null");
                    }
                }
                stringBuffer.append("\"");
                --n2;
            }
            if (vector2.size() == 0) {
                stringBuffer.append("/>");
                stringBuffer.append(this.lineSeparator);
                return stringBuffer;
            }
            stringBuffer.append(">").append(this.lineSeparator);
            if (this.currentLevel == this.maxLevels) {
                stringBuffer.append(this.indention(this.currentLevel + 1));
                stringBuffer.append(this.getEndOfNestingTag());
            } else {
                int n3 = vector2.size() - 1;
                while (n3 >= 0) {
                    block73: {
                        method = (Method)vector2.elementAt(n3);
                        try {
                            object = method.invoke((Object)objectArray, null);
                            if (object != null) {
                                stringBuffer.append(this.createXMLTag(object, method.getName().trim().substring(3)).toString());
                                --this.currentLevel;
                                break block73;
                            }
                            throw new Exception();
                        }
                        catch (Exception exception) {
                            String string7;
                            stringBuffer.append(this.indention(this.currentLevel + 1));
                            Class<?> clazz2 = method.getReturnType();
                            if (clazz2.isArray()) {
                                string7 = "Array";
                            } else {
                                string7 = clazz2.getName().trim();
                                string7 = this.removeTagNameChars(string7.substring(string7.lastIndexOf(46) + 1));
                            }
                            stringBuffer.append(this.nullObjectToXML(string7, null, null, null, method.getName().trim().substring(3)));
                            stringBuffer.append(this.lineSeparator);
                        }
                    }
                    --n3;
                }
            }
            this.endTag(string3, stringBuffer);
        }
        return stringBuffer;
    }

    private void endTag(String string, StringBuffer stringBuffer) {
        stringBuffer.append(this.indention(this.currentLevel)).append("</").append(string).append(">").append(this.lineSeparator);
    }

    private void logEachEntry(Object object, StringBuffer stringBuffer, Class clazz, String string, String string2) {
        if (object instanceof boolean[]) {
            int n;
            int n2 = n = ((boolean[])object).length - 1;
            while (n2 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((boolean[])object)[Math.abs(n2 - n)])).append(this.lineSeparator);
                --n2;
            }
        } else if (object instanceof char[]) {
            int n;
            int n3 = n = ((char[])object).length - 1;
            while (n3 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((char[])object)[Math.abs(n3 - n)])).append(this.lineSeparator);
                --n3;
            }
        } else if (object instanceof byte[]) {
            int n;
            int n4 = n = ((byte[])object).length - 1;
            while (n4 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((byte[])object)[Math.abs(n4 - n)])).append(this.lineSeparator);
                --n4;
            }
        } else if (object instanceof short[]) {
            int n;
            int n5 = n = ((short[])object).length - 1;
            while (n5 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((short[])object)[Math.abs(n5 - n)])).append(this.lineSeparator);
                --n5;
            }
        } else if (object instanceof int[]) {
            int n;
            int n6 = n = ((int[])object).length - 1;
            while (n6 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((int[])object)[Math.abs(n6 - n)])).append(this.lineSeparator);
                --n6;
            }
        } else if (object instanceof long[]) {
            int n;
            int n7 = n = ((long[])object).length - 1;
            while (n7 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((long[])object)[Math.abs(n7 - n)])).append(this.lineSeparator);
                --n7;
            }
        } else if (object instanceof float[]) {
            int n;
            int n8 = n = ((float[])object).length - 1;
            while (n8 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((float[])object)[Math.abs(n8 - n)])).append(this.lineSeparator);
                --n8;
            }
        } else if (object instanceof double[]) {
            int n;
            int n9 = n = ((double[])object).length - 1;
            while (n9 >= 0) {
                stringBuffer.append(this.indention(this.currentLevel + 1)).append(XmlGenerator.primitiveToXML(((double[])object)[Math.abs(n9 - n)])).append(this.lineSeparator);
                --n9;
            }
        } else if (this.currentLevel == this.maxLevels) {
            stringBuffer.append(this.indention(this.currentLevel + 1));
            stringBuffer.append(this.getEndOfNestingTag());
        } else {
            int n = 0;
            int n10 = ((Object[])object).length - 1;
            while (n10 >= 0) {
                if (((Object[])object)[n] == null) {
                    stringBuffer.append(this.indention(this.currentLevel + 1));
                    if (this.currentLevel + 1 == 0) {
                        stringBuffer.append(this.nullObjectToXML(clazz.getComponentType().getName().trim(), string, this.loggerName, this.loggingLevel, string2));
                    } else {
                        stringBuffer.append(this.nullObjectToXML(clazz.getComponentType().getName().trim(), string, null, null, string2));
                    }
                    stringBuffer.append(this.lineSeparator);
                } else {
                    stringBuffer.append(this.createXMLTag(((Object[])object)[n], null).toString());
                    --this.currentLevel;
                }
                ++n;
                --n10;
            }
        }
    }

    public static String primitiveToXML(boolean bl, String string, String string2, boolean bl2) {
        return "<boolean" + (bl2 ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(bl) + "\"/>";
    }

    public static String primitiveToXML(boolean bl) {
        return XmlGenerator.primitiveToXML(bl, null, null, false);
    }

    public static String primitiveToXML(boolean bl, String string) {
        return XmlGenerator.primitiveToXML(bl, string, null, false);
    }

    public static String primitiveToXML(char c, String string, String string2, boolean bl) {
        return "<char" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + XmlUtility.normalize(String.valueOf(c)) + "\"/>";
    }

    public static String primitiveToXML(char c) {
        return XmlGenerator.primitiveToXML(c, null, null, false);
    }

    public static String primitiveToXML(char c, String string) {
        return XmlGenerator.primitiveToXML(c, string, null, false);
    }

    public static String primitiveToXML(byte by, String string, String string2, boolean bl) {
        return "<byte" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(by) + "\"/>";
    }

    public static String primitiveToXML(byte by) {
        return XmlGenerator.primitiveToXML(by, null, null, false);
    }

    public static String primitiveToXML(byte by, String string) {
        return XmlGenerator.primitiveToXML(by, string, null, false);
    }

    public static String primitiveToXML(short s, String string, String string2, boolean bl) {
        return "<short" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(s) + "\"/>";
    }

    public static String primitiveToXML(short s) {
        return XmlGenerator.primitiveToXML(s, null, null, false);
    }

    public static String primitiveToXML(short s, String string) {
        return XmlGenerator.primitiveToXML(s, string, null, false);
    }

    public static String primitiveToXML(int n, String string, String string2, boolean bl) {
        return "<int" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(n) + "\"/>";
    }

    public static String primitiveToXML(int n) {
        return XmlGenerator.primitiveToXML(n, null, null, false);
    }

    public static String primitiveToXML(int n, String string) {
        return XmlGenerator.primitiveToXML(n, string, null, false);
    }

    public static String primitiveToXML(long l, String string, String string2, boolean bl) {
        return "<long" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(l) + "\"/>";
    }

    public static String primitiveToXML(long l) {
        return XmlGenerator.primitiveToXML(l, null, null, false);
    }

    public static String primitiveToXML(long l, String string) {
        return XmlGenerator.primitiveToXML(l, string, null, false);
    }

    public static String primitiveToXML(float f, String string, String string2, boolean bl) {
        return "<float" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(f) + "\"/>";
    }

    public static String primitiveToXML(float f) {
        return XmlGenerator.primitiveToXML(f, null, null, false);
    }

    public static String primitiveToXML(float f, String string) {
        return XmlGenerator.primitiveToXML(f, string, null, false);
    }

    public static String primitiveToXML(double d, String string, String string2, boolean bl) {
        return "<double" + (bl ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "") + XmlGenerator.getLoggerNameAttribute(string) + XmlGenerator.getLevelAttribute(string2) + " Value=\"" + String.valueOf(d) + "\"/>";
    }

    public static String primitiveToXML(double d) {
        return XmlGenerator.primitiveToXML(d, null, null, false);
    }

    public static String primitiveToXML(double d, String string) {
        return XmlGenerator.primitiveToXML(d, string, null, false);
    }

    private static String getLevelAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " logging.util.MsgLoggerLevel=\"" + string.trim() + "\"";
        }
        return "";
    }

    private static String getLoggerNameAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " logging.util.agent_idref=\"" + string.trim() + "\"";
        }
        return "";
    }

    private String getIdAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " logging.util.id=\"" + string + "\"";
        }
        return "";
    }

    private String getNameAttribute(String string) {
        if (string != null && string.trim().length() != 0) {
            return " Instance_Name=\"" + string.trim() + "\"";
        }
        return "";
    }

    private String getEndOfNestingTag() {
        return "<EndOfNesting Level=\"" + this.maxLevels + "\"/>" + this.lineSeparator;
    }

    private String getTimeStamp() {
        return this.includeTimeStamp ? " time_stamp=\"" + new Date(System.currentTimeMillis()).toString() + "\"" : "";
    }

    private String createCanonicalXMLString(Object object, String string, String string2, String string3, String string4) throws Throwable {
        if (object == null) {
            return this.nullObjectToXML(null, string, string2, string3, string4);
        }
        String string5 = null;
        try {
            string5 = ((String)object.getClass().getMethod("toCanonicalXMLString", null).invoke(object, null)).trim();
        }
        catch (Throwable throwable) {
            string5 = ((String)object.getClass().getMethod("externalizeCanonicalXmlString", null).invoke(object, null)).trim();
        }
        int n = string5.indexOf(47);
        if (!string5.startsWith("<") || !string5.endsWith(">") || n == -1) {
            throw new IllegalArgumentException("Malformed canonical XML string");
        }
        int n2 = string5.indexOf(32);
        int n3 = n2 != -1 ? Math.min(Math.min(n2, n), string5.indexOf(62)) : Math.min(n, string5.indexOf(62));
        string5 = string5.substring(0, n3).concat(this.getNameAttribute(string4)).concat(this.getIdAttribute(string)).concat(XmlGenerator.getLoggerNameAttribute(string2)).concat(XmlGenerator.getLevelAttribute(string3)).concat(this.getTimeStamp()).concat(string5.substring(n3));
        return string5;
    }

    private String simpleObjectToXML(Object object, String string, String string2, String string3, String string4) {
        if (object == null) {
            return this.nullObjectToXML(null, string, string2, string3, string4);
        }
        String string5 = object.getClass().getName().trim();
        return "<" + this.removeTagNameChars(string5.substring(string5.lastIndexOf(46) + 1)) + this.getNameAttribute(string4) + this.getIdAttribute(string) + this.getTimeStamp() + XmlGenerator.getLoggerNameAttribute(string2) + XmlGenerator.getLevelAttribute(string3) + " Value=\"" + XmlUtility.normalize(object.toString().trim()) + "\"/>";
    }

    private String nullObjectToXML(String string, String string2, String string3, String string4, String string5) {
        if (string == null) {
            return "<null" + this.getIdAttribute(string2) + XmlGenerator.getLoggerNameAttribute(string3) + XmlGenerator.getLevelAttribute(string4) + "/>";
        }
        return "<" + this.removeTagNameChars(string) + this.getNameAttribute(string5) + this.getIdAttribute(string2) + XmlGenerator.getLoggerNameAttribute(string3) + XmlGenerator.getLevelAttribute(string4) + " Value=\"null\"/>";
    }

    private byte getType(Class clazz) {
        if (this.isPrimitive(clazz)) {
            return 1;
        }
        return 2;
    }

    private String removeTagNameChars(String string) {
        if (string == null) {
            return "null";
        }
        return string.replace('$', '_');
    }

    private String indention(int n) {
        if (this.format) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String stackTraceToXML(int n) {
        String string = XmlGenerator.getThreadStackTrace(Thread.currentThread());
        if (string == null) {
            return "";
        }
        this.currentLevel = n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.indention(this.currentLevel + 1));
        String string2 = "StackTrace";
        String string3 = "StackTrace";
        String string4 = string2 + "_" + new Guid().toString();
        stringBuffer.append("<");
        stringBuffer.append(string3);
        stringBuffer.append(this.getIdAttribute(string4));
        if (this.currentLevel == 0) {
            stringBuffer.append(XmlGenerator.getLoggerNameAttribute(this.loggerName));
            stringBuffer.append(XmlGenerator.getLevelAttribute(this.loggingLevel));
        }
        stringBuffer.append(" Name=\"");
        stringBuffer.append("Stack Trace");
        stringBuffer.append("\"");
        stringBuffer.append(" CurrentThread=\"");
        stringBuffer.append(Thread.currentThread().getName().trim());
        stringBuffer.append("\">");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        StringTokenizer stringTokenizer = new StringTokenizer(string, Constants.LINE_SEPARATOR);
        stringTokenizer.nextToken();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken().trim();
                if (string5.indexOf("com.ibm.etools.logging.util") != -1) continue;
                stringBuffer.append(this.indention(this.currentLevel + 2));
                stringBuffer.append(this.simpleObjectToXML(string5, null, null, null, null));
                stringBuffer.append(Constants.LINE_SEPARATOR);
            }
        }
        catch (Exception exception) {
            stringBuffer.append(this.indention(this.currentLevel + 1));
            stringBuffer.append(this.simpleObjectToXML(XmlGenerator.getThreadStackTrace(Thread.currentThread()), null, null, null, null));
            stringBuffer.append(Constants.LINE_SEPARATOR);
        }
        stringBuffer.append(this.indention(this.currentLevel + 1));
        stringBuffer.append("</");
        stringBuffer.append(string3);
        stringBuffer.append(">");
        stringBuffer.append(Constants.LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    public String stackTraceToXML() {
        return this.stackTraceToXML(-1);
    }

    private boolean isPrimitive(Class clazz) {
        String string = clazz.getName().trim();
        return clazz.isPrimitive() || string.equals("java.lang.Boolean") || string.equals("java.lang.Character") || string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.math.BigDecimal") || string.equals("java.math.BigInteger") || string.equals("java.lang.String") || string.equals("java.lang.StringBuffer");
    }

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        String string = clazz.getName().trim();
        if (clazz.isArray()) {
            String string2 = string.substring(0, string.lastIndexOf(91) + 1);
            String string3 = string.substring(string.lastIndexOf(91) + 1);
            String string4 = string3.substring(0, 1);
            String string5 = "";
            if (string4.equals("L") && string3.endsWith(";")) {
                string5 = string3.substring(1, string3.length() - 1);
            } else if (string4.equals("B")) {
                string5 = "byte";
            } else if (string4.equals("C")) {
                string5 = "char";
            } else if (string4.equals("D")) {
                string5 = "double";
            } else if (string4.equals("F")) {
                string5 = "float";
            } else if (string4.equals("I")) {
                string5 = "int";
            } else if (string4.equals("J")) {
                string5 = "long";
            } else if (string4.equals("S")) {
                string5 = "short";
            } else if (string4.equals("Z")) {
                string5 = "boolean";
            }
            return string2.concat(string5).concat(string2.replace('[', ']'));
        }
        return string;
    }
}

