/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

public class SecureConnectionImpl
extends ConnectionImpl {
    private boolean handshakeSuccess;

    public void connect(Node node, int port) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._port = port;
        int offset = 0;
        InetAddress[] addrs = node.getAllInetAddresses();
        int protocolOffset = 0;
        String[] sslProtocols = node.getSecurityParameters().getEnabledProtocols();
        if (sslProtocols == null) {
            sslProtocols = new String[]{"SSL"};
        }
        do {
            try {
                SSLContext sslContext = SSLContext.getInstance(sslProtocols[protocolOffset]);
                sslContext.init(node.getSecurityParameters().getKeystoreManager().getKeyManagers(), node.getSecurityParameters().getKeystoreManager().getTrustManagers(), null);
                if (sslContext == null) {
                    Security.addProvider(node.getSecurityParameters().getSecurityProvider());
                    this._socket = SSLSocketFactory.getDefault().createSocket(addrs[offset], port);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent e) {
                        }
                    });
                    ((SSLSocket)this._socket).startHandshake();
                } else {
                    this._socket = sslContext.getSocketFactory().createSocket(addrs[offset], port);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent e) {
                        }
                    });
                }
                String[] cyphers = node.getSecurityParameters().getEnabledCipherSuites();
                if (cyphers != null) {
                    ((SSLSocket)this._socket).setEnabledCipherSuites(node.getSecurityParameters().getEnabledCipherSuites());
                } else {
                    ((SSLSocket)this._socket).setEnabledCipherSuites(((SSLSocket)this._socket).getSupportedCipherSuites());
                }
                ((SSLSocket)this._socket).setUseClientMode(true);
                SSLSession session = ((SSLSocket)this._socket).getSession();
                if (session == null) {
                    throw new UntrustedAgentControllerException();
                }
                if (session.getCipherSuite().equals("SSL_NULL_WITH_NULL_NULL")) {
                    throw new UntrustedAgentControllerException();
                }
                break;
            }
            catch (ConnectException e) {
                if (++offset == addrs.length) {
                    throw e;
                }
                protocolOffset = 0;
            }
            catch (NoSuchAlgorithmException e) {
                if (++protocolOffset != sslProtocols.length) continue;
                throw new ConnectException("Could not get an SSLContext. All protocol specifications were tried");
            }
            catch (KeyManagementException e) {
                // empty catch block
            }
        } while (offset < addrs.length);
        this._node = node;
        this.init();
    }
}

