/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.runner;

import org.eclipse.hyades.test.http.runner.HttpElement;
import org.eclipse.hyades.test.http.runner.HttpResponse;

public class HttpRequest
extends HttpElement {
    private String method;
    private String host;
    private int port;
    private String absolutePath;
    private long thinkTime = 0L;
    private int nPageNum;
    private int pageOrder;
    public static final int PAGE_START = 1;
    public static final int PAGE_MID = 2;
    public static final int PAGE_END = 3;
    public static final int PAGE_ONLY = 4;
    public static final int PAGE_UNDEFINED = 0;
    private boolean bSSL;
    private int nConnID;
    private int connOrder;
    public static final int CONN_START = 1;
    public static final int CONN_MID = 2;
    public static final int CONN_END = 3;
    public static final int CONN_UNDEFINED = 0;
    private HttpResponse response;

    public String getURL() {
        if (this.getHost() == null) {
            return null;
        }
        StringBuffer stringBuffer = !this.bSSL ? new StringBuffer("http://").append(this.getHost()) : new StringBuffer("https://").append(this.getHost());
        if (this.getPort() > 0 && (this.bSSL && this.getPort() != 443 || !this.bSSL && this.getPort() != 80)) {
            stringBuffer.append(":").append(this.getPort());
        }
        if (this.getAbsolutePath() != null) {
            stringBuffer.append(this.getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String string) {
        this.absolutePath = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    void setResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    public long getThinkTime() {
        return this.thinkTime;
    }

    public void setThinkTime(long l) {
        this.thinkTime = l;
    }

    public int getPageNumber() {
        return this.nPageNum;
    }

    public void setPageNumber(int n) {
        this.nPageNum = n;
    }

    public int getConnID() {
        return this.nConnID;
    }

    public void setConnID(int n) {
        this.nConnID = n;
    }

    public int getPageOrder() {
        return this.pageOrder;
    }

    public void setPageOrder(int n) {
        this.pageOrder = n != 1 && n != 2 && n != 3 && n != 4 ? 0 : n;
    }

    public int getConnOrder() {
        return this.connOrder;
    }

    public void setConnOrder(int n) {
        this.connOrder = n != 1 && n != 2 && n != 3 ? 0 : n;
    }

    public boolean getSecure() {
        return this.bSSL;
    }

    public void setSecure(boolean bl) {
        this.bSSL = bl;
    }
}

