/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.DeserializationException;
import org.eclipse.hyades.logging.core.SerializationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlUtility {
    private static boolean isJAXPAvailable = true;
    private static final String DEFAULT_ENCODING = "UTF-8";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static String serialize(Document document) throws SerializationException {
        return XmlUtility.serialize(document, true);
    }

    public static String serialize(Document document, boolean bl) throws SerializationException {
        return XmlUtility.serialize(document, bl, DEFAULT_ENCODING);
    }

    public static String serialize(Document document, boolean bl, String string) throws SerializationException {
        try {
            return new String(XmlUtility.serializeAsByteArray(document, bl, string), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SerializationException(unsupportedEncodingException.getMessage());
        }
    }

    public static void serialize(Document document, File file) throws SerializationException {
        XmlUtility.serialize(document, file, true);
    }

    public static void serialize(Document document, File file, boolean bl) throws SerializationException {
        XmlUtility.serialize(document, file, bl, DEFAULT_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Document document, File file, boolean bl, String string) throws SerializationException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                XmlUtility.serialize(document, fileOutputStream, bl, string);
            }
            catch (Exception exception) {
                throw new SerializationException(exception.getMessage());
            }
            Object var7_5 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileOutputStream.close();
        return;
    }

    public static void serialize(Document document, OutputStream outputStream) throws SerializationException {
        XmlUtility.serialize(document, outputStream, true);
    }

    public static void serialize(Document document, OutputStream outputStream, boolean bl) throws SerializationException {
        XmlUtility.serialize(document, outputStream, bl, DEFAULT_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Document document, OutputStream outputStream, boolean bl, String string) throws SerializationException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string);
                XmlUtility.serialize(document, outputStreamWriter, bl, string);
            }
            catch (Exception exception) {
                throw new SerializationException(exception.getMessage());
            }
            Object var7_5 = null;
            if (outputStreamWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                ((Writer)outputStreamWriter).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((Writer)outputStreamWriter).close();
        return;
    }

    public static byte[] serializeAsByteArray(Document document) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, true);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, bl, DEFAULT_ENCODING);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl, String string) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtility.serialize(document, byteArrayOutputStream, bl, string);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Document document, Writer writer) throws SerializationException {
        XmlUtility.serialize(document, writer, true);
    }

    public static void serialize(Document document, Writer writer, boolean bl) throws SerializationException {
        try {
            XmlUtility.serialize(document, writer, bl, ((OutputStreamWriter)writer).getEncoding());
        }
        catch (ClassCastException classCastException) {
            XmlUtility.serialize(document, writer, bl, DEFAULT_ENCODING);
        }
    }

    public static void serialize(Document document, Writer writer, boolean bl, String string) throws SerializationException {
        if (isJAXPAvailable) {
            try {
                JAXPXMLSerializer.serialize(document, writer, bl, Charset.forName(string).name());
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isJAXPAvailable = false;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                isJAXPAvailable = false;
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                isJAXPAvailable = false;
            }
            catch (Exception exception) {
                throw new SerializationException(exception.toString());
            }
        }
        try {
            XercesXMLSerializer.serialize(document, writer, bl, Charset.forName(string).name());
        }
        catch (Exception exception) {
            throw new SerializationException(exception.toString());
        }
    }

    public static Document deserialize(String string) throws DeserializationException {
        return XmlUtility.deserialize(new InputSource(new StringReader(string)));
    }

    public static Document deserialize(File file) throws DeserializationException {
        try {
            return XmlUtility.deserialize(new InputSource(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DeserializationException(fileNotFoundException.toString());
        }
    }

    public static Document deserialize(InputStream inputStream) throws DeserializationException {
        return XmlUtility.deserialize(new InputSource(inputStream));
    }

    public static Document deserialize(InputSource inputSource) throws DeserializationException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputSource);
        }
        catch (Exception exception) {
            throw new DeserializationException(exception.toString());
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('?');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = -1;
        String string2 = null;
        int n2 = 0;
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (c == '&' && (n = string.indexOf(59, n2 + 1)) != -1) {
                string2 = string.substring(n2 + 1, n).trim();
                if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("#x9") || string2.equals("#09")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("#xA") || string2.equals("#10")) {
                    stringBuffer.append('\n');
                } else if (string2.equals("#xD") || string2.equals("#13")) {
                    stringBuffer.append('\r');
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                n2 = n;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void removeIgnorableWhitespace(Node node) {
        if (node != null) {
            Object object;
            if (node.getNodeType() == 3 && (object = node.getNodeValue()) != null && ((String)object).trim().length() == 0) {
                node.setNodeValue(((String)object).trim());
            }
            object = node.getFirstChild();
            while (object != null) {
                XmlUtility.removeIgnorableWhitespace((Node)object);
                object = object.getNextSibling();
            }
        }
    }

    static /* synthetic */ void access$200(Node node) {
        XmlUtility.removeIgnorableWhitespace(node);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class XercesXMLSerializer {
        private XercesXMLSerializer() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static void serialize(Document var0, Writer var1_1, boolean var2_2, String var3_3) throws Exception {
            block8: {
                block10: {
                    block11: {
                        block9: {
                            var4_4 = Class.forName("org.apache.xml.serialize.OutputFormat");
                            var5_5 = var4_4.newInstance();
                            var4_4.getMethod("setMethod", new Class[]{XmlUtility.class$java$lang$String == null ? (XmlUtility.class$java$lang$String = XmlUtility.class$("java.lang.String")) : XmlUtility.class$java$lang$String}).invoke(var5_5, new Object[]{"xml"});
                            var4_4.getMethod("setOmitXMLDeclaration", new Class[]{Boolean.TYPE}).invoke(var5_5, new Object[]{Boolean.TRUE});
                            var4_4.getMethod("setOmitDocumentType", new Class[]{Boolean.TYPE}).invoke(var5_5, new Object[]{Boolean.TRUE});
                            var4_4.getMethod("setLineWidth", new Class[]{Integer.TYPE}).invoke(var5_5, new Object[]{new Integer(0)});
                            var4_4.getMethod("setLineSeparator", new Class[]{XmlUtility.class$java$lang$String == null ? (XmlUtility.class$java$lang$String = XmlUtility.class$("java.lang.String")) : XmlUtility.class$java$lang$String}).invoke(var5_5, new Object[]{Constants.LINE_SEPARATOR});
                            var5_5.getClass().getMethod("setEncoding", new Class[]{XmlUtility.class$java$lang$String == null ? (XmlUtility.class$java$lang$String = XmlUtility.class$("java.lang.String")) : XmlUtility.class$java$lang$String}).invoke(var5_5, new Object[]{var3_3});
                            var1_1.write("<?xml version=\"1.0\" encoding=\"" + var3_3 + "\"?>");
                            var1_1.flush();
                            if (var2_2) {
                                var1_1.write(Constants.LINE_SEPARATOR);
                                var1_1.flush();
                            }
                            if ((var6_6 = var0.getDoctype()) == null) break block8;
                            var7_7 = var6_6.getSystemId();
                            var8_8 /* !! */  = var6_6.getInternalSubset();
                            if (var7_7 == null && var8_8 /* !! */  == null) break block8;
                            var9_9 = new StringBuffer();
                            var9_9.append("<!DOCTYPE ");
                            var9_9.append(var6_6.getName());
                            if (var7_7 == null) break block9;
                            var10_10 = var6_6.getPublicId();
                            if (var10_10 != null) {
                                var9_9.append(" PUBLIC \"");
                                var9_9.append(var10_10);
                                var9_9.append("\" \"");
                            } else {
                                var9_9.append(" SYSTEM \"");
                            }
                            var9_9.append((String)var7_7);
                            var9_9.append("\">");
                            break block10;
                        }
                        var9_9.append(" [");
                        var10_11 = new StringTokenizer(var8_8 /* !! */ .trim(), "\n\r\f");
                        if (!var2_2) ** GOTO lbl64
                        var9_9.append(Constants.LINE_SEPARATOR);
                        while (var10_11.hasMoreTokens()) {
                            var9_9.append("  ");
                            var9_9.append(var10_11.nextToken().trim());
                            var9_9.append(Constants.LINE_SEPARATOR);
                        }
                        break block11;
lbl-1000:
                        // 1 sources

                        {
                            var9_9.append(var10_11.nextToken().trim());
lbl64:
                            // 2 sources

                            ** while (var10_11.hasMoreTokens())
                        }
                    }
                    var9_9.append("]>");
                }
                if (var2_2) {
                    var9_9.append(Constants.LINE_SEPARATOR);
                }
                var1_1.write(var9_9.toString());
                var1_1.flush();
            }
            var5_5.getClass().getMethod("setIndent", new Class[]{Integer.TYPE}).invoke(var5_5, new Object[]{new Integer(var2_2 != false ? 2 : 0)});
            var7_7 = Class.forName("org.apache.xml.serialize.XMLSerializer");
            var8_8 /* !! */  = var7_7.getConstructor(new Class[]{XmlUtility.class$java$io$Writer == null ? (XmlUtility.class$java$io$Writer = XmlUtility.class$("java.io.Writer")) : XmlUtility.class$java$io$Writer, var5_5.getClass()}).newInstance(new Object[]{var1_1, var5_5});
            if (var2_2) {
                var7_7.getMethod("serialize", new Class[]{XmlUtility.class$org$w3c$dom$Document == null ? (XmlUtility.class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : XmlUtility.class$org$w3c$dom$Document}).invoke((Object)var8_8 /* !! */ , new Object[]{var0});
            } else {
                var9_9 = var0.cloneNode(true);
                XmlUtility.access$200((Node)var9_9);
                var7_7.getMethod("serialize", new Class[]{XmlUtility.class$org$w3c$dom$Document == null ? (XmlUtility.class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : XmlUtility.class$org$w3c$dom$Document}).invoke((Object)var8_8 /* !! */ , new Object[]{var9_9});
            }
        }
    }

    private static class JAXPXMLSerializer {
        private JAXPXMLSerializer() {
        }

        /*
         * Unable to fully structure code
         */
        private static void serialize(Document var0, Writer var1_1, boolean var2_2, String var3_3) throws Exception {
            block8: {
                block10: {
                    block11: {
                        block9: {
                            var4_4 = TransformerFactory.newInstance().newTransformer();
                            var4_4.setOutputProperty("method", "xml");
                            var4_4.setOutputProperty("omit-xml-declaration", "yes");
                            var4_4.setOutputProperty("encoding", var3_3);
                            var1_1.write("<?xml version=\"1.0\" encoding=\"" + var3_3 + "\"?>");
                            var1_1.flush();
                            if (var2_2) {
                                var1_1.write(Constants.LINE_SEPARATOR);
                                var1_1.flush();
                            }
                            if ((var5_5 = var0.getDoctype()) == null) break block8;
                            var6_6 = var5_5.getSystemId();
                            var7_7 = var5_5.getInternalSubset();
                            if (var6_6 == null && var7_7 == null) break block8;
                            var8_8 = new StringBuffer();
                            var8_8.append("<!DOCTYPE ");
                            var8_8.append(var5_5.getName());
                            if (var6_6 == null) break block9;
                            var9_9 = var5_5.getPublicId();
                            if (var9_9 != null) {
                                var8_8.append(" PUBLIC \"");
                                var8_8.append(var9_9);
                                var8_8.append("\" \"");
                            } else {
                                var8_8.append(" SYSTEM \"");
                            }
                            var8_8.append((String)var6_6);
                            var8_8.append("\">");
                            break block10;
                        }
                        var8_8.append(" [");
                        var9_10 = new StringTokenizer(var7_7.trim(), "\n\r\f");
                        if (!var2_2) ** GOTO lbl54
                        var8_8.append(Constants.LINE_SEPARATOR);
                        while (var9_10.hasMoreTokens()) {
                            var8_8.append("  ");
                            var8_8.append(var9_10.nextToken().trim());
                            var8_8.append(Constants.LINE_SEPARATOR);
                        }
                        break block11;
lbl-1000:
                        // 1 sources

                        {
                            var8_8.append(var9_10.nextToken().trim());
lbl54:
                            // 2 sources

                            ** while (var9_10.hasMoreTokens())
                        }
                    }
                    var8_8.append("]>");
                }
                if (var2_2) {
                    var8_8.append(Constants.LINE_SEPARATOR);
                }
                var1_1.write(var8_8.toString());
                var1_1.flush();
            }
            if (var2_2) {
                var4_4.setOutputProperty("indent", "yes");
                var4_4.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf("  ".length()));
                var4_4.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf("  ".length()));
                var4_4.transform(new DOMSource(var0), new StreamResult(var1_1));
            } else {
                var4_4.setOutputProperty("indent", "no");
                var4_4.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "0");
                var4_4.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "0");
                var6_6 = var0.cloneNode(true);
                XmlUtility.access$200((Node)var6_6);
                var4_4.transform(new DOMSource((Node)var6_6), new StreamResult(var1_1));
            }
        }
    }
}

