/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl;
import org.eclipse.hyades.models.common.configuration.impl.CFGOperationImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsFactory;
import org.eclipse.hyades.models.common.interactions.impl.BVRInteractionFragmentImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRLifelineImpl;
import org.eclipse.hyades.models.common.interactions.impl.BVRMessageImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFSUTImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestCaseImpl;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;

public class HyadesUtil {
    public static final HyadesUtil INSTANCE = new HyadesUtil();

    public void createSUTInstances(BVRInteractionImpl interaction, BVRInteractionFragmentImpl action) {
        TPFTestSuiteImpl testSuite = null;
        if (interaction == null || action == null) {
            return;
        }
        if (interaction.getBehavior().getTest() instanceof TPFTestCaseImpl) {
            testSuite = (TPFTestSuiteImpl)((TPFTestCaseImpl)interaction.getBehavior().getTest()).getOwner();
        }
        if (interaction.getBehavior().getTest() instanceof TPFTestSuiteImpl) {
            testSuite = (TPFTestSuiteImpl)interaction.getBehavior().getTest();
        }
        if (testSuite != null) {
            List systemUnderTests = testSuite.getISystemsUnderTest();
            Iterator iter2 = systemUnderTests.iterator();
            while (iter2.hasNext()) {
                TPFSUTImpl systemUnderTest = (TPFSUTImpl)iter2.next();
                List methods = systemUnderTest.getMethods();
                Iterator iter3 = methods.iterator();
                while (iter3.hasNext()) {
                    CFGOperationImpl method = (CFGOperationImpl)iter3.next();
                    if (action.getMessages().size() <= 0) continue;
                    BVRMessageImpl message = (BVRMessageImpl)action.getMessages().get(0);
                    if (!method.getName().equals(message.getOperation().getName())) continue;
                    BVRLifelineImpl sutLifeline = (BVRLifelineImpl)Common_Behavior_InteractionsFactory.eINSTANCE.createBVRLifeline();
                    sutLifeline.setDescription("self lifeline for " + systemUnderTest.getName());
                    sutLifeline.setName(systemUnderTest.getName() + "_selfLifeline");
                    interaction.getLifelines().add((Object)sutLifeline);
                    CFGInstanceImpl instance = (CFGInstanceImpl)Common_ConfigurationFactory.eINSTANCE.createCFGInstance();
                    instance.setName("instance for " + systemUnderTest.getName());
                    instance.setClassType(systemUnderTest);
                    instance.setLifeline(sutLifeline);
                    systemUnderTest.getInstances().add((Object)instance);
                }
            }
        }
    }

    public ITestSuite getTestSuite(ITest test) {
        if (test instanceof ITestCase) {
            test = ((ITestCase)test).getOwner();
        } else if (!(test instanceof ITestSuite)) {
            test = null;
        }
        return (ITestSuite)test;
    }

    public boolean containsSuite(List referencedSuites, ITestSuite test) {
        if (referencedSuites == null || test == null) {
            return false;
        }
        Iterator iter = referencedSuites.iterator();
        while (iter.hasNext()) {
            if (!((ITestSuite)iter.next()).getId().equals(test.getId())) continue;
            return true;
        }
        return false;
    }
}

