/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.core.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManager;

public interface IFileManagerExtended
extends IFileManager {
    public void deleteFile(Cookie var1, IProgressMonitor var2) throws IOException;

    public void deleteFile(FileIdentifierList var1) throws IOException;

    public void deleteFile(FileIdentifierList var1, IProgressMonitor var2) throws IOException;

    public void deleteFile(Cookie var1) throws IOException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2) throws IOException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3) throws IOException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3, IProgressMonitor var4) throws IOException;

    public void getFile(FileIdentifierList var1, FileIdentifierList var2, IProgressMonitor var3) throws IOException;

    public boolean isServerAvailable() throws IOException;

    public FileIdentifierList listContent(FileIdentifierList var1) throws IOException;

    public FileIdentifierList listContent(FileIdentifierList var1, IProgressMonitor var2) throws IOException;

    public void modifyPermission(FileIdentifierList var1, String var2) throws IOException;

    public void modifyPermission(FileIdentifierList var1, String var2, IProgressMonitor var3) throws IOException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3) throws IOException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3, Option[] var4) throws IOException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3, Option[] var4, IProgressMonitor var5) throws IOException;

    public void putFile(Cookie var1, FileIdentifierList var2, FileIdentifierList var3, IProgressMonitor var4) throws IOException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2) throws IOException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3) throws IOException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2, Option[] var3, IProgressMonitor var4) throws IOException;

    public void putFile(FileIdentifierList var1, FileIdentifierList var2, IProgressMonitor var3) throws IOException;

    public static class Option {
        public static final Option ENABLE_VERIFICATION = new Option();
        public static final Option[] NONE = new Option[0];
        public static final Option OPERATE_WITH_ATOMICITY = new Option();
        public static final Option OVERWRITE_ALL_EXISTING = new Option();
        public static final Option OVERWRITE_PARTIAL_EXISTING = new Option();
        public static final Option USE_TRANSFER_PACKAGING = new Option();

        Option() {
        }
    }

    public static class FileIdentifierList {
        private static final long serialVersionUID = 3977859592212198201L;
        private List list;

        public static FileIdentifierList create() {
            return new FileIdentifierList();
        }

        public static FileIdentifierList create(String name) {
            return new FileIdentifierList(new String[]{name});
        }

        public static FileIdentifierList create(String[] names) {
            return new FileIdentifierList(names);
        }

        private FileIdentifierList() {
            this.list = new ArrayList();
        }

        private FileIdentifierList(String[] names) {
            this.list = Arrays.asList(names);
        }

        public void add(File file) {
            this.list.add(file.getAbsolutePath());
        }

        public void add(String identifier) {
            this.list.add(identifier);
        }

        public Iterator iterator() {
            return this.list.iterator();
        }

        public int size() {
            return this.list.size();
        }

        public String[] getArray() {
            String[] identifiers = new String[this.size()];
            return this.list.toArray(identifiers);
        }

        public String toString() {
            return this.list.toString();
        }
    }

    public static class Cookie {
        public static final Cookie NONE = new Cookie();

        public static Cookie create() {
            return new Cookie();
        }

        private Cookie() {
        }
    }
}

