/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended;
import org.eclipse.hyades.internal.execution.core.file.AbstractFileTransferCommand;
import org.eclipse.hyades.internal.execution.core.file.IGetFileCommand;
import org.eclipse.hyades.internal.execution.core.file.ISocketChannel;

class GetFileCommand
extends AbstractFileTransferCommand
implements IGetFileCommand {
    static /* synthetic */ Class class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand;

    public GetFileCommand(ISocketChannel channel) {
        super(class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand == null ? (class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand = GetFileCommand.class$("org.eclipse.hyades.internal.execution.core.file.GetFileCommand")) : class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand);
        this.setState(new Server(channel));
    }

    GetFileCommand(ISocketChannel channel, IFileManagerExtended.FileIdentifierList localIdentifiers, IFileManagerExtended.FileIdentifierList remoteIdentifiers, IFileManagerExtended.Option[] options, IProgressMonitor monitor) {
        super(class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand == null ? (class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand = GetFileCommand.class$("org.eclipse.hyades.internal.execution.core.file.GetFileCommand")) : class$org$eclipse$hyades$internal$execution$core$file$GetFileCommand, IFileManagerExtended.Cookie.NONE, localIdentifiers, remoteIdentifiers, options, monitor);
        this.setState(new Client(channel));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Server
    extends AbstractFileTransferCommand.Server {
        Server(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            IFileManagerExtended.FileIdentifierList remoteIdentifiers;
            super.execute();
            int count = this.receiveInt();
            GetFileCommand.this.remoteIdentifiers = remoteIdentifiers = IFileManagerExtended.FileIdentifierList.create(this.receiveStrings());
            Iterator identifiers = remoteIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File remoteFile = new File(fileName);
                if (!remoteFile.isFile()) continue;
                this.send(remoteFile);
            }
        }
    }

    private class Client
    extends AbstractFileTransferCommand.Client {
        Client(ISocketChannel channel) {
            super(channel);
        }

        public void execute() throws IOException {
            super.execute();
            IFileManagerExtended.FileIdentifierList localIdentifiers = GetFileCommand.this.localIdentifiers;
            IFileManagerExtended.FileIdentifierList remoteIdentifiers = GetFileCommand.this.remoteIdentifiers;
            Assert.isTrue((localIdentifiers.size() == remoteIdentifiers.size() ? 1 : 0) != 0);
            this.send(remoteIdentifiers.size());
            this.send(remoteIdentifiers.getArray());
            Iterator identifiers = localIdentifiers.iterator();
            while (identifiers.hasNext()) {
                String fileName = (String)identifiers.next();
                File localFile = new File(fileName);
                boolean readyToTransfer = true;
                if (!localFile.isAbsolute()) continue;
                File localDirectory = new File(localFile.getParent());
                if (!localDirectory.exists()) {
                    readyToTransfer = localDirectory.mkdirs();
                }
                if (!readyToTransfer) continue;
                localFile.createNewFile();
                this.receive(localFile);
            }
        }
    }
}

