/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.core.file;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.eclipse.hyades.internal.execution.core.file.ISocketChannel;

class SocketChannel
implements ISocketChannel {
    private final Channel channel;
    private final ReadableByteChannel readable;
    private final WritableByteChannel writable;

    SocketChannel(java.nio.channels.SocketChannel realChannel) {
        this.channel = realChannel;
        this.readable = realChannel;
        this.writable = realChannel;
    }

    SocketChannel(Socket socket) throws IOException {
        this.channel = new ChannelInterfaceAdapter(socket);
        this.readable = Channels.newChannel(socket.getInputStream());
        this.writable = Channels.newChannel(socket.getOutputStream());
    }

    public void close() throws IOException {
        if (this.channel != null) {
            Socket socket = ((java.nio.channels.SocketChannel)this.channel).socket();
            if (socket != null) {
                socket.close();
            }
            this.channel.close();
        }
        if (this.readable != null) {
            this.readable.close();
        }
        if (this.writable != null) {
            this.writable.close();
        }
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.readable.read(buffer);
    }

    public int write(ByteBuffer buffer) throws IOException {
        return this.writable.write(buffer);
    }

    private static class ChannelInterfaceAdapter
    implements Channel {
        private final Socket socket;

        ChannelInterfaceAdapter(Socket socket) {
            this.socket = socket;
        }

        public void close() throws IOException {
            this.socket.close();
        }

        public boolean isOpen() {
            return !this.socket.isClosed();
        }
    }
}

