/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.eclipse.hyades.test.common.util.BaseString;
import org.eclipse.hyades.test.manual.runner.RemoteAppResourceBundle;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;
import org.eclipse.hyades.test.manual.runner.ui.util.SwingUtil;

class MessageDialog
extends JDialog {
    private static final Dimension DIALOG_SIZE = new Dimension(400, 250);
    private NamedElement namedElement;
    private JTextArea messageText;

    private MessageDialog(JFrame jFrame, NamedElement namedElement) {
        super(jFrame, RemoteAppResourceBundle.getString("dialog.Title"), true);
        this.setResizable(true);
        this.namedElement = namedElement;
        this.getContentPane().add(this.createControls());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                MessageDialog.this.dialogOpened();
            }

            public void windowClosing(WindowEvent windowEvent) {
                MessageDialog.this.endDialog();
            }
        });
        this.setSize(DIALOG_SIZE);
    }

    private Component createControls() {
        final JButton jButton = new JButton(RemoteAppResourceBundle.getString("dialog.Send"));
        SwingUtil.adjustMnemonic(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageDialog.this.sendMessage();
            }
        });
        jButton.setEnabled(false);
        JButton jButton2 = new JButton(RemoteAppResourceBundle.getString("dialog.Close"));
        SwingUtil.adjustMnemonic(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MessageDialog.this.endDialog();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jButton2);
        JLabel jLabel = new JLabel(RemoteAppResourceBundle.getString("dialog.Message"));
        SwingUtil.adjustMnemonic(jLabel);
        this.messageText = new JTextArea();
        this.messageText.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                if (jButton != null) {
                    jButton.setEnabled(!BaseString.toString((Object)MessageDialog.this.getMessage()).equals(""));
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.messageText, 22, 32);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "South");
        return jPanel3;
    }

    protected void sendMessage() {
        ModelUtil.getEventLogger().logMessage(this.namedElement, 0, this.getMessage());
        this.endDialog();
    }

    protected String getMessage() {
        return this.messageText.getText();
    }

    protected void dialogOpened() {
        this.messageText.requestFocus();
    }

    protected void endDialog() {
        this.dispose();
    }

    public static void show(JFrame jFrame, NamedElement namedElement) {
        MessageDialog messageDialog = new MessageDialog(jFrame, namedElement);
        messageDialog.show();
    }
}

