#!/bin/sh
#
# Platform = Linux/PPC64
#
RASERVER_HOME=..
PATH=$RASERVER_HOME/bin:$PATH
export RASERVER_HOME
export PATH

#
# Make sure RASERVER_HOME is valid
#
if [ -e $RASERVER_HOME/config/serviceconfig.xml ] ; then
	echo "Starting Agent Controller"
else
	echo "RASERVER_HOME not set properly. Pleaes edit the RAStart.sh script and update the RASERVER_HOME environment to point to the location of the Agent Controller"
	exit 1
fi

#
# Parse the configuration file for the location of the jvm library
#
JVM_LIB=`grep 'jvm=' $RASERVER_HOME/config/serviceconfig.xml | sed 's/^.*jvm=\"\(.*\)/\1/' | sed 's/\".*//'`
export JVM_LIB

#
# Set the library path(s) based on the location of the jvm library (".." is the parent directory which
# also holds other dependent *.so)
#
LD_LIBRARY_PATH=$RASERVER_HOME/lib:`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/'`:`echo $JVM_LIB | sed 's/\(.*\)\/libjvm\.so/\1/' | sed 's/\(.*\)\/.*/\1/'`:/usr/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

#
# Start the RAServer
#
RUNNING=`ps -ae | grep "RAServer" | wc -l`
if [ $RUNNING != "0" ]; then
	echo "RAServer is already running"
	exit 1
else
	RAServer
fi

#
# Wait for the process to come up in the system process list
#
sleep 2

#
# Check if RAServer is running by querying the system process list
#
ps -ae | grep "RAServer" | wc -l | awk '{
	if( $1!="0" ) {
		print "RAServer started successfully"
	}
	else {
		print "RAServer failed to start"
	}
}'
