/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RADataTransfer.h,v 1.4 2005/02/16 22:19:55 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef _RADATATRANSFER_H
#define _RADATATRANSFER_H

#include "stdio.h"
#include "RASocket.h"
#include "RAShm.h"            /* 175248 - replaced RASharedMemory.h with this */

#ifdef __cplusplus
extern "C" {
#endif

/* This library provides a more rich set of data transfer
   functions then that provided by the RASocket library.
*/

/* The various message types that are supported by this library
   are.

		  BINARY_DATA  - data that is intended to be consumed byte by byte.
	  UTF8_STRING_DATA - string data where each character is represented
					     by one byte.
   UNICODE_STRING_DATA - string data where each character is represented
						 by two bytes
*/

enum _dataFormat {RA_BINARY_DATA,
				  RA_UTF8_STRING_DATA,
				  RA_UNICODE_STRING_DATA};

typedef  enum _dataFormat dataFormat_t;

typedef dataFormat_t ra_dataFormat_t;

/* DNS Definitions to make data transfer more general ie supports different targets
       for the data transfer */

enum _dataTarget { RA_SOCKET,
                   RA_FILE,
                   RA_SHAREDMEMORY };

typedef  enum _dataTarget dataTarget_t;

typedef  struct {
   dataTarget_t dtarget;
   union {
      SOCKET          socketFD;
      FILE            fileD;
      ra_shm_handle_t *shmHdl;        /* 175248 - changed to a pointer */
   } dtargetHdl;
} ra_data_target_hdl_t;
/* DNS end */


/** ALLOCATE_MESSAGE_BLOCK  ************************************************
  * Allocates a block of memory that can be used for a message and returns
  * the address where the caller can start adding data.
  * IMPORTANT:  must use ra_freeMessageBlock to free the memory when done
  * @param  length  - the number of bytes required for the message
  * @returns        - the address where the message can be written to.  NULL if
  *                   there is no available memory.
  */
extern unsigned char *ra_allocateMessageBlock(ra_uint_t length);



/** REALLOCATE_MESSAGE_BLOCK  ************************************************
  * Recieves an existing message block and allocates a block of memory with the
  * newley specified size.  The data in the existing message block is copied
  * to the new message block.
  * IMPORTANT:  must use ra_freeMessageBlock to free the memory when done
  * @param  message - the existing message block.
  * @param  length  - the number of bytes required for the new message
  * @returns        - the address where the message can be written to.  NULL if
  *                   there is no available memory.
  */
extern unsigned char *ra_reallocateMessageBlock(unsigned char *message, ra_uint_t length);


/** FREE_MESSAGE_BLOCK  ************************************************
  * Free's a block of message memory
  * @param message - the address returned by ra_allocateMessageBlock
  */
extern void ra_freeMessageBlock(unsigned char *message);


/** WRITE_MESSAGE_BLOCK *************************************************
  * DNS - replaced socket parm with target handle struct
  * Writes a message to the specified target using the specified format.
  * @param  handle - the handle of the target to write the data to.
  * @param  format - the format to use
  * @param message - the address of the start of the message.
  * @param  length - the number of bytes to write to fd.
  * @returns       - the number of bytes written to the socket.
  */
extern ra_uint_t ra_writeMessageBlock(ra_data_target_hdl_t *handle,
                                      ra_dataFormat_t format,
                                      unsigned char *message,
                                      ra_uint_t length);

#ifdef __cplusplus
}
#endif

#endif
