/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: hcjbnd.h,v 1.9 2005/04/26 15:14:07 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#include <jni.h>
#include "RASocket.h"
#include "RADataTransfer.h"
#include "RABindings.h"
/* Header for class Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton */

#ifndef _Included_Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
#define _Included_Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
#ifdef __cplusplus
extern "C" {
#endif


typedef struct  {
	BOOL dirty;
	BOOL monitored;
	char *agent_name;
	BOOL waitingServiceAvailMessage;
	ra_data_target_hdl_t targetHdl;
	jobject agent_logger;
	RA_AGENT_HANDLE bindingStorage;
	/* A customized command handler that can be used by native agents to register their own command handler */
	ra_commandHandler_t  nativeCommandHandler;
}logAgent_t;

extern ra_string_t* logAgent_getCurrentProcessId();

/* 198066 - Thread ID's have different types on different platforms so we'll return
            a TID as defined in RAComm.h
*/
extern TID logAgent_getCurrentThreadId() ;

extern logAgent_t* logAgent_registerAgent(char *name, char *type);

extern void logAgent_deregisterAgent(logAgent_t *agent);

extern void logAgent_logMessage(logAgent_t *agent, char *messageBuffer, ra_uint_t length, ra_dataFormat_t format);
extern long logAgent_logMessage_return(logAgent_t *agent, char *messageBuffer, ra_uint_t length, ra_dataFormat_t format); /* Bug 74367 */
/* Inaccessible static: _serviceAvailable */
/* Inaccessible static: _agentCount */
/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    deregister0
 * Signature: (Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_deregister0
  (JNIEnv *, jobject, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    initializeEngine0
 * Signature: (Ljava/lang/String;Ljava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_initializeEngine0
  (JNIEnv *, jobject, jstring, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessage0
 * Signature: (Ljava/lang/String;[BII)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessage0__Ljava_lang_String_2_3BII
  (JNIEnv *, jobject, jstring, jbyteArray, jint, jint); /* Bug 74367 */

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessage0
 * Signature: (Ljava/lang/String;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessage0__Ljava_lang_String_2Ljava_lang_String_2
  (JNIEnv *, jobject, jstring, jstring); /* Bug 74367 */

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessageUTF80
 * Signature: (Ljava/lang/String;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessageUTF80
  (JNIEnv *, jobject, jstring, jstring); /* Bug 74367 */

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    logMessageUTF81
 * Signature: (Ljava/lang/String;[B)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_logMessageUTF81
  (JNIEnv *, jobject, jstring, jbyteArray); /* Bug 74367 */


/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    sendMessage0
 * Signature: (Ljava/lang/String;J)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_sendMessage0__Ljava_lang_String_2J
  (JNIEnv *, jobject, jstring, jlong); /* Bug 74367 */

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    sendMessage0
 * Signature: ([BIIJ)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_sendMessage0___3BIIJ
  (JNIEnv *, jobject, jbyteArray, jint, jint, jlong); /* Bug 74367 */

/*
 * Class:     org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    sendMessageBinary0
 * Signature: ([BIIJ)J
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_sendMessageBinary0
  (JNIEnv *, jobject, jbyteArray, jint, jint, jlong); /* Bug 74367 */

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    requestMonitorThroughPeer0
 * Signature: ([BLjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_requestMonitorThroughPeer0___3BLjava_lang_String_2
	(JNIEnv *, jobject, jbyteArray, jstring);
/* Bug 77768 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_requestMonitorThroughPeer0p___3BJLjava_lang_String_2
	(JNIEnv *, jobject, jbyteArray, jlong, jstring);

/*
 * Class:     Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:    requestMonitorThroughPeer0
 * Signature: ([BJLjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_requestMonitorThroughPeer0___3BJLjava_lang_String_2
	(JNIEnv *, jobject, jbyteArray, jlong, jstring);
/* Bug 77768 */
JNIEXPORT void JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_requestMonitorThroughPeer0p___3BJJLjava_lang_String_2
	(JNIEnv *, jobject, jbyteArray, jlong, jlong, jstring);

/*
 * Bug 79816
 * Class:		Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:		getPID0
 * Signature:
 */
JNIEXPORT jlong JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_getPID0(JNIEnv *env, jobject obj);

/*
 * Bug 79816
 * Class:		Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton
 * Method:		generateUUID0
 * Signature:
 */
JNIEXPORT jstring JNICALL Java_org_eclipse_hyades_internal_execution_remote_RemoteComponentSkeleton_generateUUID0(JNIEnv *env, jobject obj);

#ifdef __cplusplus
}
#endif
#endif
