/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RAError.h,v 1.4 2005/02/16 22:19:55 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

#ifndef _RAERROR_H_
#define _RAERROR_H_

#define INVALID_MESSAGE_LENGTH					0x0010
#define INVALID_MESSAGE_HEADER					0x0011
#define INVALID_MESSAGE_VERSION					0x0012
#define UNKNOWN_MESSAGE_TYPE					0x0013
#define INVALID_COMMAND_NUMBER					0x0014
#define INVALID_COMMAND_ID						0x0015

#define SECURITY_MODIFICATION_ERROR				0x0020


#define SOCKET_INITIALIZE_FAILED				0x0030
#define SOCKET_CREATE_FAILED					0x0031
#define SOCKET_BIND_FAILED						0x0032
#define SOCKET_LISTEN_FAILED					0x0033
#define SOCKET_ACCEPT_FAILED					0x0034
#define SOCKET_CONNECT_FAILED					0x0035
#define GETLOCALHOST_FAILED						0x0036
#define GETREMOTEHOST_FAILED					0x0037
#define GETHOSTBYNAME_FAILED					0x0038
#define UNSUPPORTED_SOCKET_TYPE					0x0039
#define SOCKET_WRITE_FAILED						0x003a

#define THREAD_CREATE_FAILED					0x0040
#define PROCESS_CREATE_FAILED					0x0041
#define HANDLE_NO_INHERIT_FAILED				0x0042


#define INSUFFICIENT_BUFFER_SIZE				0x0050
#define ELEMENT_NOT_FOUND						0x0051

#define SHM_WRITE_FAILED						0x0060    /* 194539 */

#define RA_PIPE_CREATE_FAILED					0x0070
#define RA_NOT_PIPE								0x0071
#define RA_PIPE_CONNECT_FAILED					0x0071
#define RA_PIPE_OPEN_FAILED						0x0072
#define RA_PIPE_READ_FAILED						0x0073


#define ERROR_ACCESSING_REGISTRY				0x0100

/* RAServer specific errors */
#define RASERVER_HOME_NOT_SET					0x0200
#define CONFIGURATION_FILE_NOT_EXIST			0x0201
#define LOG_FILE_OPEN_FAIL						0x0202
#define CONFIGURATION_PARSE_FAILED				0x0203
#define GSK_LIBRARY_LOAD_FAILED					0x0204
#define GSK_NOT_SUPPORTED                       0x0205
#endif
