/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.wizards.LocalLogParserLoader;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;

public class AnalyzeCorrelateOperation
implements IRunnableWithProgress {
    private String projectName;
    protected PDProjectExplorer fViewer;
    private String tcMonitor = null;
    private TRCMonitor tRCMonitor;
    private TRCAgent _agent;
    private String logFilePath = null;
    private static final String APACHE_VERSION = "V1.3.20";
    private Parser parser;
    private String name;

    public AnalyzeCorrelateOperation(Parser parser, String string) {
        this.parser = parser;
        this.name = string;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        TreeViewer treeViewer;
        XMLLoader xMLLoader;
        Node node;
        try {
            node = NodeFactory.createNode((String)"localhost");
        }
        catch (UnknownHostException unknownHostException) {
            throw new InterruptedException(unknownHostException.getMessage());
        }
        TRCProcessProxy tRCProcessProxy = null;
        IContainer iContainer = PDCoreUtil.createContainer((IPath)new Path(this.projectName));
        this.tRCMonitor = PDCoreUtil.createMonitor((IContainer)iContainer, (String)this.tcMonitor);
        TreeViewer treeViewer2 = (TreeViewer)this.fViewer.getViewer();
        this.fViewer.getViewer().refresh((Object)iContainer);
        treeViewer2.setExpandedState((Object)iContainer, true);
        String string = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
        TRCNode tRCNode = PDCoreUtil.createNode((TRCMonitor)this.tRCMonitor, (String)node.getName(), (String)string);
        treeViewer2.refresh((Object)this.tRCMonitor);
        treeViewer2.setExpandedState((Object)this.tRCMonitor, true);
        tRCProcessProxy = this.createProcess(iContainer, tRCNode);
        treeViewer2.refresh((Object)tRCNode);
        treeViewer2.setExpandedState((Object)tRCNode, true);
        this._agent = this.createAgent(iContainer, tRCProcessProxy, this.name);
        treeViewer2.refresh((Object)tRCProcessProxy);
        treeViewer2.setExpandedState((Object)tRCProcessProxy, true);
        TRCAgent tRCAgent = this._agent;
        TRCProcessProxy tRCProcessProxy2 = tRCProcessProxy;
        iProgressMonitor.worked(1);
        try {
            xMLLoader = new XMLLoader(tRCAgent);
            xMLLoader.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
            treeViewer = new Hashtable();
            treeViewer.put("file_path", this.logFilePath);
            treeViewer.put("APACHE_VERSION", APACHE_VERSION);
            LocalLogParserLoader localLogParserLoader = new LocalLogParserLoader(this.parser, treeViewer);
            localLogParserLoader.setXMLLoader(xMLLoader);
            localLogParserLoader.startParsing();
            xMLLoader.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
            try {
                xMLLoader.cleanUp();
            }
            catch (Exception exception) {}
        }
        catch (LogParserException logParserException) {
            throw new InterruptedException(logParserException.getMessage());
        }
        iProgressMonitor.worked(1);
        xMLLoader = UIPlugin.getDefault().getPreferenceStore();
        xMLLoader.setValue("show_monitor", true);
        xMLLoader.setValue("show_node", true);
        treeViewer = (TreeViewer)this.fViewer.getViewer();
        this.fViewer.updateActionBars();
        treeViewer.setExpandedState((Object)tRCProcessProxy2, true);
        this.fViewer.selectObject((Object)tRCAgent.getAgentProxy());
        iProgressMonitor.done();
    }

    public void dispose() {
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public PDProjectExplorer getFViewer() {
        return this.fViewer;
    }

    public void setFViewer(PDProjectExplorer pDProjectExplorer) {
        this.fViewer = pDProjectExplorer;
    }

    private TRCProcessProxy createProcess(IContainer iContainer, TRCNode tRCNode) {
        int n = 0;
        String string = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("file_path", this.logFilePath);
        hashtable.put("APACHE_VERSION", APACHE_VERSION);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("file_path");
        arrayList.add("APACHE_VERSION");
        Iterator iterator = ((AbstractList)arrayList).iterator();
        if (iterator.hasNext()) {
            string = string + hashtable.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            string = string + " " + hashtable.get(iterator.next()).toString();
        }
        TRCProcessProxy tRCProcessProxy = null;
        EList eList = tRCNode.getProcessProxies();
        Iterator iterator2 = eList.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            tRCProcessProxy = (TRCProcessProxy)iterator2.next();
            ++n2;
            if (tRCProcessProxy.getName() == null || !tRCProcessProxy.getName().equals(string)) continue;
            return tRCProcessProxy;
        }
        TRCMonitor tRCMonitor = tRCNode.getMonitor();
        String string2 = new Date().toString();
        string2 = HyadesUtil.change((String)string2, (String)" ", (String)"");
        string2 = HyadesUtil.change((String)string2, (String)":", (String)"");
        String string3 = tRCNode.getMonitor().getName() + "_" + tRCNode.getName() + "_" + n2 + "_" + n;
        String string4 = string3 + "." + "trcpxmi";
        IPath iPath = iContainer.getFullPath().append(string4);
        URI uRI = URI.createURI((String)("platform:/resource" + iPath.toString()));
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        resource.setModified(true);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCProcessProxy = hierarchyFactory.createTRCProcessProxy();
        tRCProcessProxy.setPid(n);
        tRCProcessProxy.setRuntimeId(String.valueOf(n));
        tRCProcessProxy.setName(string);
        tRCProcessProxy.setLaunchMode(0);
        tRCProcessProxy.setNode(tRCNode);
        eList2.add(tRCProcessProxy);
        ProfileEvent profileEvent = UIPlugin.getDefault().getProfileEvent();
        profileEvent.setSource((Object)tRCProcessProxy);
        profileEvent.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(profileEvent);
        return tRCProcessProxy;
    }

    private TRCAgent createAgent(IContainer iContainer, TRCProcessProxy tRCProcessProxy, String string) {
        String string2;
        TRCAgentProxy tRCAgentProxy = null;
        String string3 = "Logging";
        EList eList = tRCProcessProxy.getAgentProxies();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            tRCAgentProxy = (TRCAgentProxy)iterator.next();
            if (!tRCAgentProxy.getName().equals(string)) continue;
            tRCAgentProxy.getAgent().getDefaultEvents().clear();
            return tRCAgentProxy.getAgent();
        }
        String string4 = string2 = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        string4 = HyadesUtil.change((String)string4, (String)" ", (String)"");
        string4 = HyadesUtil.change((String)string4, (String)":", (String)"");
        String string5 = tRCProcessProxy.getNode().getMonitor().getName() + "_" + tRCProcessProxy.getNode().getName() + "_" + tRCProcessProxy.getPid() + "_" + string4 + "_" + string;
        string5 = HyadesUtil.change((String)string5, (String)" ", (String)"");
        String string6 = tRCProcessProxy.eResource().getURI().toString();
        Path path = new Path(string6);
        if (path.segmentCount() > 1) {
            string6 = path.removeLastSegments(1).toString();
        }
        String string7 = string5 + "." + "trcaxmi";
        IPath iPath = new Path(string6).append(string7);
        URI uRI = URI.createURI((String)iPath.toString());
        Resource resource = Resource.Factory.Registry.INSTANCE.getFactory(uRI).createResource(uRI);
        resource.setModified(true);
        EList eList2 = resource.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add(resource);
        HierarchyFactory hierarchyFactory = UIPlugin.getDefault().getPerftraceFactory();
        tRCAgentProxy = hierarchyFactory.createTRCAgentProxy();
        tRCAgentProxy.setName(string);
        tRCAgentProxy.setType(string3);
        tRCAgentProxy.setProcessProxy(tRCProcessProxy);
        tRCProcessProxy.getAgentProxies().add(tRCAgentProxy);
        TRCAgent tRCAgent = hierarchyFactory.createTRCAgent();
        tRCAgent.setAgentProxy(tRCAgentProxy);
        tRCAgent.setType(string3);
        eList2.add(tRCAgent);
        return tRCAgent;
    }

    public TRCMonitor getTRCMonitor() {
        return this.tRCMonitor;
    }

    public String getTcMonitor() {
        return this.tcMonitor;
    }

    public void setTcMonitor(String string) {
        this.tcMonitor = string;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String string) {
        this.logFilePath = string;
    }

    public TRCAgent getAgent() {
        return this._agent;
    }

    public void setAgent(TRCAgent tRCAgent) {
        this._agent = tRCAgent;
    }
}

