/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.io.File;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.sample.HyadesSamplePlugin;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class LogAnalyzerSamplePage
extends CreationWizardPage
implements Listener {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private boolean useDefaults = true;
    private boolean useDBDefaults = true;
    private boolean useErrorLogDefaults = true;
    private boolean analyzeLog = true;
    private boolean correlateLog = true;
    protected Text logfileFieldText;
    protected Text symptomDBFieldText;
    protected Text errorLogFieldText;
    protected String initialLogFileValue;
    protected String initialSymptomDBValue;
    protected String initialErrorLogValue;
    private Label symptomDBLocationLabel;
    private Label errorLogLocationLabel;
    private Label logfileLocationLabel;
    private Button browseButton;
    private Button symptomDBBrowseButton;
    private Button errorLogBrowseButton;
    private LogAnalyzerCreationPage firstPage;
    private Button analyzeLogButton;
    private Button correlateLogButton;
    private static final String APACHE_DEFAULT_LOG_FILE = "access.log";
    private static final String APACHE_DEFAULT_ERROR_LOG_FILE = "error.log";
    private static final String APACHE_DEFAULT_SYMPTOMDB_FILE = "symptomdb.trcdbxmi";
    private String customLocationFieldValue = "";
    private String customSymptomDBLocationFieldValue = "";
    private String customErrorLogLocationFieldValue = "";
    private Text sdbFileNameText;
    private Label importSDBFileLabel;
    private Listener logfileModifyListener = new Listener(){

        public void handleEvent(Event event) {
            LogAnalyzerSamplePage.this.setPageComplete(LogAnalyzerSamplePage.this.validatePage());
        }
    };
    private Listener errorLogModifyListener = new Listener(){

        public void handleEvent(Event event) {
            LogAnalyzerSamplePage.this.setPageComplete(LogAnalyzerSamplePage.this.validatePage());
        }
    };
    private Listener symptomDBModifyListener = new Listener(){

        public void handleEvent(Event event) {
            LogAnalyzerSamplePage.this.setPageComplete(LogAnalyzerSamplePage.this.validatePage());
        }
    };

    public String getErrorLogPath() {
        return this.errorLogFieldText.getText().trim();
    }

    public String getLogPath() {
        return this.logfileFieldText.getText().trim();
    }

    public String getSymptomDBFilePath() {
        if (this.useDBDefaults) {
            return this.symptomDBFieldText.getText().trim();
        }
        return "/" + this.getProjectName() + "/" + this.sdbFileNameText.getText().trim();
    }

    public LogAnalyzerSamplePage(CreationWizard creationWizard, String string, IConfigurationElement iConfigurationElement, LogAnalyzerCreationPage logAnalyzerCreationPage) {
        super(creationWizard, string, iConfigurationElement);
        this.initialLogFileValue = this.getValue(iConfigurationElement, "name");
        this.initialSymptomDBValue = this.getValue(iConfigurationElement, "name");
        this.initialErrorLogValue = this.getValue(iConfigurationElement, "name");
        this.setInitialSymptomDB(this.initialSymptomDBValue);
        this.setInitialErrorLog(this.initialErrorLogValue);
        this.setInitialLogFile(this.initialLogFileValue);
        this.firstPage = logAnalyzerCreationPage;
    }

    public void handleEvent(Event event) {
        this.setLogFileForSelection();
        this.setSymptomDBForSelection();
        this.setErrorLogForSelection();
    }

    private void setLogFileForSelection() {
        if (this.useDefaults) {
            this.logfileFieldText.setText(this.getDefaultLogFileForName(this.getProjectFieldValue()));
        }
    }

    private void setSymptomDBForSelection() {
        if (this.useDBDefaults) {
            this.symptomDBFieldText.setText(this.getDefaultSymptomDBForName(this.getProjectFieldValue()));
        }
    }

    private void setErrorLogForSelection() {
        if (this.useErrorLogDefaults) {
            this.errorLogFieldText.setText(this.getDefaultErrorLogForName(this.getProjectFieldValue()));
        }
    }

    private String getProjectFieldValue() {
        if (this.firstPage == null) {
            return "";
        }
        String string = this.firstPage.getProjectName();
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        this.initializeDialogUnits((Control)composite);
        WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createLogFileControls(composite2);
        this.createErrorLogControls(composite2);
        this.createSymptomDBControls(composite2);
        this.createLogFileOptions(composite2);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        this.firstPage.getProjectText().addListener(24, (Listener)this);
    }

    private final void createLogFileOptions(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText(HyadesSamplePlugin.getString("OPTIONS"));
        this.analyzeLogButton = new Button((Composite)group, 131104);
        this.analyzeLogButton.setText(HyadesSamplePlugin.getString("ANALYZE_LOG_LABEL"));
        this.analyzeLogButton.setSelection(true);
        this.analyzeLogButton.setFont(font);
        this.correlateLogButton = new Button((Composite)group, 131104);
        this.correlateLogButton.setText(HyadesSamplePlugin.getString("CORRELATE_LOG_LABEL"));
        this.correlateLogButton.setSelection(true);
        this.correlateLogButton.setFont(font);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.analyzeLogButton.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.correlateLogButton.setLayoutData((Object)gridData);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.analyzeLog = LogAnalyzerSamplePage.this.analyzeLogButton.getSelection();
            }
        };
        this.analyzeLogButton.addSelectionListener((SelectionListener)selectionAdapter);
        SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.correlateLog = LogAnalyzerSamplePage.this.correlateLogButton.getSelection();
            }
        };
        this.correlateLogButton.addSelectionListener((SelectionListener)selectionAdapter2);
    }

    private final void createLogFileControls(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText(HyadesSamplePlugin.getString("LOG_FILE_LABEL"));
        final Button button = new Button((Composite)group, 131104);
        button.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        button.setSelection(this.useDefaults);
        button.setFont(font);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        this.createUserSpecifiedProjectLocationGroup((Composite)group, !this.useDefaults);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.useDefaults = button.getSelection();
                LogAnalyzerSamplePage.this.browseButton.setEnabled(!LogAnalyzerSamplePage.this.useDefaults);
                LogAnalyzerSamplePage.this.logfileFieldText.setEnabled(!LogAnalyzerSamplePage.this.useDefaults);
                LogAnalyzerSamplePage.this.logfileLocationLabel.setEnabled(!LogAnalyzerSamplePage.this.useDefaults);
                if (LogAnalyzerSamplePage.this.useDefaults) {
                    LogAnalyzerSamplePage.this.customLocationFieldValue = LogAnalyzerSamplePage.this.logfileFieldText.getText();
                    LogAnalyzerSamplePage.this.setLogFileForSelection();
                } else {
                    LogAnalyzerSamplePage.this.logfileFieldText.setText(LogAnalyzerSamplePage.this.customLocationFieldValue);
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private final void createErrorLogControls(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText(HyadesSamplePlugin.getString("ERRORLOG_FILE_LABEL"));
        final Button button = new Button((Composite)group, 131104);
        button.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        button.setSelection(this.useErrorLogDefaults);
        button.setFont(font);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        this.createUserSpecifiedErrorLogLocationGroup((Composite)group, !this.useDefaults);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.useErrorLogDefaults = button.getSelection();
                LogAnalyzerSamplePage.this.errorLogBrowseButton.setEnabled(!LogAnalyzerSamplePage.this.useErrorLogDefaults);
                LogAnalyzerSamplePage.this.errorLogFieldText.setEnabled(!LogAnalyzerSamplePage.this.useErrorLogDefaults);
                LogAnalyzerSamplePage.this.errorLogLocationLabel.setEnabled(!LogAnalyzerSamplePage.this.useErrorLogDefaults);
                if (LogAnalyzerSamplePage.this.useErrorLogDefaults) {
                    LogAnalyzerSamplePage.this.customErrorLogLocationFieldValue = LogAnalyzerSamplePage.this.errorLogFieldText.getText();
                    LogAnalyzerSamplePage.this.setErrorLogForSelection();
                } else {
                    LogAnalyzerSamplePage.this.errorLogFieldText.setText(LogAnalyzerSamplePage.this.customErrorLogLocationFieldValue);
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private final void createSymptomDBControls(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(font);
        group.setText(HyadesSamplePlugin.getString("SYMPTOMDB_FILE_LABEL"));
        final Button button = new Button((Composite)group, 131104);
        button.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.useDefaultLabel"));
        button.setSelection(this.useDBDefaults);
        button.setFont(font);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        this.importSDBFileLabel = new Label((Composite)group, 0);
        this.importSDBFileLabel.setText(HyadesSamplePlugin.getString("IMPORT_SYMPTOM_DB"));
        this.importSDBFileLabel.setFont(font);
        this.importSDBFileLabel.setLayoutData((Object)gridData2);
        if (this.useDefaults) {
            this.importSDBFileLabel.setVisible(false);
        }
        this.createUserSpecifiedSymptomDBLocationGroup((Composite)group, !this.useDefaults);
        this.createSDBFileNameControls(composite);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.useDBDefaults = button.getSelection();
                LogAnalyzerSamplePage.this.symptomDBBrowseButton.setEnabled(!LogAnalyzerSamplePage.this.useDBDefaults);
                LogAnalyzerSamplePage.this.symptomDBFieldText.setEnabled(!LogAnalyzerSamplePage.this.useDBDefaults);
                LogAnalyzerSamplePage.this.symptomDBLocationLabel.setEnabled(!LogAnalyzerSamplePage.this.useDBDefaults);
                LogAnalyzerSamplePage.this.importSDBFileLabel.setVisible(!LogAnalyzerSamplePage.this.useDBDefaults);
                if (LogAnalyzerSamplePage.this.useDBDefaults) {
                    LogAnalyzerSamplePage.this.customSymptomDBLocationFieldValue = LogAnalyzerSamplePage.this.symptomDBFieldText.getText();
                    LogAnalyzerSamplePage.this.setSymptomDBForSelection();
                } else {
                    LogAnalyzerSamplePage.this.symptomDBFieldText.setText(LogAnalyzerSamplePage.this.customSymptomDBLocationFieldValue);
                }
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite composite, boolean bl) {
        Font font = composite.getFont();
        this.logfileLocationLabel = new Label(composite, 0);
        this.logfileLocationLabel.setText(HyadesSamplePlugin.getString("LOG_FILE_TEXT_LABEL"));
        this.logfileLocationLabel.setEnabled(bl);
        this.logfileLocationLabel.setFont(font);
        this.logfileFieldText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.logfileFieldText.setLayoutData((Object)gridData);
        this.logfileFieldText.setEnabled(bl);
        this.logfileFieldText.setFont(font);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(bl);
        this.browseButton.setFont(font);
        this.setButtonLayoutData(this.browseButton);
        if (this.initialLogFileValue == null) {
            this.logfileFieldText.setText(Platform.getLocation().toOSString());
        } else {
            this.logfileFieldText.setText(this.initialLogFileValue);
        }
        this.logfileFieldText.addListener(24, this.logfileModifyListener);
    }

    private void createUserSpecifiedSymptomDBLocationGroup(Composite composite, boolean bl) {
        Font font = composite.getFont();
        this.symptomDBLocationLabel = new Label(composite, 0);
        this.symptomDBLocationLabel.setText(HyadesSamplePlugin.getString("LOG_FILE_TEXT_LABEL"));
        this.symptomDBLocationLabel.setEnabled(bl);
        this.symptomDBLocationLabel.setFont(font);
        this.symptomDBFieldText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.symptomDBFieldText.setLayoutData((Object)gridData);
        this.symptomDBFieldText.setEnabled(bl);
        this.symptomDBFieldText.setFont(font);
        this.symptomDBBrowseButton = new Button(composite, 8);
        this.symptomDBBrowseButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.symptomDBBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.handleSymptomDBLocationBrowseButtonPressed();
            }
        });
        this.symptomDBBrowseButton.setEnabled(bl);
        this.symptomDBBrowseButton.setFont(font);
        this.setButtonLayoutData(this.symptomDBBrowseButton);
        if (this.initialSymptomDBValue == null) {
            this.symptomDBFieldText.setText(Platform.getLocation().toOSString());
        } else {
            this.symptomDBFieldText.setText(this.initialSymptomDBValue);
        }
        this.symptomDBFieldText.addListener(24, this.logfileModifyListener);
    }

    private final void createSDBFileNameControls(Composite composite) {
        this.sdbFileNameText = new Text(composite, 2048);
        int n = this.initialSymptomDBValue.lastIndexOf("/") + 1;
        this.sdbFileNameText.setText(this.initialSymptomDBValue.substring(n, this.initialSymptomDBValue.length()));
        this.sdbFileNameText.setVisible(false);
    }

    private void createUserSpecifiedErrorLogLocationGroup(Composite composite, boolean bl) {
        Font font = composite.getFont();
        this.errorLogLocationLabel = new Label(composite, 0);
        this.errorLogLocationLabel.setText(HyadesSamplePlugin.getString("LOG_FILE_TEXT_LABEL"));
        this.errorLogLocationLabel.setEnabled(bl);
        this.errorLogLocationLabel.setFont(font);
        this.errorLogFieldText = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.errorLogFieldText.setLayoutData((Object)gridData);
        this.errorLogFieldText.setEnabled(bl);
        this.errorLogFieldText.setFont(font);
        this.errorLogBrowseButton = new Button(composite, 8);
        this.errorLogBrowseButton.setText(WorkbenchMessages.getString((String)"WizardNewProjectCreationPage.browseLabel"));
        this.errorLogBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LogAnalyzerSamplePage.this.handleErrorLogLocationBrowseButtonPressed();
            }
        });
        this.errorLogBrowseButton.setEnabled(bl);
        this.errorLogBrowseButton.setFont(font);
        this.setButtonLayoutData(this.errorLogBrowseButton);
        if (this.initialErrorLogValue == null) {
            this.errorLogFieldText.setText(Platform.getLocation().toOSString());
        } else {
            this.errorLogFieldText.setText(this.initialErrorLogValue);
        }
        this.errorLogFieldText.addListener(24, this.logfileModifyListener);
    }

    private void handleLocationBrowseButtonPressed() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.logfileFieldText.getShell());
        fileDialog.setFileName(this.logfileFieldText.getText());
        String string = this.getProjectFieldValue();
        if (!string.equals("") && ((File)(object = new File(string))).exists()) {
            fileDialog.setFilterPath(new Path(string).toOSString());
        }
        if ((object = fileDialog.open()) != null) {
            this.customLocationFieldValue = object;
            this.logfileFieldText.setText(this.customLocationFieldValue);
        }
    }

    private void handleErrorLogLocationBrowseButtonPressed() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.errorLogFieldText.getShell());
        fileDialog.setFileName(this.errorLogFieldText.getText());
        String string = this.getProjectFieldValue();
        if (!string.equals("") && ((File)(object = new File(string))).exists()) {
            fileDialog.setFilterPath(new Path(string).toOSString());
        }
        if ((object = fileDialog.open()) != null) {
            this.customErrorLogLocationFieldValue = object;
            this.errorLogFieldText.setText(this.customErrorLogLocationFieldValue);
        }
    }

    private void handleSymptomDBLocationBrowseButtonPressed() {
        Object object;
        FileDialog fileDialog = new FileDialog(this.symptomDBFieldText.getShell());
        fileDialog.setFileName(this.symptomDBFieldText.getText());
        String string = this.getProjectFieldValue();
        if (!string.equals("") && ((File)(object = new File(string))).exists()) {
            fileDialog.setFilterPath(new Path(string).toOSString());
        }
        if ((object = fileDialog.open()) != null) {
            this.customSymptomDBLocationFieldValue = object;
            this.symptomDBFieldText.setText(this.customSymptomDBLocationFieldValue);
        }
    }

    public void setInitialLogFile(String string) {
        if (string == null) {
            this.initialLogFileValue = null;
        } else {
            this.initialLogFileValue = string.trim();
            this.initialLogFileValue = this.getDefaultLogFileForName(this.initialLogFileValue);
        }
    }

    public void setAccessLog(String string) {
        String string2 = string + File.separator + APACHE_DEFAULT_LOG_FILE;
        if (this.logfileFieldText != null) {
            this.logfileFieldText.setText(new Path(string2).toString());
        }
    }

    public void setInitialErrorLog(String string) {
        if (string == null) {
            this.initialErrorLogValue = null;
        } else {
            this.initialErrorLogValue = string.trim();
            this.initialErrorLogValue = this.getDefaultErrorLogForName(this.initialErrorLogValue);
        }
    }

    public void setErrorLog(String string) {
        String string2 = string + File.separator + APACHE_DEFAULT_ERROR_LOG_FILE;
        if (this.errorLogFieldText != null) {
            this.errorLogFieldText.setText(new Path(string2).toString());
        }
    }

    public void setInitialSymptomDB(String string) {
        if (string == null) {
            this.initialSymptomDBValue = null;
        } else {
            this.initialSymptomDBValue = string.trim();
            this.initialSymptomDBValue = this.getDefaultSymptomDBForName(this.initialSymptomDBValue);
        }
    }

    private String getDefaultLogFileForName(String string) {
        IPath iPath = Platform.getLocation().append(string);
        return iPath.toOSString() + File.separator + APACHE_DEFAULT_LOG_FILE;
    }

    private String getDefaultSymptomDBForName(String string) {
        IPath iPath = Platform.getLocation().append(string);
        String string2 = this.getProjectFieldValue();
        if (string2.equals("")) {
            string2 = string;
        }
        return "/" + string2 + "/" + APACHE_DEFAULT_SYMPTOMDB_FILE;
    }

    private String getDefaultErrorLogForName(String string) {
        IPath iPath = Platform.getLocation().append(string);
        return iPath.toOSString() + File.separator + APACHE_DEFAULT_ERROR_LOG_FILE;
    }

    public void setVisible(boolean bl) {
        this.getControl().setVisible(bl);
    }

    private String getValue(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    protected boolean validatePage() {
        File file;
        Object object;
        String string = this.logfileFieldText.getText().trim();
        if (string.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(HyadesSamplePlugin.getString("_ERROR_LOG_FILE_IS_EMPTY"));
            return false;
        }
        if (!this.useDefaults && !((File)(object = new File(string))).isFile()) {
            this.setErrorMessage(HyadesSamplePlugin.getString("_ERROR_LOG_FILE_IS_INVALID"));
            return false;
        }
        object = this.symptomDBFieldText.getText().trim();
        if (this.symptomDBFieldText.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(HyadesSamplePlugin.getString("_ERROR_SYMPTOMDB_IS_EMPTY"));
            return false;
        }
        if (!this.useDBDefaults) {
            if (((String)object).length() == 0) {
                this.setErrorMessage(null);
                this.setMessage(HyadesSamplePlugin.getString("_ERROR_SYMPTOMDB_IS_EMPTY"));
                return false;
            }
            if (!((String)object).endsWith("xml")) {
                this.setErrorMessage(null);
                this.setMessage(HyadesSamplePlugin.getString("_ERROR_ERRORSDB_FILE_IS_INVALID"));
                return false;
            }
        }
        String string2 = this.errorLogFieldText.getText().trim();
        if (this.errorLogFieldText.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(HyadesSamplePlugin.getString("_ERROR_ERRORLOG_FILE_IS_EMPTY"));
            return false;
        }
        if (!this.useErrorLogDefaults && !(file = new File(string2)).isFile()) {
            this.setErrorMessage(HyadesSamplePlugin.getString("_ERROR_ERRORLOG_FILE_IS_INVALID"));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public Button getAnalyzeLogButton() {
        return this.analyzeLogButton;
    }

    public Button getCorrelateLogButton() {
        return this.correlateLogButton;
    }

    public String getProjectName() {
        return this.firstPage.getProjectName();
    }

    public String getInitialProjectName() {
        return this.firstPage.getProjectName();
    }

    public String getSDBFileName() {
        if (this.useDBDefaults) {
            return "";
        }
        return this.symptomDBFieldText.getText().trim();
    }
}

