/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.internal.util.CorrelationHelper;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.sd.logc.SDLogcPlugin;
import org.eclipse.hyades.sd.logc.internal.loader.LogInteractions;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class CorrelateLogAction
implements IRunnableWithProgress {
    private final String corrName = LogCorrelatorPlugin.getResourceString((String)"CORR_NAME");
    private EObject mofObject;

    public EObject getMofObject() {
        return this.mofObject;
    }

    public void setMofObject(EObject eobject) {
        this.mofObject = eobject;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.worked(1);
        this.run();
        monitor.done();
    }

    public void run() {
        if (this.mofObject != null && this.mofObject instanceof EObject) {
            IWorkbenchPage persp = UIPlugin.getActivePage();
            try {
                IConfigurationElement timeBased = CorrelationHelper.getInstance().getCorrelationByName(this.corrName);
                if (timeBased != null) {
                    CorrelationContainerProxy proxy = CorrelationHelper.getInstance().createCorrelationContainer(timeBased, (Object)this.mofObject, this.corrName);
                    Navigator nav = (Navigator)HyadesUtil.getActiveNavigator();
                    nav.selectReveal((ISelection)new StructuredSelection((Object)proxy));
                    SDView view = (SDView)persp.showView("org.eclipse.hyades.sd.logc.LogInteractionsView");
                    LoadersManager.getLoadersManager().createLoader("org.eclipse.hyades.sd.logc.internal.loader.LogInteractions", this.getClass().getClassLoader(), view);
                    ((LogInteractions)LoadersManager.getLoadersManager().getCurrentLoader("org.eclipse.hyades.sd.logc.LogInteractionsView")).generateLogInteractions((EObject)proxy, false);
                }
            }
            catch (Exception e) {
                String msg = SDLogcPlugin.getResourceString((String)"STR_LOAD_SD_ERR_");
                Status err = new Status(2, "org.eclipse.core.resources", 566, e.toString(), null);
                IWorkbenchWindow window = SDLogcPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                ErrorDialog.openError((Shell)window.getShell(), (String)msg, (String)"", (IStatus)err);
                e.printStackTrace();
            }
        }
        this.mofObject = null;
    }

    public void dispose() {
    }
}

