/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IProcessConsole;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutionComponentStub;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;

public abstract class ExecutorStub
extends ExecutionComponentStub
implements IExecutor {
    private String executionResultLocation = null;
    private String executionResultName = null;
    private String communicationPort = null;
    public IDataProcessor[] dataProcessors = null;
    protected int agentInitCount;
    static /* synthetic */ Class class$org$eclipse$hyades$execution$core$IExecutableObject;

    public ExecutorStub() {
    }

    public ExecutorStub(IExecutionComponent iExecutionComponent) {
        super(iExecutionComponent);
    }

    public void launch() throws ExecutionComponentStateException {
        ReturnData returnData = this.delegateRemoteCall(new Class[0], new Object[0], "launch");
        Object object = returnData.getReturnValue();
        if (returnData.isError()) {
            throw new RemoteInvocationException((Throwable)object);
        }
    }

    public void kill() throws ExecutionComponentStateException {
        ReturnData returnData = this.delegateRemoteCall(new Class[0], new Object[0], "kill");
        Object object = returnData.getReturnValue();
        if (returnData.isError()) {
            throw new RemoteInvocationException((Throwable)object);
        }
    }

    public void setExecutableObject(IExecutableObject iExecutableObject) throws ExecutionComponentStateException {
        ((IExecutor)this.delegate).setExecutableObject(iExecutableObject);
        ReturnData returnData = this.delegateRemoteCall(new Class[]{class$org$eclipse$hyades$execution$core$IExecutableObject == null ? (class$org$eclipse$hyades$execution$core$IExecutableObject = ExecutorStub.class$("org.eclipse.hyades.execution.core.IExecutableObject")) : class$org$eclipse$hyades$execution$core$IExecutableObject}, new Object[]{iExecutableObject}, "setExecutableObject");
        Object object = returnData.getReturnValue();
        if (returnData.isError()) {
            throw new RemoteInvocationException((Throwable)object);
        }
        iExecutableObject.setExecutor((IExecutor)this);
    }

    public IExecutableObject getExecutableObject() {
        return ((IExecutor)this.delegate).getExecutableObject();
    }

    public IProcessConsole getProcessConsole() throws ExecutionComponentStateException {
        return null;
    }

    public IExecutableObject getCompatibleExecutableObject(String string) throws ClassNotFoundException {
        ExecutionComponentFactoryImpl executionComponentFactoryImpl = (ExecutionComponentFactoryImpl)ExecutionComponentFactoryImpl.getInstance(this.getSessionContext());
        IRemoteObject iRemoteObject = executionComponentFactoryImpl.createRemoteObjectByType(string);
        if (!(iRemoteObject instanceof IExecutableObject)) {
            throw new ClassCastException("Component factory returned an incorrect type; expected an IExecutableObject");
        }
        return (IExecutableObject)iRemoteObject;
    }

    public String getExecutionResultLocation() {
        return this.executionResultLocation;
    }

    public String getExecutionResultName() {
        return this.executionResultName;
    }

    public void setExecutionResultLocation(String string) {
        this.executionResultLocation = string;
    }

    public void setExecutionResultName(String string) {
        this.executionResultName = string;
    }

    public IDataProcessor[] getDataProcessors() {
        return this.dataProcessors;
    }

    public void setDataProcessors(IDataProcessor[] iDataProcessorArray) {
        this.dataProcessors = iDataProcessorArray;
    }

    public String getPid() {
        ReturnData returnData = this.delegateRemoteCall(new Class[0], new Object[0], "getPid");
        Object object = returnData.getReturnValue();
        if (returnData.isError()) {
            throw new RemoteInvocationException((Throwable)object);
        }
        return (String)object;
    }

    protected Process findProcess(String string, Node node) throws NotConnectedException, InactiveProcessException {
        Object var3_3 = null;
        Enumeration enumeration = node.listProcesses();
        while (enumeration.hasMoreElements()) {
            Process process = (Process)enumeration.nextElement();
            if (!process.getProcessId().equals(string)) continue;
            return process;
        }
        return null;
    }

    protected Agent findAgent(Process process, String string, String string2) {
        Enumeration enumeration = process.getAgentsByType(string);
        while (enumeration.hasMoreElements()) {
            Agent agent = (Agent)enumeration.nextElement();
            if (agent.getName().indexOf(string2) == -1) continue;
            return agent;
        }
        return null;
    }

    protected void setupControlListener(AgentListener agentListener, Agent agent) throws InactiveAgentException, InactiveProcessException, UnsupportedEncodingException {
        String string;
        agent.addAgentListener(agentListener);
        agent.attach();
        String string2 = agent.getName();
        IExecutionComponent[] iExecutionComponentArray = this.getChildren();
        ++this.agentInitCount;
        ((JavaTaskRemoteHyadesComponentStub)iExecutionComponentArray[this.agentInitCount - 1]).setAgent(agent);
        IExecutableObject iExecutableObject = this.getExecutableObject();
        if (iExecutableObject instanceof JavaProcessExecutableObjectStub && (string = ((JavaProcessExecutableObjectStub)iExecutableObject).getAgentData()) != null) {
            BinaryCustomCommand binaryCustomCommand = new BinaryCustomCommand();
            binaryCustomCommand.setData(string.getBytes("UTF-8"));
            agent.invokeCustomCommand(binaryCustomCommand);
        }
    }

    protected void resetAgentInitCount() {
        this.agentInitCount = 0;
    }

    public String getCommunicationPort() {
        return this.communicationPort;
    }

    public void setCommunicationPort(String string) {
        this.communicationPort = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

