/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeImpl;
import org.eclipse.hyades.internal.execution.security.DuplicateUserException;
import org.eclipse.hyades.internal.execution.security.User;

public class NodeFactory {
    private static final int INITIAL_SERVERS = 16;
    private static Node[] _servers = new Node[16];

    public static Node createNode(String string) throws UnknownHostException {
        try {
            return NodeFactory.createNode(string, null);
        }
        catch (DuplicateUserException duplicateUserException) {
            return NodeFactory.containsNode(string, null);
        }
    }

    public static Node createNode(String string, Principal principal) throws UnknownHostException, DuplicateUserException {
        Node node = NodeFactory.containsNode(string, principal);
        if (node == null) {
            InetAddress inetAddress = InetAddress.getByName(string);
            return NodeFactory.addNode(string, inetAddress, principal);
        }
        throw new DuplicateUserException();
    }

    public static Node createNode(InetAddress inetAddress) throws UnknownHostException {
        return NodeFactory.createNode(inetAddress, null);
    }

    public static Node createNode(InetAddress inetAddress, Principal principal) throws UnknownHostException {
        String string = inetAddress.getHostName();
        Node node = NodeFactory.containsNode(string, principal);
        if (node == null) {
            node = NodeFactory.addNode(string, inetAddress, principal);
        }
        return node;
    }

    public static Node getLocalHost() throws UnknownHostException {
        if (_servers[0] == null) {
            throw new UnknownHostException();
        }
        return _servers[0];
    }

    public static Node getLocalHost(Principal principal) throws UnknownHostException {
        if (_servers[0] == null) {
            throw new UnknownHostException();
        }
        String string = _servers[0].getName();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node addNode(String string, InetAddress object, Principal principal) {
        Object[] objectArray;
        if (string.equals("localhost")) {
            try {
                string = InetAddress.getLocalHost().getHostName();
                objectArray = InetAddress.getAllByName(string);
                object = objectArray[0];
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        objectArray = _servers;
        synchronized (_servers) {
            int n = 0;
            while (n < _servers.length) {
                if (_servers[n] == null) {
                    NodeFactory._servers[n] = new NodeImpl(string, (InetAddress)object);
                    if (principal instanceof User) {
                        ((NodeImpl)_servers[n]).setUser((User)principal);
                    } else if (principal instanceof Application) {
                        ((NodeImpl)_servers[n]).setApplication((Application)principal);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return _servers[n];
                }
                ++n;
            }
            Node[] nodeArray = _servers;
            _servers = new Node[nodeArray.length + 1];
            int n2 = 0;
            while (n2 < nodeArray.length) {
                NodeFactory._servers[n2] = nodeArray[n2];
                ++n2;
            }
            NodeFactory._servers[nodeArray.length] = new NodeImpl(string, (InetAddress)object);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return _servers[nodeArray.length];
        }
    }

    private static Node containsNode(String string) {
        return NodeFactory.containsNode(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node containsNode(String string, Principal principal) {
        Node[] nodeArray = _servers;
        synchronized (_servers) {
            if (string.equals("localhost")) {
                try {
                    string = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            InetAddress[] inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(string);
                inetAddressArray = InetAddress.getAllByName(inetAddressArray[0].getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            int n = 0;
            while (n < _servers.length) {
                if (_servers[n] != null) {
                    int n2 = 0;
                    while (n2 < inetAddressArray.length) {
                        InetAddress inetAddress = _servers[n].getInetAddress();
                        if (inetAddressArray[n2].equals(inetAddress)) {
                            if (principal == null) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return _servers[n];
                            }
                            if (principal instanceof User && _servers[n].getUser() != null) {
                                if (principal.getName().equals(_servers[n].getUser().getName())) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return _servers[n];
                                }
                            } else if (principal instanceof Application && _servers[n].getApplication() != null && principal.getName().equals(_servers[n].getApplication().getName())) {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return _servers[n];
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public static Node getNode(InetAddress inetAddress) {
        return NodeFactory.getNode(inetAddress, null);
    }

    public static Node getNode(InetAddress inetAddress, Principal principal) {
        return NodeFactory.containsNode(inetAddress.getHostName(), principal);
    }

    public static Node getNode(String string, Principal principal) throws UnknownHostException {
        return NodeFactory.getNode(InetAddress.getByName(string), principal);
    }

    static {
        try {
            NodeFactory._servers[0] = NodeFactory.createNode(InetAddress.getLocalHost());
        }
        catch (UnknownHostException unknownHostException) {}
    }
}

